/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageQueryResult;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageResponse;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class Response
implements ILineageResponse {
    private Collection<ILineageQueryResult> m_queryResults = new Vector<ILineageQueryResult>();
    private LinkedHashMap<String, ILineageObject> m_objectsMap = new LinkedHashMap();

    @Override
    public Collection<ILineageQueryResult> getQueryResults() {
        return this.m_queryResults;
    }

    @Override
    public void addQueryResult(ILineageQueryResult queryResult) {
        this.m_queryResults.add(queryResult);
    }

    @Override
    public Collection<ILineageQueryResult> getQueryResults(ILineageObjectQuery objectQuery) {
        Vector<ILineageQueryResult> foundQueryResults = new Vector<ILineageQueryResult>();
        for (ILineageQueryResult queryResult : this.m_queryResults) {
            String objectQueryRef;
            String objectQueryId = objectQuery.getId();
            if (!objectQueryId.equals(objectQueryRef = queryResult.getObjectQueryRef())) continue;
            foundQueryResults.add(queryResult);
        }
        return foundQueryResults;
    }

    @Override
    public Collection<ILineageObject> getLineageObjects() {
        return this.m_objectsMap.values();
    }

    @Override
    public Map<String, ILineageObject> getObjects() {
        return this.m_objectsMap;
    }

    @Override
    public ILineageObject getLineageObject(String id) {
        ILineageObject lineageObject = this.m_objectsMap.get(id);
        return lineageObject;
    }

    @Override
    public void addLineageObject(ILineageObject lineageObject) {
        String lineageObjectId = lineageObject.getId();
        this.m_objectsMap.put(lineageObjectId, lineageObject);
    }
}

