/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.api.ser.ISerializer;
import com.cognos.metadataService.command.api.ser.SerializationElement;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectMissingId;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageQueryResult;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageResponse;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.Collection;

public class ResponseSerializer {
    ISerializer m_serializer;

    public ResponseSerializer(ISerializer deserializer) {
        this.m_serializer = deserializer;
    }

    public SerializationElement serialize(ILineageResponse lineageResponse) {
        SerializationElement responseElem = this.m_serializer.init("lineageResponse");
        for (ILineageQueryResult queryResult : lineageResponse.getQueryResults()) {
            this.serializeQueryResult(responseElem, queryResult);
        }
        Collection<ILineageObject> lineageObjects = lineageResponse.getLineageObjects();
        for (ILineageObject lineageObj : lineageObjects) {
            this.serializeLineageObject(responseElem, lineageObj);
        }
        this.m_serializer.endElement(responseElem);
        return responseElem;
    }

    private void serializeQueryResult(SerializationElement responseElem, ILineageQueryResult queryResult) {
        SerializationElement queryResultElem = this.m_serializer.addElement(responseElem, "queryResult");
        this.m_serializer.addElementWithText(queryResultElem, "objectRef", queryResult.getLineageObject().getId());
        String objectQueryRef = queryResult.getObjectQueryRef();
        if (objectQueryRef != null) {
            this.m_serializer.addElementWithText(queryResultElem, "objectQueryRef", objectQueryRef);
        }
    }

    private void serializeLineageObject(SerializationElement responseElem, ILineageObject lineageObj) {
        ILineageObject parent;
        Collection<ILineageObject> transformationSources;
        SerializationElement lineageObjElem = this.m_serializer.addElement(responseElem, "object");
        this.m_serializer.addAttribute(lineageObjElem, "id", lineageObj.getId());
        this.m_serializer.addElementWithText(lineageObjElem, "name", lineageObj.getName());
        this.m_serializer.addElementWithText(lineageObjElem, "type", lineageObj.getType());
        this.processProperties(lineageObjElem, lineageObj.getProperties());
        ILineageTransformation transformation = lineageObj.getTransformation();
        if (transformation != null && !(transformationSources = transformation.getTransformationSources()).isEmpty()) {
            SerializationElement transformationElem = this.m_serializer.addElement(lineageObjElem, "transformation");
            this.m_serializer.addElementWithText(transformationElem, "type", transformation.getType());
            this.processProperties(transformationElem, transformation.getProperties());
            for (ILineageObject transformationSourceObj : transformationSources) {
                this.m_serializer.addElementWithText(transformationElem, "objectRef", transformationSourceObj.getId());
            }
            this.m_serializer.endElement(transformationElem);
        }
        if ((parent = lineageObj.getParent()) != null) {
            this.m_serializer.addElementWithText(lineageObjElem, "parentRef", parent.getId());
        }
        Collection<ILineageObject> children = lineageObj.getChildren();
        for (ILineageObject child : children) {
            String className = child.getClass().toString();
            if (className.endsWith("com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectMissingId")) {
                MfwLineageObjectMissingId obj = (MfwLineageObjectMissingId)child;
                MFWInfo info = obj.getNode().getInfo();
                if (info.getRID() != MFWModelRes.getInstance().RID_querySubjectRefs) {
                    this.m_serializer.addElementWithText(lineageObjElem, "childRef", child.getId());
                    continue;
                }
                ILineageTransformation querySetTransformation = obj.getTransformation();
                Collection<ILineageObject> sources = querySetTransformation.getTransformationSources();
                for (ILineageObject objSource : sources) {
                    this.m_serializer.addElementWithText(lineageObjElem, "childRef", objSource.getId());
                }
                continue;
            }
            this.m_serializer.addElementWithText(lineageObjElem, "childRef", child.getId());
        }
        this.m_serializer.endElement(lineageObjElem);
    }

    private void processProperties(SerializationElement parentElem, Collection<ILineageProperty> properties) {
        for (ILineageProperty property : properties) {
            String displayValue;
            String displayName;
            SerializationElement propertyElem = this.m_serializer.addElement(parentElem, "property");
            this.m_serializer.addAttribute(propertyElem, "name", property.getName());
            if (property.getValue() != null) {
                this.m_serializer.setElementText(propertyElem, property.getValue());
            }
            if ((displayName = property.getDisplayName()) != null) {
                this.m_serializer.addAttribute(propertyElem, "displayName", displayName);
            }
            if ((displayValue = property.getDisplayValue()) != null) {
                this.m_serializer.addAttribute(propertyElem, "displayValue", displayValue);
            }
            this.m_serializer.endElement(propertyElem);
        }
    }
}

