/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.adapters.response;

import com.cognos.metadataService.command.lineage.adapters.response.LineageObjectId;
import com.cognos.metadataService.sources.mfw.NodeQuery;
import com.cognos.metadataService.sources.mfw.PropertyNodeRetrieval;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePart;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceNamePartList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ViaShortcutStack {
    private MFWGateway m_mfwGateway;
    private Stack<MFWNodeHandle> m_shortcutStack = new Stack();
    private Stack<MFWNodeHandle> m_shortcutTargetStack = new Stack();

    public ViaShortcutStack(MFWGateway mfwGateway, LineageObjectId objectId) {
        this.m_mfwGateway = mfwGateway;
        this.initialize(objectId);
    }

    public ViaShortcutStack(MFWGateway mfwGateway, MFWNodeHandle shortcutNodeHandle) {
        this.m_mfwGateway = mfwGateway;
        this.m_shortcutStack.push(shortcutNodeHandle);
        PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, shortcutNodeHandle, MFWModelRes.getInstance().RID_refobj);
        NodeQuery nodeQuery = new NodeQuery(this.m_mfwGateway);
        String value = propertyNodeRetrieval.getValue();
        LineageObjectId lineageObjectId = new LineageObjectId(value);
        IV5UniqueNamePiece namedReference = lineageObjectId.getNamedReference();
        MFWNodeHandle findObjectNodeForId = nodeQuery.findObjectNodeForId(namedReference);
        this.m_shortcutTargetStack.push(findObjectNodeForId);
    }

    public MFWNodeHandle getCurrentShortcutNode() {
        return this.m_shortcutStack.empty() ? null : this.m_shortcutStack.peek();
    }

    public MFWNodeHandle getCurrentShortcutTargetNode() {
        return this.m_shortcutTargetStack.empty() ? null : this.m_shortcutTargetStack.peek();
    }

    public void push(MFWNodeHandle shortcutNode) {
        this.m_shortcutStack.push(shortcutNode);
    }

    public void pop() {
        if (this.m_shortcutStack.empty()) {
            this.m_shortcutStack.pop();
        }
    }

    private void initialize(LineageObjectId m_objectId) {
        NodeQuery m_nodeQuery = new NodeQuery(this.m_mfwGateway);
        List<IV5UniqueNamePart> shortcutIdParts = new ArrayList<IV5UniqueNamePart>();
        boolean bContinue = true;
        Iterator<IV5UniqueNamePart> m_idPartsIter = m_objectId.getParts().iterator();
        while (bContinue && m_idPartsIter.hasNext()) {
            shortcutIdParts.add(m_idPartsIter.next());
            V5UniqueNamePieceNamePartList shortcutIdNamedReference = new V5UniqueNamePieceNamePartList(shortcutIdParts);
            LineageObjectId shortcutId = new LineageObjectId((IV5UniqueNamePiece)shortcutIdNamedReference);
            IV5UniqueNamePiece shortcutReference = shortcutId.getNamedReference();
            MFWNodeHandle currentObj = m_nodeQuery.findObjectNodeForId(shortcutReference);
            if (currentObj == null) {
                bContinue = false;
                continue;
            }
            if (currentObj.getInfo().getRID() == MFWModelRes.getInstance().RID_shortcut) {
                PropertyNodeRetrieval propertyNodeRetrieval = new PropertyNodeRetrieval(this.m_mfwGateway, currentObj, MFWModelRes.getInstance().RID_refobj);
                LineageObjectId targetId = new LineageObjectId(propertyNodeRetrieval.getValue());
                IV5UniqueNamePiece targetReference = targetId.getNamedReference();
                MFWNodeHandle targetNode = m_nodeQuery.findObjectNodeForId(targetReference);
                if (targetNode == null) continue;
                this.m_shortcutStack.push(currentObj);
                this.m_shortcutTargetStack.push(targetNode);
                shortcutIdParts.clear();
                shortcutIdParts = targetId.getParts();
                continue;
            }
            if (currentObj.getInfo().getRID() != MFWModelRes.getInstance().RID_folder || currentObj.getInfo().getRID() != MFWModelRes.getInstance().RID_queryItemFolder) continue;
            shortcutIdParts.remove(shortcutIdParts.size() - 1);
        }
    }
}

