/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.algorithm;

import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.lineage.adapters.response.CMLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageObjectDecoratorReport;
import com.cognos.metadataService.command.lineage.algorithm.IColleague;
import com.cognos.metadataService.command.lineage.algorithm.IMediatorCallback;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.command.lineage.source.model.LineageProps;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.util.misc.AxisTypesHelper;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.LinkedList;

public class ContextTraversal
implements IColleague {
    ICMAccess m_cmAccessStrategy;
    LineageProps m_parentObjRules = new LineageProps();
    LocalizedSchemaValues m_localizedSchemaValues;

    @Override
    public void initialize(IMediatorCallback mediator) {
        this.m_cmAccessStrategy = mediator.getGlobalHelpers().getCmAccessStrategy();
        this.m_localizedSchemaValues = mediator.getGlobalHelpers().getLocalizedSchemaValues();
    }

    @Override
    public IMfwLineageObject traverse(IMfwLineageObject lineageObject, IMediatorCallback mediator) {
        IMfwLineageObject returnObj = lineageObject;
        IMfwLineageObject existingObj = mediator.getMfwLineageObject(lineageObject.getId());
        if (existingObj != null) {
            if (lineageObject.getTransformation() != null) {
                existingObj.setTransformation(lineageObject.getTransformation());
                lineageObject = existingObj;
            }
        } else {
            IMfwLineageObject ancestorObj;
            CMLineageObject cmLineageObj = this.m_cmAccessStrategy.getContextObject(lineageObject);
            boolean bReport = !AxisTypesHelper.getOMClassTypeName(_package.class).equals(cmLineageObj.getCmObj().getObjectClass()) && !AxisTypesHelper.getOMClassTypeName(Model.class).equals(cmLineageObj.getCmObj().getObjectClass());
            LinkedList<IMfwLineageObject> sourceModelAncestry = this.getSourceAncestry(lineageObject);
            ILineageObject parentLineageObjForNextAncestor = cmLineageObj;
            IMfwLineageObject iMfwLineageObject = ancestorObj = sourceModelAncestry.isEmpty() ? null : sourceModelAncestry.removeLast();
            while (ancestorObj != null) {
                IMfwLineageObject lineageObj = mediator.getMfwLineageObject(ancestorObj.getObjectId().getValue());
                if (lineageObj == null) {
                    lineageObj = this.handleNewObj(ancestorObj, parentLineageObjForNextAncestor, bReport, mediator);
                }
                if (lineageObj != null) {
                    parentLineageObjForNextAncestor = lineageObj;
                }
                ancestorObj = sourceModelAncestry.isEmpty() ? null : sourceModelAncestry.removeLast();
            }
            returnObj = this.handleNewObj(lineageObject, parentLineageObjForNextAncestor, bReport, mediator);
        }
        return returnObj;
    }

    private IMfwLineageObject handleNewObj(IMfwLineageObject lineageObjectBinding, ILineageObject parentLineageObj, boolean bReport, IMediatorCallback mediator) {
        if (lineageObjectBinding != null) {
            if (bReport && MFWModelRes.getInstance().RID_namespace == lineageObjectBinding.getNode().getInfo().getRID()) {
                lineageObjectBinding = null;
            } else {
                if (bReport) {
                    lineageObjectBinding = new MfwLineageObjectDecoratorReport(lineageObjectBinding, this.m_localizedSchemaValues);
                }
                lineageObjectBinding.setParent(parentLineageObj);
                parentLineageObj.addChild(lineageObjectBinding);
                mediator.processMfwLineageObj(lineageObjectBinding, this);
            }
        }
        return lineageObjectBinding;
    }

    public LinkedList<IMfwLineageObject> getSourceAncestry(IMfwLineageObject mfwObj) {
        LinkedList<IMfwLineageObject> sourceModelAncestry = new LinkedList<IMfwLineageObject>();
        for (IMfwLineageObject currentAncestor = mfwObj.buildParent(); currentAncestor != null && this.m_parentObjRules.getObjectInfo(currentAncestor.getNode().getInfo().getRID()) != null; currentAncestor = currentAncestor.buildParent()) {
            sourceModelAncestry.add(currentAncestor);
        }
        return sourceModelAncestry;
    }
}

