/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.algorithm;

import com.cognos.metadataService.command.lineage.adapters.request.ObjectQuery;
import com.cognos.metadataService.command.lineage.adapters.response.CMLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.metadataService.command.lineage.adapters.response.QueryResult;
import com.cognos.metadataService.command.lineage.adapters.response.Response;
import com.cognos.metadataService.command.lineage.algorithm.IColleague;
import com.cognos.metadataService.command.lineage.algorithm.IMediatorCallback;
import com.cognos.metadataService.command.lineage.algorithm.IMfwLineageConnection;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageResponse;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.sources.mfw.MultilingualPropertyTranslater;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.Collection;

public class Mediator
implements IMediatorCallback {
    MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();
    IColleague m_transformationTraversal;
    IColleague m_contextTraversal;
    IColleague m_embeddedFilterTraversal;
    ILineageResponse m_response;
    LocalizedSchemaValues m_localizedSchemaValues;
    MultilingualPropertyTranslater m_multilingualPropertyTranslater;
    MfwLineageQuery m_objectFactory;
    IMfwLineageConnection m_globalHelpers;

    public Mediator(IMfwLineageConnection mdsrvConnection, IColleague transformationTraversal, IColleague contextTraversal, IColleague embeddFilterTraversal) {
        ICMAccess cmAccessStrategy;
        this.m_objectFactory = mdsrvConnection.getLineageObjectFactory();
        this.m_globalHelpers = mdsrvConnection;
        this.m_transformationTraversal = transformationTraversal;
        this.m_contextTraversal = contextTraversal;
        this.m_embeddedFilterTraversal = embeddFilterTraversal;
        this.m_response = new Response();
        ICMAccess cmAccess = cmAccessStrategy = mdsrvConnection.getCmAccessStrategy();
        if (cmAccess != null) {
            Collection<ILineageObject> lineageObjects = cmAccessStrategy.getLineageObjects();
            for (ILineageObject lineageObj : lineageObjects) {
                this.m_response.addLineageObject(lineageObj);
            }
        }
        this.m_transformationTraversal.initialize(this);
        this.m_contextTraversal.initialize(this);
        this.m_embeddedFilterTraversal.initialize(this);
    }

    public void runObjectQuery(ObjectQuery oq) {
        ServicePerfMarker m_perfMarker = new ServicePerfMarker(this.getClass().getName() + ".addObjectQuery, id: " + oq.getId(), "ENTER");
        Collection<IMfwLineageObject> referencedObjects = oq.getReferencedObjects();
        for (IMfwLineageObject lineageObject : referencedObjects) {
            if (lineageObject == null) {
                this.m_logUtil.unexpectedSituation("ModelLineageQuery.queryObject: null object received!!!");
                continue;
            }
            QueryResult queryResult = new QueryResult();
            queryResult.setObjectQuery(oq.getId());
            this.m_contextTraversal.traverse(lineageObject, this);
            this.m_transformationTraversal.traverse(lineageObject, this);
            queryResult.setLineageObject(lineageObject);
            this.m_response.addQueryResult(queryResult);
        }
        m_perfMarker.endPerf();
    }

    public ILineageResponse getResponse() {
        return this.m_response;
    }

    @Override
    public IMfwLineageObject getMfwLineageObject(String id) {
        return (IMfwLineageObject)this.m_response.getLineageObject(id);
    }

    public CMLineageObject addCMLineageObject(CMLineageObject lineageObject, IColleague colleague) {
        this.m_response.addLineageObject(lineageObject);
        return lineageObject;
    }

    @Override
    public IMfwLineageObject processMfwLineageObj(IMfwLineageObject lineageObject, IColleague originator) {
        IMfwLineageObject resultObj = this.getMfwLineageObject(lineageObject.getId());
        IColleague[] colleaguesToInvoke = new IColleague[]{};
        if (originator == this.m_transformationTraversal || originator == this.m_embeddedFilterTraversal) {
            if (resultObj == null) {
                resultObj = lineageObject;
                colleaguesToInvoke = new IColleague[]{this.m_contextTraversal, this.m_transformationTraversal};
            } else if (resultObj.getTransformation() == null && lineageObject.getTransformation() != null) {
                resultObj.setTransformation(lineageObject.getTransformation());
                colleaguesToInvoke = new IColleague[]{this.m_transformationTraversal};
            }
        } else if (originator == this.m_contextTraversal && (resultObj = this.getMfwLineageObject(lineageObject.getId())) == null) {
            resultObj = lineageObject;
            MFWInfo info = resultObj.getNode().getInfo();
            if (info.getRID() != MFWModelRes.getInstance().RID_querySubjectRefs) {
                this.m_response.addLineageObject(lineageObject);
            }
            colleaguesToInvoke = new IColleague[]{this.m_embeddedFilterTraversal};
        }
        this.invokeColleagues(resultObj, colleaguesToInvoke);
        return resultObj;
    }

    private void invokeColleagues(IMfwLineageObject lineageObj, IColleague[] colleagues) {
        for (int colleaguesIdx = 0; colleaguesIdx < colleagues.length; ++colleaguesIdx) {
            colleagues[colleaguesIdx].traverse(lineageObj, this);
        }
    }

    @Override
    public MfwLineageQuery getObjectFactory() {
        return this.m_objectFactory;
    }

    @Override
    public IMfwLineageConnection getGlobalHelpers() {
        return this.m_globalHelpers;
    }
}

