/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.algorithm;

import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageProperty;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.metadataService.command.lineage.adapters.response.MfwTransformation;
import com.cognos.metadataService.command.lineage.adapters.response.MfwTransformationSourceHelper;
import com.cognos.metadataService.command.lineage.algorithm.IColleague;
import com.cognos.metadataService.command.lineage.algorithm.IMediatorCallback;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.metadataService.command.lineage.source.model.MfwLineageExpression;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TransformationTraversal
implements IColleague {
    MFWGateway m_mfwGateway;
    MfwLineageQuery m_lineageObjectFactory;
    LocalizedSchemaValues m_localizedSchemaValues;

    @Override
    public void initialize(IMediatorCallback mediator) {
        this.m_mfwGateway = mediator.getGlobalHelpers().getMfwGateway();
        this.m_lineageObjectFactory = mediator.getObjectFactory();
        this.m_localizedSchemaValues = mediator.getGlobalHelpers().getLocalizedSchemaValues();
    }

    @Override
    public IMfwLineageObject traverse(IMfwLineageObject boundLineageObject, IMediatorCallback mediator) {
        ArrayList<IMfwLineageObject> transformationSourcesList = new ArrayList<IMfwLineageObject>();
        MfwTransformation transformation = null;
        List<MfwLineageProperty> transformationProperties = boundLineageObject.getTransformationProperties();
        if (transformationProperties.isEmpty()) {
            MfwTransformationSourceHelper transformationSourceHelper = new MfwTransformationSourceHelper(this.m_mfwGateway);
            transformationSourcesList.addAll(transformationSourceHelper.getSourcesDeep(this.m_lineageObjectFactory, boundLineageObject));
        } else {
            for (MfwLineageProperty transformationProperty : transformationProperties) {
                MfwLineageExpression expressionParser;
                ILineageTransformation boundTransformation = boundLineageObject.getTransformation();
                if (boundTransformation == null) {
                    transformation = new MfwTransformation(boundLineageObject, transformationProperty);
                    boundLineageObject.setTransformation(transformation);
                }
                if (transformation == null) {
                    transformation = (MfwTransformation)boundLineageObject.getTransformation();
                }
                transformationSourcesList.addAll(transformation.getSourceModelObjects(this.m_mfwGateway, this.m_lineageObjectFactory));
                MFWInfo info = boundLineageObject.getNode().getInfo();
                if (info.getRID() != MFWModelRes.getInstance().RID_querySubjectRefs || (expressionParser = transformationProperty.getExpressionParser()) == null) continue;
                Collection<IMfwLineageObject> referencedObjects = expressionParser.getReferencedObjects();
                for (IMfwLineageObject currentObj : referencedObjects) {
                    transformationSourcesList.add(currentObj);
                }
            }
        }
        if (!transformationSourcesList.isEmpty()) {
            this.processTransformationSources(mediator, transformationSourcesList, transformation);
        }
        return boundLineageObject;
    }

    private void processTransformationSources(IMediatorCallback mediator, Collection<IMfwLineageObject> transformationSources, MfwTransformation transformation) {
        for (IMfwLineageObject transformationSource : transformationSources) {
            IMfwLineageObject resultObj = mediator.processMfwLineageObj(transformationSource, this);
            if (transformation == null || resultObj == null) continue;
            transformation.addLineageObj(resultObj);
        }
    }
}

