/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.lineage.api.client.LineagePropertyListParent;
import com.cognos.metadataService.command.lineage.api.client.Transformation;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectBase;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class LineageObject
extends LineagePropertyListParent
implements ILineageObjectBase {
    private String m_id;
    private String m_name;
    private String m_type;
    private String m_parentRef;
    private Transformation m_transformation;
    private Collection m_childRefs = new LinkedHashSet();

    public LineageObject() {
    }

    public LineageObject(ILineageObject iObject) {
        this.setId(iObject.getId());
        this.setName(iObject.getName());
        this.setType(iObject.getType());
        if (iObject.getType().equals("package")) {
            if (iObject.getParent() == null) {
                this.setParentRef("[Report]");
            }
        } else {
            this.setParentRef(iObject.getParent().getId());
        }
        for (ILineageObject child : iObject.getChildren()) {
            this.addChildRef(child.getId());
        }
        for (ILineageProperty iProp : iObject.getProperties()) {
            this.addProperty(iProp.getName(), iProp.getDisplayName(), iProp.getValue(), iProp.getDisplayValue());
        }
        if (iObject.getTransformation() != null) {
            Transformation trans = new Transformation(iObject.getTransformation());
            this.setTransformation(trans);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LineageObject linObj = (LineageObject)obj;
        return this.getId().equals(linObj.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static LineageObject create(ILineageObjectBase iLineageObjectBase) {
        LineageObject obj = new LineageObject();
        obj.setId(iLineageObjectBase.getId());
        obj.setName(iLineageObjectBase.getName());
        obj.setType(iLineageObjectBase.getType());
        return obj;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public Transformation getTransformation() {
        return this.m_transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.m_transformation = transformation;
    }

    public String getParentRef() {
        return this.m_parentRef;
    }

    public void setParentRef(String parentRef) {
        this.m_parentRef = parentRef;
    }

    public Collection getChildRefs() {
        return this.m_childRefs;
    }

    public void addChildRef(String childRef) {
        this.m_childRefs.add(childRef);
    }

    @Override
    public void buildFromInstanceElem(Element rootElem) {
        super.buildFromInstanceElem(rootElem);
        this.m_id = rootElem.attributeValue("id");
        List childElems = rootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element childElem = (Element)childElemsIter.next();
            String childElemName = childElem.getName();
            if (childElemName.equals("name")) {
                this.m_name = childElem.getText();
                continue;
            }
            if (childElemName.equals("type")) {
                this.m_type = childElem.getText();
                continue;
            }
            if (childElemName.equals("transformation")) {
                Transformation transformation = new Transformation();
                transformation.buildFromInstanceElem(childElem);
                this.setTransformation(transformation);
                continue;
            }
            if (childElemName.equals("parentRef")) {
                this.m_parentRef = childElem.getText();
                continue;
            }
            if (!childElemName.equals("childRef")) continue;
            this.addChildRef(childElem.getText());
        }
    }

    public Element dumpToParentElem(Element targetParentElem) {
        String parentRef;
        Element rootElem = targetParentElem.addElement("object");
        rootElem.addAttribute("id", this.getId());
        rootElem.addElement("name").addText(this.getName());
        rootElem.addElement("type").addText(this.getType());
        super.dumpToInstanceElem(rootElem);
        if (this.m_transformation != null) {
            this.m_transformation.dumpToParentElem(rootElem);
        }
        if ((parentRef = this.getParentRef()) != null && this.getParentRef().length() > 0) {
            rootElem.addElement("parentRef").addText(this.getParentRef());
        }
        Iterator childRefsIter = this.getChildRefs().iterator();
        while (childRefsIter.hasNext()) {
            rootElem.addElement("childRef").addText((String)childRefsIter.next());
        }
        return rootElem;
    }
}

