/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.api.IElementSerializable;
import com.cognos.metadataService.command.lineage.api.client.LineageParamList;
import com.cognos.metadataService.command.lineage.api.client.RequestQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestBase;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestQuery;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LineageRequest
implements ILineageRequestBase,
IElementSerializable {
    private String m_version;
    private String m_service;
    private String m_sQuerySet;
    private LineageParamList m_listParams = new LineageParamList();
    private Collection<RequestQuery> m_objectQueryList = new Vector<RequestQuery>();

    public LineageParamList getLineageParamList() {
        return this.m_listParams;
    }

    public boolean addObjectQuery(RequestQuery objectQuery) {
        return this.m_objectQueryList.add(objectQuery);
    }

    public Collection<RequestQuery> getObjectQueryList() {
        return this.m_objectQueryList;
    }

    @Override
    public Collection<ILineageRequestQuery> getRequestQueryList() {
        Vector<ILineageRequestQuery> requestQueryList = new Vector<ILineageRequestQuery>();
        for (ILineageRequestQuery iLineageRequestQuery : this.m_objectQueryList) {
            requestQueryList.add(iLineageRequestQuery);
        }
        return requestQueryList;
    }

    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        this.m_service = service;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    @Override
    public String getQuerySet() {
        return this.m_sQuerySet;
    }

    public void setQuerySet(String sQuerySet) {
        this.m_sQuerySet = sQuerySet;
    }

    public boolean isUsingQuerySet() {
        return this.getQuerySet() != null;
    }

    public void addConnectionParam(String name, String value) {
        this.m_listParams.addParam(name, value);
    }

    public String getConnectionParam(String name) {
        String paramValueObj;
        String value = null;
        if (this.m_listParams != null && (paramValueObj = this.m_listParams.getParamValue(name)) != null) {
            value = paramValueObj.toString();
        }
        return value;
    }

    @Override
    public void buildFromInstanceElem(Element requestRootElem) {
        this.reset();
        this.m_version = requestRootElem.attributeValue("version");
        if (this.m_version == null || this.m_version.length() == 0) {
            // empty if block
        }
        List childElems = requestRootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element currentChildElem = (Element)childElemsIter.next();
            String elemName = currentChildElem.getName();
            if (elemName.equals("service")) {
                this.m_service = currentChildElem.getText();
                continue;
            }
            if (elemName.equals("connection")) {
                this.m_listParams = new LineageParamList();
                this.m_listParams.addObjectsForParentElem(currentChildElem);
                continue;
            }
            if (elemName.equals("V5QuerySet")) {
                this.m_sQuerySet = currentChildElem.getText();
                continue;
            }
            if (!elemName.equals("objectQuery")) continue;
            RequestQuery objectQuery = new RequestQuery();
            objectQuery.buildFromInstanceElem(currentChildElem);
            this.addObjectQuery(objectQuery);
        }
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element rootElem = targetParentElem == null ? DocumentHelper.createElement((String)"lineageRequest") : targetParentElem.addElement("lineageRequest");
        rootElem.addAttribute("version", this.getVersion());
        if (this.getService() != null) {
            rootElem.addElement("service").addText(this.getService());
        }
        if (this.isUsingQuerySet()) {
            rootElem.addElement("V5QuerySet").addText(this.getQuerySet());
        }
        if (this.m_listParams != null && this.m_listParams.getEntriesCollection().size() > 0) {
            Element connectionElement = rootElem.addElement(new String("connection"));
            this.m_listParams.dumpToParentElem(connectionElement);
        }
        if (this.m_objectQueryList != null) {
            for (RequestQuery objectQuery : this.m_objectQueryList) {
                objectQuery.dumpToParentElem(rootElem);
            }
        }
        return rootElem;
    }

    void reset() {
        this.m_version = null;
        this.m_service = null;
        this.m_listParams = null;
        this.m_sQuerySet = null;
    }
}

