/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.api.IElementSerializable;
import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.TransformationSource;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageResponse;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LineageResponse
implements IElementSerializable {
    private Collection<QueryResult> m_queryResults = new LinkedHashSet<QueryResult>();
    private Map<String, LineageObject> m_objectMap = new LinkedHashMap<String, LineageObject>();
    private String m_sReportPath;
    private String m_sPackagePath;

    public String getReportPath() {
        return this.m_sReportPath;
    }

    public String getPackagePath() {
        return this.m_sPackagePath;
    }

    public void setReportPath(String sReportPath) {
        this.m_sReportPath = sReportPath != null ? sReportPath.replace('\"', '\'') : null;
    }

    public void setPackagePath(String sPackagePath) {
        this.m_sPackagePath = sPackagePath != null ? sPackagePath.replace('\"', '\'') : null;
    }

    public Collection<QueryResult> getQueryResults() {
        return this.m_queryResults;
    }

    public void setQueryResults(Collection<QueryResult> queryResults) {
        this.m_queryResults.clear();
        Iterator<QueryResult> queryResultsIter = queryResults.iterator();
        while (queryResultsIter.hasNext()) {
            this.addQueryResult(queryResultsIter.next());
        }
    }

    public void addQueryResult(QueryResult queryResult) {
        this.m_queryResults.add(queryResult);
    }

    public void addObject(LineageObject obj) {
        this.m_objectMap.put(obj.getId(), obj);
    }

    public void setObjectMap(Map<String, LineageObject> lineageObjectMap) {
        this.m_objectMap.putAll(lineageObjectMap);
    }

    public void addObjects(Collection<LineageObject> lineageObjects) {
        Iterator<LineageObject> lineageObjectsIter = lineageObjects.iterator();
        while (lineageObjectsIter.hasNext()) {
            this.addObject(lineageObjectsIter.next());
        }
    }

    public Map<String, LineageObject> getObjects() {
        return this.m_objectMap;
    }

    public LineageObject getObject(String objectRef) {
        LineageObject object = null;
        if (this.m_objectMap != null) {
            object = this.m_objectMap.get(objectRef);
        }
        return object;
    }

    @Override
    public void buildFromInstanceElem(Element requestRootElem) {
        List childElems = requestRootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element currentChildElem = (Element)childElemsIter.next();
            String elemName = currentChildElem.getName();
            if (elemName.equals("queryResult")) {
                QueryResult queryResult = new QueryResult();
                queryResult.buildFromInstanceElem(currentChildElem);
                this.addQueryResult(queryResult);
                continue;
            }
            if (!elemName.equals("object")) continue;
            LineageObject lineageObject = new LineageObject();
            lineageObject.buildFromInstanceElem(currentChildElem);
            this.addObject(lineageObject);
            if (lineageObject.getType().equals("baseReport")) {
                this.setReportPath(lineageObject.getId());
                continue;
            }
            if (!lineageObject.getType().equals("package")) continue;
            this.setPackagePath(lineageObject.getId());
        }
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element rootElem = targetParentElem == null ? DocumentHelper.createElement((String)"lineageResponse") : targetParentElem.addElement("lineageResponse");
        for (QueryResult queryResult : this.m_queryResults) {
            queryResult.dumpToParentElem(rootElem);
        }
        Collection<LineageObject> lineageObjectList = this.m_objectMap.values();
        for (LineageObject lineageObject : lineageObjectList) {
            lineageObject.dumpToParentElem(rootElem);
        }
        return rootElem;
    }

    public void addQueryResults(LineageResponse lineageResponse) {
        Collection<QueryResult> queryResults = this.getQueryResults();
        queryResults.addAll(lineageResponse.getQueryResults());
    }

    public void addObjects(LineageResponse lineageResponse) {
        Map<String, LineageObject> objects = this.getObjects();
        objects.putAll(lineageResponse.getObjects());
        if (this.getReportPath() == null && lineageResponse.getReportPath() != null) {
            this.setReportPath(lineageResponse.getReportPath());
        }
        if (this.getPackagePath() == null && lineageResponse.getPackagePath() != null) {
            this.setPackagePath(lineageResponse.getPackagePath());
        }
    }

    public void addObjects(ILineageResponse iLineageResponse) {
        if (iLineageResponse != null) {
            for (ILineageObject iObject : iLineageResponse.getLineageObjects()) {
                LineageObject linObject = new LineageObject(iObject);
                this.addObject(linObject);
            }
        }
    }

    public Collection<String> getExternalReferences() {
        LinkedHashSet<String> externalRefs = new LinkedHashSet<String>();
        Collection<String> requestedObjectRefs = this.getRequestedObjectRefs();
        for (String sObjId : requestedObjectRefs) {
            LineageObject lineageObject = this.getObjects().get(sObjId);
            this.findExternalReferences(lineageObject, externalRefs);
        }
        return externalRefs;
    }

    private void findExternalReferences(LineageObject lineageObject, Collection<String> externalRefs) {
        for (TransformationSource trSource : lineageObject.getTransformation().getTransformationSourceList()) {
            String sObjectRef = trSource.getObjectRef();
            LineageObject lineageObjectRef = this.getObjects().get(sObjectRef);
            if (lineageObjectRef == null) {
                externalRefs.add(sObjectRef);
                continue;
            }
            this.findExternalReferences(lineageObjectRef, externalRefs);
        }
    }

    public Collection<String> getRequestedObjectRefs() {
        LinkedHashSet<String> requestedObjectRefs = new LinkedHashSet<String>();
        for (QueryResult qr : this.getQueryResults()) {
            requestedObjectRefs.add(qr.getObjectRef());
        }
        return requestedObjectRefs;
    }
}

