/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.api.IElementSerializable;
import com.cognos.metadataService.command.lineage.api.client.LineageParamList;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import org.dom4j.Element;

public class ObjectQuery
implements IElementSerializable {
    public static final String OBJECTQUERY = "objectQuery";
    public static final String ID = "id";
    public static final String PARAM = "param";
    private String m_id = null;
    private LineageParamList m_params = null;

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void addParam(String name, String value) {
        if (this.m_params == null) {
            this.m_params = new LineageParamList();
        }
        this.m_params.addParam(name, value);
    }

    public String getParamValue(String name) {
        return this.m_params == null ? null : this.m_params.getParamValue(name);
    }

    @Override
    public void buildFromInstanceElem(Element objectQueryElem) {
        this.setId(objectQueryElem.attributeValue(ID));
        this.m_params = new LineageParamList();
        this.m_params.addObjectsForParentElem(objectQueryElem);
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element objectQueryElem = targetParentElem.addElement(OBJECTQUERY);
        String id = this.getId();
        if (id != null) {
            objectQueryElem.addAttribute(ID, id);
        }
        if (this.m_params != null) {
            this.m_params.dumpToParentElem(objectQueryElem);
        }
        return objectQueryElem;
    }

    public String getItemId(boolean bAppendReportPrefix) {
        String sItemRefId;
        String sModelItemName = this.m_params.getParamValue("modelItemRef");
        if (sModelItemName != null) {
            sItemRefId = sModelItemName;
        } else {
            String sQueryName = this.m_params.getParamValue("queryName");
            String sItemName = this.m_params.getParamValue("dataItemName");
            sItemRefId = QuerySetIDHelper.buildItemId(sQueryName, sItemName, bAppendReportPrefix);
        }
        if (sItemRefId == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, OBJECTQUERY);
        }
        return sItemRefId;
    }

    public QueryResult convertToQueryResult() {
        QueryResult queryResult = new QueryResult();
        queryResult.setObjectQueryRef(this.getId());
        queryResult.setObjectRef(this.getItemId(true));
        return queryResult;
    }
}

