/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class QuerySetIDHelper
extends MFWCrnIDHelper {
    public static final char CHAR_LEFT_BRACKET = '[';
    public static final char CHAR_RIGHT_BRACKET = ']';

    public static String[] parseNameParts(String objRefValue) {
        ArrayList parts = new ArrayList();
        QuerySetIDHelper.parseID((String)objRefValue, parts);
        String[] res = new String[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            res[i] = (String)parts.get(i);
        }
        return res;
    }

    public static boolean parseExpression(String sExpression, Collection refObjects, String sParentName) {
        if (sExpression == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "querySet");
        }
        boolean isCalcItem = sExpression.indexOf("member(") != -1;
        boolean isObjectReference = false;
        refObjects.clear();
        String sRegex = "\\]\\.\\[";
        String sTempExpression = sExpression.replaceAll(sRegex, "*.*");
        String sObjId = "";
        int nLeftBracket = sTempExpression.indexOf(91, 0);
        int nRightBracket = 0;
        while (nLeftBracket != -1) {
            nRightBracket = sTempExpression.indexOf(93, nLeftBracket);
            if (nRightBracket != -1) {
                boolean bAddObjectRef;
                sObjId = sExpression.substring(nLeftBracket, nRightBracket + 1);
                String[] parts = sObjId.split(sRegex);
                if (!isCalcItem) {
                    if (parts.length == 2) {
                        sObjId = "[Report]." + sObjId;
                    } else if (parts.length == 1) {
                        sObjId = "[Report].[" + sParentName + ']' + '.' + sObjId;
                    }
                }
                boolean bl = bAddObjectRef = sObjId.indexOf("@MEMBER") == -1 && sObjId.indexOf("[all]") == -1;
                if (bAddObjectRef) {
                    refObjects.add(sObjId);
                }
                nLeftBracket = sExpression.indexOf(91, nRightBracket);
                continue;
            }
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Invalid expression '" + sExpression + "' in the QuerySet.");
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        if (isCalcItem) {
            Iterator refs = refObjects.iterator();
            while (refs.hasNext()) {
                String ref = (String)refs.next();
                if (!refs.hasNext()) continue;
                refs.remove();
            }
        }
        if (refObjects.size() == 1 && sObjId.equals(sExpression)) {
            isObjectReference = true;
        }
        return isObjectReference;
    }

    public static String buildItemId(String sQueryName, String sItemName, boolean bAppendReportPrefix) {
        if (sQueryName == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("buildItemId: The Query name in the item refID is NULL");
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        StringBuffer buffer = new StringBuffer();
        if (bAppendReportPrefix) {
            buffer.append("[Report]");
            buffer.append('.');
        }
        buffer.append('[');
        buffer.append(sQueryName);
        buffer.append(']');
        if (sItemName != null) {
            buffer.append('.');
            buffer.append('[');
            buffer.append(sItemName);
            buffer.append(']');
        }
        String sItemRefId = buffer.toString();
        return sItemRefId;
    }
}

