/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.client.QuerySetParser;
import com.cognos.metadataService.command.lineage.api.client.ReportQueryObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageQuerySetObject;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class QuerySetObject
implements ILineageQuerySetObject {
    protected int m_nObject = 0;
    protected String m_sExpression;
    protected String m_name;
    protected boolean m_bIsSourceModel = false;
    private boolean m_bTypeObjectReference = false;
    protected ReportQueryObject m_parentObject;
    protected QuerySetParser m_QuerySetParser;
    private Collection<String> m_referencedObjects = new LinkedHashSet<String>();
    protected Map<String, String> m_mapAttributes = new LinkedHashMap<String, String>();
    protected LocalizedSchemaValues m_localizedValues;
    protected LineageObject m_lineageObject;

    public QuerySetObject(ReportQueryObject parentObject) {
        this.m_parentObject = parentObject;
        this.m_QuerySetParser = this.getParent().getParent();
        this.m_localizedValues = this.m_QuerySetParser.getLocalizedValues();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        QuerySetObject objItem = (QuerySetObject)obj;
        return this.getId().equals(objItem.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public QuerySetParser getQuerySetParser() {
        return this.m_QuerySetParser;
    }

    @Override
    public Collection<String> getReferencedObjects() {
        return this.m_referencedObjects;
    }

    public abstract String getItemId(boolean var1);

    @Override
    public String getId() {
        return this.getItemId(true);
    }

    public String getTypedItemId(boolean bAppendReportPrefix) {
        String sItemRefId = QuerySetIDHelper.buildItemId(this.m_parentObject.getName(), this.getType(), bAppendReportPrefix);
        sItemRefId = QuerySetIDHelper.addEntryToID((String)sItemRefId, (String)Integer.toString(this.m_nObject));
        return sItemRefId;
    }

    public String getTypedName() {
        String sDispName = this.getQuerySetParser().getLocalizedString(this.getType());
        sDispName = sDispName + " " + this.m_nObject;
        return sDispName;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public abstract String getType();

    public String getParentRef() {
        return this.m_parentObject.getId();
    }

    public ReportQueryObject getParent() {
        return this.m_parentObject;
    }

    @Override
    public String getExpression() {
        return this.m_sExpression;
    }

    public String setExpression(String sExpression) {
        this.m_sExpression = sExpression;
        return this.m_sExpression;
    }

    public boolean isTypeObjectReference() {
        return this.m_bTypeObjectReference;
    }

    public boolean hasReferencedObjects() {
        return this.m_referencedObjects.size() > 0;
    }

    @Override
    public void buildFromInstanceElem(Element rootElem) {
        Iterator it = rootElem.attributeIterator();
        while (it.hasNext()) {
            Attribute att = (Attribute)it.next();
            this.m_mapAttributes.put(att.getName(), att.getValue());
        }
    }

    @Override
    public LineageObject convertToLineageObject() {
        if (this.m_lineageObject == null) {
            this.m_lineageObject = LineageObject.create(this);
            this.m_lineageObject.setParentRef(this.getParentRef());
            LocalizedSchemaValues localizedValues = this.getQuerySetParser().getLocalizedValues();
            String sTypeDispName = localizedValues.getMdsrvStrings().getLocalizedValue(QuerySetParser.MSGPREFIX + this.getType());
            this.m_lineageObject.addProperty("objectType", localizedValues.getLocalizedObjectTypePropertyName(), this.getType(), sTypeDispName);
            this.m_lineageObject.addProperty("expression", localizedValues.getLocalizedLineageObjectExpressionObjectName(), this.getExpression(), null);
            for (String sAttName : this.m_mapAttributes.keySet()) {
                String sAttDispValue;
                String sAttValue = this.m_mapAttributes.get(sAttName);
                if (sAttName.equals("name") || sAttValue.length() == 0) continue;
                String sAttDispName = localizedValues.getMdsrvStrings().getLocalizedValue(QuerySetParser.MSGPREFIX + sAttName);
                if (sAttDispName == null) {
                    sAttDispName = sAttName;
                }
                if ((sAttDispValue = localizedValues.getMdsrvStrings().getLocalizedValue(QuerySetParser.MSGPREFIX + sAttValue)) == null || sAttDispValue.indexOf("MSR_AU") != -1) {
                    sAttDispValue = sAttValue;
                }
                this.m_lineageObject.addProperty(sAttName, sAttDispName, sAttValue, sAttDispValue);
            }
        }
        return this.m_lineageObject;
    }

    public boolean parseExpression(String sExpression) {
        boolean bIsObjectReference = false;
        this.m_bTypeObjectReference = bIsObjectReference = this.getQuerySetParser().parseExpression(sExpression, this.m_referencedObjects, this.getParent().getName());
        return bIsObjectReference;
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element rootElem = targetParentElem.addElement(this.getType());
        for (String sAttName : this.m_mapAttributes.keySet()) {
            String sAttValue = this.m_mapAttributes.get(sAttName);
            rootElem.addAttribute(sAttName, sAttValue);
        }
        return rootElem;
    }

    public boolean hasOneOfObjectRefs(Collection<String> objectRefs) {
        for (String sObjRef : objectRefs) {
            for (String sRefObjId : this.m_referencedObjects) {
                if (!sRefObjId.equals(sObjRef)) continue;
                return true;
            }
        }
        return false;
    }
}

