/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.lineage.adapters.request.Request;
import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.LineageRequest;
import com.cognos.metadataService.command.lineage.api.client.LineageResponse;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.client.QuerySetObject;
import com.cognos.metadataService.command.lineage.api.client.ReportQueryObject;
import com.cognos.metadataService.command.lineage.api.client.RequestQuery;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageQuerySetObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestBase;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestQuery;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.ui.util.DOMUtil;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueNameListing;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.parser.V5ExpressionUniqueNameListingParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class QuerySetParser
extends LineageResponse {
    public static final String MSGPREFIX = "MSR_AU" + LocalizedSchemaValues.IDSEPARATOR;
    private static final String EXPRESSIONLOCAL = "expressionLocale";
    private static final String XMLNS = "xmlns";
    private String m_sModelPath;
    private String m_sContentLocale;
    private String m_sXmlns = "http://developer.cognos.com/schemas/report/6.0/";
    private Element m_elemOrigLineageRequest;
    private LineageRequest m_lineageRequest = new LineageRequest();
    private Request m_request;
    private String m_sQuerySet;
    private TreeSet<String> m_setDataItemRefs = new TreeSet();
    private Collection<ReportQueryObject> m_objectQueries = new LinkedHashSet<ReportQueryObject>();
    private Collection<String> m_modelObjectRefs = new LinkedHashSet<String>();
    private Collection<String> m_traversedObjectRefs = new LinkedHashSet<String>();
    private Map<String, QuerySetObject> m_mapDataItems = new LinkedHashMap<String, QuerySetObject>();
    private Map<String, QuerySetObject> m_mapFilters = new LinkedHashMap<String, QuerySetObject>();
    private Map<String, ArrayList<String>> m_mapPathModelObjects = new LinkedHashMap<String, ArrayList<String>>();
    private LocalizedSchemaValues m_localizedSchemaValues;
    private LineageResponse m_lineageResponse = new LineageResponse();
    private boolean m_bDebug = false;

    public QuerySetParser(Element elemLineageRequest) {
        this.m_elemOrigLineageRequest = elemLineageRequest;
        this.m_lineageRequest.buildFromInstanceElem(this.m_elemOrigLineageRequest);
        this.convertRequestToResponse(this.m_lineageRequest);
    }

    public QuerySetParser(LineageRequest lineageRequest) {
        this.m_elemOrigLineageRequest = lineageRequest.dumpToParentElem(null);
        this.m_lineageRequest = lineageRequest;
        this.convertRequestToResponse(this.m_lineageRequest);
    }

    public QuerySetParser(Request request) {
        this.m_request = request;
        this.convertRequestToResponse(this.m_request);
    }

    public void convertRequestToResponse(ILineageRequestBase lineageRequest) {
        this.m_sQuerySet = lineageRequest.getQuerySet();
        for (ILineageRequestQuery requestQuery : lineageRequest.getRequestQueryList()) {
            this.addQueryResult(requestQuery.convertToQueryResult());
        }
        this.m_lineageResponse.addQueryResults(this);
    }

    private void registerReportQueryObject(ReportQueryObject objQuery) {
        this.m_objectQueries.add(objQuery);
        objQuery.registerChildObjects();
    }

    public void registerDataItem(QuerySetObject obj) {
        this.m_mapDataItems.put(obj.getId(), obj);
    }

    public void registerFilter(QuerySetObject obj) {
        this.m_mapFilters.put(obj.getId(), obj);
    }

    public boolean isDataItemRequested(String sQueryName, String sDataItemName) {
        return this.m_request.containsDataItem(sQueryName, sDataItemName);
    }

    public void setContentLocale(String sLocale) {
        this.m_sContentLocale = sLocale;
    }

    public void parse() {
        Element rootQuerySet = DOMUtil.parse(this.m_sQuerySet);
        this.parse(rootQuerySet);
        if (this.m_bDebug) {
            Element elemQuerySet = this.buildQuerySetDom();
            Element elemQuerySetResponse = this.dumpToParentElem(null);
            LineageResponse queryLineageResponse = this.getQueryLineageResponse();
            Element elemLineageResponse = queryLineageResponse.dumpToParentElem(null);
            List<LineageRequest> requests = this.getModelLineageRequests();
            Iterator<String> modelRefs = this.getModelObjectRefs().iterator();
            System.out.println("========================================================");
            System.out.println("Model Object References");
            System.out.println("--------------------------------------------------------");
            while (modelRefs.hasNext()) {
                String sObjRef = modelRefs.next();
                System.out.println("Object " + sObjRef);
            }
            System.out.println("--------------------------------------------------------");
        }
    }

    public String getModelPath() {
        return this.m_sModelPath;
    }

    public Collection<String> getModelObjectRefs() {
        return this.m_modelObjectRefs;
    }

    private boolean findModelObjectRefs(String sObjRefId) {
        this.m_traversedObjectRefs.add(sObjRefId);
        if (!this.m_mapDataItems.containsKey(sObjRefId)) {
            this.m_modelObjectRefs.add(sObjRefId);
            return true;
        }
        boolean bFound = false;
        QuerySetObject objDataItem = this.m_mapDataItems.get(sObjRefId);
        for (String sRefId : objDataItem.getReferencedObjects()) {
            if (sRefId.equals(sObjRefId) || !(bFound = this.findModelObjectRefs(sRefId))) continue;
            ReportQueryObject objQuery = objDataItem.getParent();
            String metadataPath = objQuery.getMetadataPath();
            if (!this.m_mapPathModelObjects.containsKey(metadataPath)) {
                this.m_mapPathModelObjects.put(metadataPath, new ArrayList());
            }
            if (this.m_mapDataItems.get(sRefId) == null) {
                this.m_mapPathModelObjects.get(metadataPath).add(sRefId);
            }
            for (ILineageQuerySetObject iLineageQuerySetObject : objQuery.getDetailFilters()) {
                this.findModelObjectRefs(iLineageQuerySetObject);
            }
            for (ILineageQuerySetObject iLineageQuerySetObject : objQuery.getSummaryFilters()) {
                this.findModelObjectRefs(iLineageQuerySetObject);
            }
            for (ILineageQuerySetObject iLineageQuerySetObject : objQuery.getSlicerMemberSets()) {
                this.findModelObjectRefs(iLineageQuerySetObject);
            }
        }
        return bFound;
    }

    private void findModelObjectRefs(ILineageQuerySetObject querySetObject) {
        for (String sObjRefId : querySetObject.getReferencedObjects()) {
            if (this.isObjectTraversed(sObjRefId)) continue;
            this.findModelObjectRefs(sObjRefId);
        }
    }

    private boolean isObjectTraversed(String sObjRefId) {
        for (String sObjectRef : this.m_traversedObjectRefs) {
            if (!sObjectRef.equals(sObjRefId)) continue;
            return true;
        }
        return false;
    }

    private void updateModelObjectRefs() {
        this.m_modelObjectRefs.clear();
        this.m_traversedObjectRefs.clear();
        for (QueryResult objectQuery : this.getQueryResults()) {
            String sObjRefId = objectQuery.getObjectRef();
            this.findModelObjectRefs(sObjRefId);
        }
        if (this.m_modelObjectRefs.size() == 0) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("No model object refs found in the QuerySet.");
        }
    }

    public void enumerateDataItems(Element rootQuerySet) {
        if (rootQuerySet == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        this.m_setDataItemRefs.clear();
        List childElems = rootQuerySet.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element currentChildElem = (Element)childElemsIter.next();
            String currentChildElemName = currentChildElem.getName();
            if (!currentChildElemName.equals("queries")) continue;
            List childQueries = currentChildElem.elements();
            ListIterator iterQueries = childQueries.listIterator();
            while (iterQueries.hasNext()) {
                Element elemQuery = (Element)iterQueries.next();
                String sQueryName = elemQuery.attributeValue("name");
                Element elemSelection = elemQuery.element("selection");
                List childDataItems = elemSelection.elements();
                ListIterator iterDataItems = childDataItems.listIterator();
                while (iterDataItems.hasNext()) {
                    Element elemDataItem = (Element)iterDataItems.next();
                    String sDataItemName = elemDataItem.attributeValue("name");
                    String sDataItemId = QuerySetIDHelper.buildItemId(sQueryName, sDataItemName, false);
                    this.m_setDataItemRefs.add(sDataItemId);
                }
            }
        }
        if (this.m_bDebug) {
            System.out.println("========================================================");
            System.out.println(" QuerySet: ALL Data Item Ids");
            System.out.println("--------------------------------------------------------");
            for (String sObjId : this.m_setDataItemRefs) {
                System.out.println("   Data Item Id: " + sObjId);
            }
        }
    }

    public void parse(Element rootQuerySet) {
        this.enumerateDataItems(rootQuerySet);
        if (rootQuerySet == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        if (this.m_sContentLocale == null) {
            this.m_sContentLocale = rootQuerySet.attributeValue(EXPRESSIONLOCAL);
        }
        this.m_localizedSchemaValues = new LocalizedSchemaValues(this.m_sContentLocale);
        List childElems = rootQuerySet.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element currentChildElem = (Element)childElemsIter.next();
            String elemName = currentChildElem.getName();
            if (elemName.equals("modelPath")) {
                this.m_sModelPath = currentChildElem.getText();
                int nModelPart = this.m_sModelPath.indexOf("/model[");
                String sPackagePath = this.m_sModelPath.substring(0, nModelPart);
                this.setPackagePath(sPackagePath);
                continue;
            }
            if (!elemName.equals("queries")) continue;
            List childQueryElems = currentChildElem.elements();
            ListIterator childQueryIter = childQueryElems.listIterator();
            while (childQueryIter.hasNext()) {
                Element currentQueryElem = (Element)childQueryIter.next();
                ReportQueryObject objQuery = new ReportQueryObject(this);
                objQuery.buildFromInstanceElem(currentQueryElem);
                this.registerReportQueryObject(objQuery);
                LineageObject lo = objQuery.convertToLineageObject();
                this.addObject(lo);
            }
        }
        this.updateModelObjectRefs();
    }

    public Element buildQuerySetDom() {
        Element elemQuerySet = this.buildQuerySetDom(null);
        return elemQuerySet;
    }

    public Element buildQuerySetDom(Element targetParentElem) {
        Element rootElem = targetParentElem == null ? DocumentHelper.createElement((String)"querySet") : targetParentElem.addElement("querySet");
        rootElem.addAttribute(EXPRESSIONLOCAL, this.m_sContentLocale);
        rootElem.addElement("modelPath").addText(this.getModelPath());
        Element elemQueries = rootElem.addElement("queries");
        elemQueries.addAttribute(XMLNS, this.m_sXmlns);
        for (ReportQueryObject query : this.m_objectQueries) {
            query.dumpToParentElem(elemQueries);
        }
        return rootElem;
    }

    public List<Element> getModelLineageRequestElems() {
        ArrayList<Element> elemLineageRequests = new ArrayList<Element>();
        List<LineageRequest> requests = this.getModelLineageRequests();
        for (LineageRequest request : requests) {
            Element elemLineageRequest = request.dumpToParentElem(null);
            elemLineageRequests.add(elemLineageRequest);
        }
        return elemLineageRequests;
    }

    public List<LineageRequest> getModelLineageRequests() {
        ArrayList<LineageRequest> requests = new ArrayList<LineageRequest>();
        for (Map.Entry<String, ArrayList<String>> entry : this.m_mapPathModelObjects.entrySet()) {
            LineageRequest request = new LineageRequest();
            String metadataPath = entry.getKey();
            request.addConnectionParam("searchPath", metadataPath);
            List modelObjects = entry.getValue();
            int nObj = 0;
            for (String sObjId : modelObjects) {
                RequestQuery modelObjQuery = new RequestQuery();
                modelObjQuery.setId(Integer.toString(++nObj));
                modelObjQuery.addParam("modelItemRef", sObjId);
                request.addObjectQuery(modelObjQuery);
                requests.add(request);
            }
        }
        return requests;
    }

    private Collection<QuerySetObject> getReferencedObjectsForObject(QuerySetObject obj) {
        LinkedHashSet<QuerySetObject> refObjects = new LinkedHashSet<QuerySetObject>();
        Collection<String> refs = obj.getReferencedObjects();
        for (String sObjRefId : refs) {
            if (!this.m_mapDataItems.containsKey(sObjRefId)) continue;
            QuerySetObject refObj = this.m_mapDataItems.get(sObjRefId);
            refObjects.add(refObj);
        }
        return refObjects;
    }

    private void addDataItemToQueryResponse(String sObjRefId) {
        QuerySetObject obj = this.m_mapDataItems.get(sObjRefId);
        this.addObjectToQueryResponse(obj);
    }

    private void addFilterToQueryResponse(String sObjRefId) {
        QuerySetObject obj = this.m_mapFilters.get(sObjRefId);
        if (obj.hasReferencedObjects()) {
            this.addObjectToQueryResponse(obj);
        }
    }

    private void addObjectToQueryResponse(QuerySetObject obj) {
        if (obj != null) {
            LineageObject objQuery = obj.getParent().convertToLineageObject();
            this.m_lineageResponse.addObject(objQuery);
            LineageObject objItem = obj.convertToLineageObject();
            this.m_lineageResponse.addObject(objItem);
        }
    }

    public LineageResponse getQueryLineageResponse() {
        for (String sObjRefId : this.m_traversedObjectRefs) {
            this.addDataItemToQueryResponse(sObjRefId);
        }
        for (String sObjRefId : this.m_mapFilters.keySet()) {
            this.addFilterToQueryResponse(sObjRefId);
        }
        return this.m_lineageResponse;
    }

    public String getLocalizedString(String sString) {
        String stLocalizedString = this.m_localizedSchemaValues.getMdsrvStrings().getLocalizedValue(MSGPREFIX + sString);
        return stLocalizedString;
    }

    public LocalizedSchemaValues getLocalizedValues() {
        return this.m_localizedSchemaValues;
    }

    private void registerObjectRef(String sObjId, String[] idParts, String sParentName, Collection<String> refObjects) {
        boolean isValidObjectRef = true;
        if (idParts.length == 2) {
            if (this.m_setDataItemRefs.contains(sObjId)) {
                sObjId = "[Report]." + sObjId;
            }
        } else if (idParts.length == 1) {
            String sDataItemId = '[' + sParentName + ']' + '.' + sObjId;
            if (this.m_setDataItemRefs.contains(sDataItemId)) {
                sObjId = "[Report]." + sDataItemId;
            } else {
                isValidObjectRef = false;
            }
        }
        if (isValidObjectRef) {
            refObjects.add(sObjId);
        }
    }

    public boolean parseExpression2(String sExpression, Collection<String> refObjects, String sParentName) {
        if (sExpression == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "querySet");
        }
        boolean isObjectReference = false;
        refObjects.clear();
        String sRegex = "\\]\\.\\[";
        String sTempExpression = sExpression.replaceAll(sRegex, "*.*");
        String sObjId = "";
        int nLeftBracket = sTempExpression.indexOf(91, 0);
        int nRightBracket = 0;
        while (nLeftBracket != -1) {
            boolean isValidObjectRef = true;
            nRightBracket = sTempExpression.indexOf(93, nLeftBracket);
            if (nRightBracket != -1) {
                sObjId = sExpression.substring(nLeftBracket, nRightBracket + 1);
                String[] idParts = sObjId.split(sRegex);
                boolean bl = isValidObjectRef = sObjId.indexOf("@MEMBER") == -1 && sObjId.indexOf("[all]") == -1;
                if (isValidObjectRef) {
                    this.registerObjectRef(sObjId, idParts, sParentName, refObjects);
                }
                nLeftBracket = sExpression.indexOf(91, nRightBracket);
                continue;
            }
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Invalid expression '" + sExpression + "' in the QuerySet.");
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        if (refObjects.size() == 1 && sObjId.equals(sExpression)) {
            isObjectReference = true;
        }
        return isObjectReference;
    }

    public boolean parseExpression(String sExpression, Collection<String> refObjects, String sParentName) {
        if (sExpression == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "querySet");
        }
        boolean isObjectReference = false;
        refObjects.clear();
        try {
            IV5ExpressionUniqueNameListing identifierListing = new V5ExpressionUniqueNameListingParser().parse(sExpression);
            for (IV5UniqueName identifier : identifierListing.uniqueNameList()) {
                String sObjId = identifier.metadataPiece().referenceValue();
                if (this.m_bDebug && (null != identifier.logicalPiece() || null != identifier.physicalPiece())) {
                    System.out.println("---------");
                    System.out.println("MUN Value: " + identifier.referenceValue());
                }
                String[] idParts = QuerySetIDHelper.parseNameParts(sObjId);
                this.registerObjectRef(sObjId, idParts, sParentName, refObjects);
            }
        }
        catch (Exception e) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Invalid expression '" + sExpression + "' in the QuerySet. Reason: " + e.getMessage());
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "querySet");
        }
        if (refObjects.size() == 1) {
            isObjectReference = true;
        }
        return isObjectReference;
    }
}

