/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.lineage.api.client.DataItemObject;
import com.cognos.metadataService.command.lineage.api.client.DetailFilterObject;
import com.cognos.metadataService.command.lineage.api.client.LineageObject;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.client.QuerySetObject;
import com.cognos.metadataService.command.lineage.api.client.QuerySetParser;
import com.cognos.metadataService.command.lineage.api.client.ReportQueryOperation;
import com.cognos.metadataService.command.lineage.api.client.SlicerMemberSetObject;
import com.cognos.metadataService.command.lineage.api.client.SummaryFilterObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObjectBase;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageQuerySetObject;
import com.cognos.metadataService.sources.mfw.LocalizedSchemaValues;
import com.cognos.metadataService.ui.util.DOMUtil;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ReportQueryObject
implements ILineageQuerySetObject {
    private static final String OBJECTSOURCE = "objectSource";
    private String m_sSource;
    private String m_parentRef = "[Report]";
    private String m_name;
    private String m_metadataPath = "";
    private Collection<QuerySetObject> m_dataItems = new LinkedHashSet<QuerySetObject>();
    private Collection<QuerySetObject> m_detailFilters = new LinkedHashSet<QuerySetObject>();
    private Collection<QuerySetObject> m_summaryFilters = new LinkedHashSet<QuerySetObject>();
    private Collection<QuerySetObject> m_slicerMemberSets = new LinkedHashSet<QuerySetObject>();
    private QuerySetParser m_parentObject;
    private LineageObject m_lineageObject;
    private ReportQueryOperation m_QueryOperation = null;
    private boolean m_bDebug = false;

    public ReportQueryObject(QuerySetParser querySetParser) {
        this.m_parentObject = querySetParser;
        this.m_metadataPath = querySetParser.getPackagePath();
    }

    public boolean isSourceModel() {
        boolean bModel = false;
        bModel = this.m_sSource != null && this.m_sSource.indexOf("model") != -1;
        return bModel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ReportQueryObject objQuery = (ReportQueryObject)obj;
        return this.getId().equals(objQuery.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getSource() {
        return this.m_sSource;
    }

    public Collection<QuerySetObject> getDataItems() {
        return this.m_dataItems;
    }

    public Collection<QuerySetObject> getDetailFilters() {
        return this.m_detailFilters;
    }

    public Collection<QuerySetObject> getSummaryFilters() {
        return this.m_summaryFilters;
    }

    public Collection<QuerySetObject> getSlicerMemberSets() {
        return this.m_slicerMemberSets;
    }

    public String getItemId(boolean bAppendReportPrefix) {
        String sItemRefId = QuerySetIDHelper.buildItemId(this.getName(), null, bAppendReportPrefix);
        return sItemRefId;
    }

    @Override
    public String getId() {
        return this.getItemId(true);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public String getDispName() {
        return this.getName();
    }

    @Override
    public String getType() {
        return "query";
    }

    public String getParentRef() {
        return this.m_parentRef;
    }

    public QuerySetParser getParent() {
        return this.m_parentObject;
    }

    @Override
    public String getExpression() {
        return null;
    }

    @Override
    public Collection<String> getReferencedObjects() {
        return null;
    }

    public String getMetadataPath() {
        return this.m_metadataPath;
    }

    private void addDataItem(DataItemObject obj) {
        this.m_dataItems.add(obj);
    }

    private void addDetailFilter(DetailFilterObject obj) {
        this.m_detailFilters.add(obj);
    }

    private void addSummaryFilter(SummaryFilterObject obj) {
        this.m_summaryFilters.add(obj);
    }

    private void addSlicerMemberSet(SlicerMemberSetObject obj) {
        this.m_slicerMemberSets.add(obj);
    }

    public void registerChildObjects() {
        Iterator<QuerySetObject> items = null;
        for (QuerySetObject obj : this.m_detailFilters) {
            this.getParent().registerFilter(obj);
        }
        for (QuerySetObject obj : this.m_summaryFilters) {
            this.getParent().registerFilter(obj);
        }
        for (QuerySetObject obj : this.m_slicerMemberSets) {
            this.getParent().registerFilter(obj);
        }
        if (this.m_QueryOperation != null && this.m_QueryOperation.isUnion()) {
            for (QuerySetObject dataItem : this.m_dataItems) {
                String sExpression = dataItem.getExpression();
                for (String sProjectionItemName : this.m_QueryOperation.getProjectionList()) {
                    String sUnionItemID = QuerySetIDHelper.buildItemId(this.m_QueryOperation.getName(), sProjectionItemName, false);
                    if (!sExpression.contains(sUnionItemID)) continue;
                    String m_sNewExpressionPart = "";
                    for (String sQueryName : this.m_QueryOperation.getQueryRefs()) {
                        String sDataItemId = QuerySetIDHelper.buildItemId(sQueryName, sProjectionItemName, false);
                        if (m_sNewExpressionPart.length() > 0) {
                            m_sNewExpressionPart = m_sNewExpressionPart + " + ";
                        }
                        m_sNewExpressionPart = m_sNewExpressionPart + sDataItemId;
                    }
                    if (m_sNewExpressionPart.length() == 0) continue;
                    sExpression = sExpression.replace(sUnionItemID, m_sNewExpressionPart);
                }
                dataItem.setExpression(sExpression);
                dataItem.parseExpression(sExpression);
                this.getParent().registerDataItem(dataItem);
            }
        } else {
            for (QuerySetObject obj : this.m_dataItems) {
                this.getParent().registerDataItem(obj);
            }
        }
    }

    @Override
    public void buildFromInstanceElem(Element rootElem) {
        String rootElemName = rootElem.getName();
        if (!rootElemName.equals("query")) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, "query");
        }
        this.m_name = rootElem.attributeValue("name");
        List childElems = rootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            QuerySetObject objFilter;
            String elemName;
            List filterElems;
            LineageObject lo;
            Element childElem = (Element)childElemsIter.next();
            String childElemName = childElem.getName();
            if (childElemName.equals("source")) {
                String metadataPath;
                String sTemp = childElem.asXML();
                int nBegin = sTemp.indexOf(">");
                int nEnd = sTemp.indexOf("</source");
                this.m_sSource = sTemp.substring(nBegin + 1, nEnd);
                List operationPathElems = childElem.elements();
                ListIterator operationPathIter = operationPathElems.listIterator();
                if (!operationPathIter.hasNext()) continue;
                Element operationPathElem = (Element)operationPathIter.next();
                String operationPathElemName = operationPathElem.getName();
                if (operationPathElemName.equals("queryOperation")) {
                    this.m_QueryOperation = new ReportQueryOperation();
                    this.m_QueryOperation.buildFromInstanceElem(operationPathElem);
                    if (!this.m_bDebug) continue;
                    Iterator<String> queryRefs = this.m_QueryOperation.getQueryRefs().iterator();
                    System.out.println("========================================================");
                    System.out.println("Query References:");
                    System.out.println("--------------------------------------------------------");
                    while (queryRefs.hasNext()) {
                        String sObjRef = queryRefs.next();
                        System.out.println("Object " + sObjRef);
                    }
                    System.out.println("--------------------------------------------------------");
                    continue;
                }
                if (!operationPathElemName.equals("metadataPath") || (metadataPath = operationPathElem.attributeValue("path")).isEmpty()) continue;
                int nModelPart = metadataPath.indexOf("/model[");
                this.m_metadataPath = metadataPath.substring(0, nModelPart);
                continue;
            }
            if (childElemName.equals("selection")) {
                List dataItemElems = childElem.elements();
                ListIterator dataElemsIter = dataItemElems.listIterator();
                while (dataElemsIter.hasNext()) {
                    Element elem = (Element)dataElemsIter.next();
                    String dataItemName = elem.getName();
                    if (!dataItemName.equals("dataItem")) {
                        throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, "query");
                    }
                    DataItemObject objDataItem = new DataItemObject(this);
                    objDataItem.buildFromInstanceElem(elem);
                    this.addDataItem(objDataItem);
                    lo = objDataItem.convertToLineageObject();
                    this.getParent().addObject(lo);
                }
                continue;
            }
            if (childElemName.equals("detailFilters")) {
                filterElems = childElem.elements();
                ListIterator filtersIter = filterElems.listIterator();
                while (filtersIter.hasNext()) {
                    Element elem = (Element)filtersIter.next();
                    elemName = elem.getName();
                    if (!elemName.equals("detailFilter")) {
                        throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, "query");
                    }
                    objFilter = new DetailFilterObject(this);
                    ((DetailFilterObject)objFilter).buildFromInstanceElem(elem);
                    this.addDetailFilter((DetailFilterObject)objFilter);
                    if (!objFilter.hasReferencedObjects()) continue;
                    lo = ((DetailFilterObject)objFilter).convertToLineageObject();
                    this.getParent().addObject(lo);
                }
                continue;
            }
            if (childElemName.equals("summaryFilters")) {
                filterElems = childElem.elements();
                ListIterator filtersIter = filterElems.listIterator();
                while (filtersIter.hasNext()) {
                    Element elem = (Element)filtersIter.next();
                    elemName = elem.getName();
                    if (!elemName.equals("summaryFilter")) {
                        throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, "query");
                    }
                    objFilter = new SummaryFilterObject(this);
                    ((SummaryFilterObject)objFilter).buildFromInstanceElem(elem);
                    this.addSummaryFilter((SummaryFilterObject)objFilter);
                    if (!objFilter.hasReferencedObjects()) continue;
                    lo = ((SummaryFilterObject)objFilter).convertToLineageObject();
                    this.getParent().addObject(lo);
                }
                continue;
            }
            if (!childElemName.equals("slicer")) continue;
            filterElems = childElem.elements();
            ListIterator filtersIter = filterElems.listIterator();
            while (filtersIter.hasNext()) {
                Element elem = (Element)filtersIter.next();
                elemName = elem.getName();
                if (!elemName.equals("slicerMemberSet")) {
                    throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, "query");
                }
                objFilter = new SlicerMemberSetObject(this);
                ((SlicerMemberSetObject)objFilter).buildFromInstanceElem(elem);
                this.addSlicerMemberSet((SlicerMemberSetObject)objFilter);
                if (!objFilter.hasReferencedObjects()) continue;
                lo = ((SlicerMemberSetObject)objFilter).convertToLineageObject();
                this.getParent().addObject(lo);
            }
        }
    }

    @Override
    public LineageObject convertToLineageObject() {
        if (this.m_lineageObject == null) {
            this.m_lineageObject = LineageObject.create(this);
            this.m_lineageObject.setParentRef(this.getParentRef());
            this.addChildReferences(this.m_lineageObject, this.m_dataItems);
            this.addChildReferences(this.m_lineageObject, this.m_detailFilters);
            this.addChildReferences(this.m_lineageObject, this.m_summaryFilters);
            this.addChildReferences(this.m_lineageObject, this.m_slicerMemberSets);
            LocalizedSchemaValues localizedValues = this.getParent().getLocalizedValues();
            String sTypeDispName = localizedValues.getMdsrvStrings().getLocalizedValue(QuerySetParser.MSGPREFIX + this.getType());
            this.m_lineageObject.addProperty("objectId", localizedValues.getLocalizedObjectIDPropertyName(), this.getItemId(false), null);
            this.m_lineageObject.addProperty("objectName", localizedValues.getLocalizedObjectNamePropertyName(), this.getName(), null);
            this.m_lineageObject.addProperty("objectType", localizedValues.getLocalizedObjectTypePropertyName(), this.getType(), sTypeDispName);
            this.m_lineageObject.addProperty(OBJECTSOURCE, localizedValues.getMdsrvStrings().getLocalizedValue(QuerySetParser.MSGPREFIX + OBJECTSOURCE), this.getSource(), null);
        }
        return this.m_lineageObject;
    }

    private void addChildReferences(LineageObject lineageObject, Collection<QuerySetObject> collChildRefs) {
        for (ILineageObjectBase iLineageObjectBase : collChildRefs) {
            lineageObject.addChildRef(iLineageObjectBase.getId());
        }
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element rootElem = targetParentElem.addElement("query");
        rootElem.addAttribute("name", this.getName());
        Element elemSource = rootElem.addElement("source");
        Element elemSourceContents = DOMUtil.parse(this.getSource());
        Attribute attr = elemSourceContents.attribute("xmlns");
        if (attr != null) {
            elemSourceContents.remove(attr);
        }
        elemSource.add(elemSourceContents);
        this.dumpCollectionToParentElem(rootElem, this.m_dataItems, "selection");
        this.dumpCollectionToParentElem(rootElem, this.m_detailFilters, "detailFilters");
        this.dumpCollectionToParentElem(rootElem, this.m_summaryFilters, "summaryFilters");
        this.dumpCollectionToParentElem(rootElem, this.m_slicerMemberSets, "slicer");
        return rootElem;
    }

    private void dumpCollectionToParentElem(Element targetParentElem, Collection<QuerySetObject> collQuerySetObjects, String sCollectionRoot) {
        if (collQuerySetObjects.size() > 0) {
            Element elemCollectionRoot = targetParentElem.addElement(sCollectionRoot);
            for (ILineageQuerySetObject iLineageQuerySetObject : collQuerySetObjects) {
                iLineageQuerySetObject.dumpToParentElem(elemCollectionRoot);
            }
        }
    }
}

