/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class ReportQueryOperation {
    public static final String QUERY_OPERATION_TYPE_ATTR = "setOperation";
    public static final String QUERY_OPERATION_TYPE_UNION = "UNION";
    public static final String QUERY_OPERATION_TAG = "queryOperation";
    public static final String QUERY_OPERATION_QUERYREFS = "queryRefs";
    public static final String QUERY_OPERATION_QUERYREF = "queryRef";
    public static final String QUERY_OPERATION_QUERYREF_REFQUERY = "refQuery";
    public static final String QUERY_OPERATION_PROJECTIONLIST = "projectionList";
    private String m_sType;
    private String m_sName;
    private Collection<String> m_queryRefs = new LinkedHashSet<String>();
    private Collection<String> m_queryItems = new LinkedHashSet<String>();

    public String getName() {
        return this.m_sName;
    }

    public String getType() {
        return this.m_sType;
    }

    public Collection<String> getQueryRefs() {
        return this.m_queryRefs;
    }

    public Collection<String> getProjectionList() {
        return this.m_queryItems;
    }

    public boolean isUnion() {
        return this.m_sType.equalsIgnoreCase(QUERY_OPERATION_TYPE_UNION);
    }

    public void buildFromInstanceElem(Element rootElem) {
        String rootElemName = rootElem.getName();
        if (!rootElemName.equals(QUERY_OPERATION_TAG)) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, QUERY_OPERATION_TAG);
        }
        this.m_sName = rootElem.attributeValue("name");
        this.m_sType = rootElem.attributeValue(QUERY_OPERATION_TYPE_ATTR);
        if (this.m_sType == null) {
            this.m_sType = QUERY_OPERATION_TYPE_UNION;
        }
        List childElems = rootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element childElem = (Element)childElemsIter.next();
            String childElemName = childElem.getName();
            if (childElemName.equals(QUERY_OPERATION_QUERYREFS)) {
                List queryRefElems = childElem.elements();
                ListIterator queryRefIter = queryRefElems.listIterator();
                while (queryRefIter.hasNext()) {
                    Element queryRefElem = (Element)queryRefIter.next();
                    String queryRefName = queryRefElem.getName();
                    if (!queryRefName.equals(QUERY_OPERATION_QUERYREF)) {
                        throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, QUERY_OPERATION_QUERYREF);
                    }
                    String queryRefAttr = queryRefElem.attributeValue(QUERY_OPERATION_QUERYREF_REFQUERY);
                    this.m_queryRefs.add(queryRefAttr);
                }
                continue;
            }
            if (!childElemName.equals(QUERY_OPERATION_PROJECTIONLIST)) continue;
            List projectionListItems = childElem.elements();
            for (Element elQueryItem : projectionListItems) {
                if (elQueryItem.attributeValue("name") == null) continue;
                this.m_queryItems.add(elQueryItem.attributeValue("name"));
            }
        }
    }
}

