/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.api.IElementSerializable;
import com.cognos.metadataService.command.lineage.api.client.LineageParamList;
import com.cognos.metadataService.command.lineage.api.client.QueryResult;
import com.cognos.metadataService.command.lineage.api.client.QuerySetIDHelper;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageRequestQuery;
import org.dom4j.Element;

public class RequestQuery
implements IElementSerializable,
ILineageRequestQuery {
    private String m_id = null;
    private LineageParamList m_params = null;

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    public void addParam(String name, String value) {
        if (this.m_params == null) {
            this.m_params = new LineageParamList();
        }
        this.m_params.addParam(name, value);
    }

    public String getParamValue(String name) {
        return this.m_params == null ? null : this.m_params.getParamValue(name);
    }

    @Override
    public void buildFromInstanceElem(Element objectQueryElem) {
        this.setId(objectQueryElem.attributeValue("id"));
        this.m_params = new LineageParamList();
        this.m_params.addObjectsForParentElem(objectQueryElem);
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element objectQueryElem = targetParentElem.addElement("objectQuery");
        String id = this.getId();
        if (id != null) {
            objectQueryElem.addAttribute("id", id);
        }
        if (this.m_params != null) {
            this.m_params.dumpToParentElem(objectQueryElem);
        }
        return objectQueryElem;
    }

    public String getItemId(boolean bAppendReportPrefix) {
        String sItemRefId;
        String sModelItemName = this.m_params.getParamValue("modelItemRef");
        if (sModelItemName != null) {
            sItemRefId = sModelItemName;
        } else {
            String sQueryName = this.m_params.getParamValue("queryName");
            String sItemName = this.m_params.getParamValue("dataItemName");
            sItemRefId = QuerySetIDHelper.buildItemId(sQueryName, sItemName, bAppendReportPrefix);
        }
        return sItemRefId;
    }

    @Override
    public QueryResult convertToQueryResult() {
        QueryResult queryResult = new QueryResult();
        queryResult.setObjectQueryRef(this.getId());
        queryResult.setObjectRef(this.getItemId(true));
        return queryResult;
    }
}

