/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.api.client;

import com.cognos.metadataService.command.api.IElementSerializable;
import com.cognos.metadataService.command.lineage.api.client.LineagePropertyListParent;
import com.cognos.metadataService.command.lineage.api.client.TransformationSource;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageProperty;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageTransformation;
import com.cognos.metadataService.command.lineage.api.mdsrv.TransformationTypeEnum;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class Transformation
extends LineagePropertyListParent
implements IElementSerializable {
    private static final String TYPE = "type";
    public static final String TRANSFORMATION = "transformation";
    private LinkedHashSet m_transformationSourceList = new LinkedHashSet();
    private TransformationTypeEnum m_type;

    public Transformation() {
    }

    public Transformation(ILineageTransformation iTrans) {
        this.m_type = TransformationTypeEnum.loadFromValue(iTrans.getType());
        for (ILineageProperty iProp : iTrans.getProperties()) {
            this.addProperty(iProp.getName(), iProp.getDisplayName(), iProp.getValue(), iProp.getDisplayValue());
        }
        Iterator<ILineageObject> iSources = iTrans.getTransformationSources().iterator();
        while (iSources.hasNext()) {
            ILineageObject iLineageObj;
            TransformationSource tSource = new TransformationSource();
            if (iTrans.getType().equals("objectReference")) {
                iLineageObj = iSources.next();
                tSource.setObjectRef(iLineageObj.getId());
            } else if (iTrans.getType().equals(TRANSFORMATION)) {
                iLineageObj = iSources.next();
                tSource.setObjectRef(iLineageObj.getId());
            }
            this.addTransformationSource(tSource);
        }
    }

    public Collection getTransformationSourceList() {
        return this.m_transformationSourceList;
    }

    public void addTransformationSource(TransformationSource transformationSource) {
        this.m_transformationSourceList.add(transformationSource);
    }

    public void setTransformationSources(Collection transformationSourceList) {
        this.m_transformationSourceList = new LinkedHashSet();
        this.m_transformationSourceList.addAll(transformationSourceList);
    }

    @Override
    public void buildFromInstanceElem(Element requestRootElem) {
        super.buildFromInstanceElem(requestRootElem);
        List childElems = requestRootElem.elements();
        ListIterator childElemsIter = childElems.listIterator();
        while (childElemsIter.hasNext()) {
            Element childElem = (Element)childElemsIter.next();
            String childElemName = childElem.getName();
            if (childElemName.equals(TYPE)) {
                this.m_type = TransformationTypeEnum.loadFromValue(childElem.getText());
            }
            if (!childElemName.equals("objectRef") && !childElemName.equals("lineageRequest")) continue;
            TransformationSource transformationSource = new TransformationSource();
            transformationSource.buildFromInstanceElem(childElem);
            this.addTransformationSource(transformationSource);
        }
    }

    @Override
    public Element dumpToParentElem(Element targetParentElem) {
        Element rootElem = targetParentElem.addElement(TRANSFORMATION);
        rootElem.addElement(TYPE).setText(this.getType().getStringValue());
        super.dumpToInstanceElem(rootElem);
        if (this.m_transformationSourceList != null) {
            HashSet<String> processedTransformations = new HashSet<String>();
            for (TransformationSource transformationSource : this.m_transformationSourceList) {
                String objectRef = transformationSource.getObjectRef();
                boolean bAddObject = objectRef != null && processedTransformations.add(objectRef);
                if (!bAddObject) continue;
                transformationSource.dumpToParentElem(rootElem);
            }
        }
        return rootElem;
    }

    public boolean isExpanded() {
        return this.m_transformationSourceList != null;
    }

    public TransformationTypeEnum getType() {
        return this.m_type;
    }

    public void setType(TransformationTypeEnum type) {
        this.m_type = type;
    }
}

