/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.contentmanager;

import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.metadataService.command.lineage.adapters.response.CMLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyModel;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.sources.contentmanager.SearchPathMap;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;

public abstract class CMAccessStrategyBaseReport
implements ICMAccess {
    static PropEnum[] reportProps = CMLineageObject.getUIClassQueryProps(new PropEnum[]{PropEnum.metadataModelPackage, PropEnum.metadataModel, PropEnum.packageBase});
    private CMLineageObject m_lineageObject;
    private CMAccessStrategyModel m_modelStrategy;
    private String m_searchPath;
    private CMQuery m_queryHelper;
    protected SearchPathMap m_searchPathMap;
    LinkedHashSet<CMLineageObject> m_lineageObjects;

    public CMAccessStrategyBaseReport(String reportSearchPath, CMQuery cmQueryHelper) {
        this.m_searchPath = reportSearchPath;
        this.m_queryHelper = cmQueryHelper;
        this.m_searchPathMap = new SearchPathMap(cmQueryHelper);
        this.m_lineageObjects = new LinkedHashSet();
        CMObject baseReport = this.getBaseReportObj();
        if (baseReport == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_InvalidCMSearchPath, reportSearchPath);
        }
        CMObject authoredReportObj = this.getAuthoredReportObj();
        this.m_lineageObject = new CMLineageObject(BaseReport.class, authoredReportObj);
        this.m_searchPathMap.registerCMObj(authoredReportObj, this.m_lineageObject);
    }

    protected abstract CMObject getBaseReportObj();

    protected CMObject getAuthoredReportObj() {
        return this.getBaseReportObj();
    }

    protected String getSearchPath() {
        return this.m_searchPath;
    }

    protected CMQuery getQueryHelper() {
        return this.m_queryHelper;
    }

    protected CMLineageObject getLineageObject() {
        return this.m_lineageObject;
    }

    @Override
    public CMLineageObject getContextObject(IMfwLineageObject lineageObj) {
        CMLineageObject lineageObject;
        String searchPath = lineageObj.getSourceSearchPath();
        if (this.m_modelStrategy == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, this.m_searchPath);
        }
        CMLineageObject cMLineageObject = lineageObject = searchPath == null ? this.m_modelStrategy.getPackageLineageObject() : (CMLineageObject)this.m_searchPathMap.find(searchPath);
        if (lineageObject == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("ContentManagerLineageStrategyReport::handle Unexpectedly received the following search path: " + searchPath + " which could not be lcoated in the map");
            lineageObject = this.m_modelStrategy.getPackageLineageObject();
        }
        return lineageObject;
    }

    @Override
    public CMObject getMetadataSourceObject() {
        return this.getAuthoredReportObj();
    }

    @Override
    public void update(String[] searchPaths) {
        for (int searchPathsIdx = 0; this.m_modelStrategy == null && searchPathsIdx < searchPaths.length; ++searchPathsIdx) {
            String searchPath = searchPaths[searchPathsIdx];
            if (searchPath.equals(this.getAuthoredReportObj().getSearchPath())) continue;
            this.m_modelStrategy = new CMAccessStrategyModel(searchPath, this.m_queryHelper);
            this.m_searchPathMap.registerCMObj(this.m_modelStrategy.getMetadataSourceObject(), this.m_modelStrategy.getPackageLineageObject());
            this.m_lineageObject.addChild(this.m_modelStrategy.getPackageLineageObject());
        }
    }

    @Override
    public Collection<ILineageObject> getLineageObjects() {
        if (this.m_modelStrategy == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, this.m_searchPath);
        }
        Vector<ILineageObject> lineageObjsVector = new Vector<ILineageObject>();
        lineageObjsVector.add(this.m_lineageObject);
        CMLineageObject packageLineageObject = this.m_modelStrategy.getPackageLineageObject();
        lineageObjsVector.add(packageLineageObject);
        return lineageObjsVector;
    }
}

