/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.contentmanager;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.lineage.adapters.response.CMLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class CMAccessStrategyModel
implements ICMAccess {
    protected static final PropEnum[] packageProps = CMLineageObject.getUIClassQueryProps(new PropEnum[]{PropEnum.effectiveUserCapabilities});
    private CMLineageObject m_package;
    CMObject m_cmPackage = null;
    CMObject m_cmModel = null;

    public CMAccessStrategyModel(String modelObjSearchPath, CMQuery cmQueryHelper) {
        this.m_cmModel = cmQueryHelper.querySingleObj(modelObjSearchPath, CMLineageObject.baseClassQueryProps);
        if (this.m_cmModel == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, modelObjSearchPath);
        }
        String packageObjSearchPath = this.m_cmModel.getRefObjPropValue(PropEnum.parent, PropEnum.searchPath);
        if (packageObjSearchPath != null) {
            this.m_cmPackage = this.m_cmModel.getSourceQuery().querySingleObj(packageObjSearchPath, packageProps);
        }
        if (this.m_cmPackage == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation(this.getClass().getName() + "Querying for package: " + packageObjSearchPath + " + for model: " + this.m_cmModel.getSearchPath() + "returned no results");
        } else {
            this.checkCapability();
            this.m_package = new CMLineageObject(_package.class, this.m_cmPackage);
            this.m_package.addProperty(PropEnum.version, this.m_cmModel.getStringPropValue(PropEnum.version));
        }
    }

    @Override
    public CMObject getMetadataSourceObject() {
        return this.m_cmModel;
    }

    @Override
    public CMLineageObject getContextObject(IMfwLineageObject lineageObj) {
        return this.getPackageLineageObject();
    }

    CMLineageObject getPackageLineageObject() {
        return this.m_package;
    }

    private void checkCapability() {
        boolean hasCapability = false;
        Element effectiveUserCapabilities = this.m_cmPackage.getProp(PropEnum.effectiveUserCapabilities);
        if (effectiveUserCapabilities != null) {
            Element valueElem = effectiveUserCapabilities.element("value");
            if (valueElem != null) {
                List itemElemList = valueElem.elements("item");
                for (int itemElemListIdx = 0; !hasCapability && itemElemListIdx < itemElemList.size(); ++itemElemListIdx) {
                    String itemElemText = ((Element)itemElemList.get(itemElemListIdx)).getText();
                    if (!UserCapabilityEnum.canUseLineage.equals((Object)UserCapabilityEnum.fromValue((String)itemElemText))) continue;
                    hasCapability = true;
                }
            }
            if (!hasCapability) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_MissingCapability, UserCapabilityEnum.canUseLineage.getValue());
            }
        }
    }

    @Override
    public void update(String[] searchPaths) {
    }

    @Override
    public Collection<ILineageObject> getLineageObjects() {
        Vector<ILineageObject> lineageObjects = new Vector<ILineageObject>();
        lineageObjects.add(this.m_package);
        return lineageObjects;
    }
}

