/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.contentmanager;

import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.metadataService.command.lineage.adapters.response.CMLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.api.interfaces.ILineageObject;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyAuthoredReport;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyBaseReport;
import com.cognos.metadataService.command.lineage.source.contentmanager.CMAccessStrategyReportView;
import com.cognos.metadataService.command.lineage.source.contentmanager.ICMAccess;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import java.util.Collection;

public class CMAccessStrategyReportVersion
implements ICMAccess {
    CMObject m_cmReportVersion = null;
    CMAccessStrategyBaseReport m_reportStrategy;

    public CMAccessStrategyReportVersion(String reportVersionSearchPath, CMQuery cmQueryHelper) {
        this.m_cmReportVersion = cmQueryHelper.querySingleObj(reportVersionSearchPath, CMLineageObject.baseClassQueryProps);
        if (this.m_cmReportVersion == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, reportVersionSearchPath);
        }
        CMObject cmParent = this.m_cmReportVersion.getParent();
        if (cmParent == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, reportVersionSearchPath);
        }
        if (cmParent.isAxisType(Report.class) || cmParent.isAxisType(Analysis.class) || cmParent.isAxisType(Query.class)) {
            this.m_reportStrategy = new CMAccessStrategyAuthoredReport(cmParent.getSearchPath(), cmQueryHelper);
        } else if (cmParent.isAxisType(ReportView.class)) {
            this.m_reportStrategy = new CMAccessStrategyReportView(cmParent.getSearchPath(), cmQueryHelper);
        } else {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ModelConnectError, reportVersionSearchPath);
        }
        CMLineageObject reportLineageObject = this.m_reportStrategy.getLineageObject();
        reportLineageObject.addProperty(PropEnum.version, this.m_cmReportVersion.getStringPropValue(PropEnum.version));
    }

    @Override
    public CMLineageObject getContextObject(IMfwLineageObject lineageObj) {
        return this.m_reportStrategy.getContextObject(lineageObj);
    }

    @Override
    public CMObject getMetadataSourceObject() {
        return this.m_reportStrategy.getMetadataSourceObject();
    }

    @Override
    public Collection<ILineageObject> getLineageObjects() {
        return this.m_reportStrategy.getLineageObjects();
    }

    @Override
    public void update(String[] searchPaths) {
        this.m_reportStrategy.update(searchPaths);
    }
}

