/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.model;

import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.MfwLineageQuery;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.util.Collection;
import java.util.Vector;

public class DataSourceRetrieval {
    private Vector<IMfwLineageObject> m_referencedDataSourceObjectList = new Vector();
    private MFWGateway m_mfwGateway;

    public DataSourceRetrieval(MFWGateway mfwGateway, IMfwLineageObject lineageObject, MfwLineageQuery lineageObjectFactory) {
        this.m_mfwGateway = mfwGateway;
        if (lineageObject.hasMultilingualName()) {
            MFWNodeHandle[] dataSourceRefNodeList = null;
            try {
                MFWNodeHandle node = lineageObject.getNode();
                dataSourceRefNodeList = this.getDataSourceRefNodeList(node);
            }
            catch (Exception e) {
                System.out.println("exception caught in getReferencedDataSourceObjects: " + e.getMessage());
            }
            for (int dataSourceRefNodeListIdx = 0; dataSourceRefNodeList != null && dataSourceRefNodeListIdx < dataSourceRefNodeList.length; ++dataSourceRefNodeListIdx) {
                MFWNodeHandle node = dataSourceRefNodeList[dataSourceRefNodeListIdx];
                String propertyValue = this.m_mfwGateway.getPropertyValue(node);
                IMfwLineageObject dataSourceObj = lineageObjectFactory.query(propertyValue);
                if (dataSourceObj == null) continue;
                this.m_referencedDataSourceObjectList.add(dataSourceObj);
            }
        }
    }

    public Collection<IMfwLineageObject> getReferencedDataSourceObjects() {
        return this.m_referencedDataSourceObjectList;
    }

    private MFWNodeHandle[] getDataSourceRefNodeList(MFWNodeHandle objectNode) {
        MFWNodeHandle[] dataSourceRefNodeList = null;
        if (objectNode != null) {
            short parentNodeRID;
            MFWNodeHandle parentNode;
            MFWNodeHandle[] childObjectNodes;
            MFWNodeHandle dataSourceRefsParentNode = null;
            if (objectNode.getInfo().findChildInfo(MFWModelRes.getInstance().RID_dataSourceRef) != null) {
                dataSourceRefsParentNode = objectNode;
            } else if (objectNode.getInfo().findChildInfo(MFWModelRes.getInstance().RID_datasources) != null && (childObjectNodes = this.m_mfwGateway.getObjectChildren(objectNode, MFWModelRes.getInstance().RID_datasources)) != null && childObjectNodes.length > 0) {
                dataSourceRefsParentNode = childObjectNodes[0];
            }
            if (dataSourceRefsParentNode != null) {
                dataSourceRefNodeList = this.m_mfwGateway.getObjectChildren(dataSourceRefsParentNode, MFWModelRes.getInstance().RID_dataSourceRef);
            }
            if (dataSourceRefNodeList == null && (parentNode = objectNode.getParent()) != null && (parentNodeRID = parentNode.getInfo().getRID()) != -1 && parentNodeRID != MFWModelRes.getInstance().RID_namespace) {
                dataSourceRefNodeList = this.getDataSourceRefNodeList(parentNode);
            }
        }
        return dataSourceRefNodeList;
    }
}

