/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.model;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.metadataService.command.lineage.source.model.ObjectTypeInfo;
import com.cognos.metadataService.command.lineage.source.model.PropertyTypeInfo;
import com.cognos.metadataService.sources.mfw.RIDHacks;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class LineageProps {
    private static final String LINEAGEPROPSFILEPATH = "../templates/mdsrv/mdsrvLineageProps.xml";
    private static final String SOURCE_FM = "source[@name='FM']";
    private static final String SOURCE_AUTHOREDREPORTQUERY = "source[@name='AuthoredReportQuery']";
    private static final String OBJECT_TYPE_SPECIFICATION = "objectTypeSpecification";
    private static final String OBJECT_TYPE = "objectType";
    private static final String PROPERTY_TYPE = "propertyType";
    private static final String TRANSFORMATION_PRIORITY = "transformationPriority";
    private static short[] m_objectRids = null;
    private static Map<Short, ObjectTypeInfo> m_objectInfoMap = new HashMap<Short, ObjectTypeInfo>();

    public LineageProps() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (0 == m_objectInfoMap.size()) {
            Map<Short, ObjectTypeInfo> map = m_objectInfoMap;
            synchronized (map) {
                if (0 == m_objectInfoMap.size()) {
                    LineageProps.load();
                }
            }
        }
    }

    private static void load() {
        MDSRVLogUtil.getLogUtilInstance().methodStart("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.load begin");
        try {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            String lineagePropertiesFilePathResolved = config.resolveEffectivePath(LINEAGEPROPSFILEPATH);
            File lineagePropertiesFile = new File(lineagePropertiesFilePathResolved);
            if (!lineagePropertiesFile.exists()) {
                MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.loadCould not locate lineage props file: " + lineagePropertiesFilePathResolved);
            } else if (!lineagePropertiesFile.isFile()) {
                MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.loadLocated lineage props file: " + lineagePropertiesFilePathResolved + "but it's NOT a file???");
            } else {
                SAXReader saxReader = new SAXReader();
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                FileInputStream lineagePropertiesFileInputStream = new FileInputStream(lineagePropertiesFile);
                Document lineagePropertiesDoc = saxReader.read((InputStream)lineagePropertiesFileInputStream);
                Element rootElem = lineagePropertiesDoc.getRootElement();
                LineageProps.processMfwSection((Element)rootElem.selectSingleNode(SOURCE_FM));
                LineageProps.processMfwSection((Element)rootElem.selectSingleNode(SOURCE_AUTHOREDREPORTQUERY));
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception e) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.load", e);
        }
        m_objectRids = new short[m_objectInfoMap.keySet().size() + 1];
        LineageProps.m_objectRids[0] = MFWModelRes.getInstance().RID_shortcut;
        int objectRidIdx = 0;
        Iterator<Short> m_objectInfoMapKeySetIter = m_objectInfoMap.keySet().iterator();
        while (m_objectInfoMapKeySetIter.hasNext()) {
            LineageProps.m_objectRids[++objectRidIdx] = m_objectInfoMapKeySetIter.next();
        }
        Arrays.sort(m_objectRids);
        MDSRVLogUtil.getLogUtilInstance().methodEnd("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.load end");
    }

    private static void processMfwSection(Element fmSectionElem) {
        List commonPropertyTypeElemList = fmSectionElem.elements(PROPERTY_TYPE);
        Iterator objectTypeSpecElemListIter = fmSectionElem.elementIterator(OBJECT_TYPE_SPECIFICATION);
        while (objectTypeSpecElemListIter.hasNext()) {
            Element objectTypeSpecElem = (Element)objectTypeSpecElemListIter.next();
            ObjectTypeInfo objectTypeInfo = new ObjectTypeInfo();
            List propertyTypeElemList = objectTypeSpecElem.elements(PROPERTY_TYPE);
            for (Element commonPropertyTypeElem : commonPropertyTypeElemList) {
                propertyTypeElemList.add((Element)commonPropertyTypeElem.clone());
            }
            for (Element propertyTypeElem : propertyTypeElemList) {
                String propertyTypeName = propertyTypeElem.getText();
                if (!(propertyTypeName.equals("objectId") || propertyTypeName.equals("objectName") || propertyTypeName.equals(OBJECT_TYPE))) {
                    PropertyTypeInfo propertyInfo = new PropertyTypeInfo();
                    short propRid = RIDHacks.getRIDForName(propertyTypeElem.getText());
                    if (propRid == -1) {
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.load: no rid could be obtained for lineage property type " + propertyTypeElem.getText());
                    } else {
                        propertyInfo.setRid(propRid);
                        String transformationPriority = propertyTypeElem.attributeValue(TRANSFORMATION_PRIORITY);
                        if (transformationPriority == null) {
                            objectTypeInfo.addDescriptiveProperty(propertyInfo);
                        } else {
                            objectTypeInfo.addTransformationProperty(propertyInfo, new Integer(transformationPriority));
                        }
                    }
                }
                Iterator objectTypeElemIter = objectTypeSpecElem.elementIterator(OBJECT_TYPE);
                while (objectTypeElemIter.hasNext()) {
                    String objectType = ((Element)objectTypeElemIter.next()).getText();
                    short rid = RIDHacks.getRIDForName(objectType);
                    if (rid == -1) {
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("com.cognos.metadataService.command.lineage.impl.model.ModelLineageProps.load: no rid could be obtained for lineage props object type " + objectType);
                        continue;
                    }
                    m_objectInfoMap.put(new Short(rid), objectTypeInfo);
                }
            }
        }
    }

    public ObjectTypeInfo getObjectInfo(short rid) {
        return m_objectInfoMap.get(new Short(rid));
    }

    public short[] getObjectRids() {
        return m_objectRids;
    }
}

