/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.lineage.source.model;

import com.cognos.metadataService.command.lineage.adapters.response.IMfwLineageObject;
import com.cognos.metadataService.command.lineage.adapters.response.IV5UniqueNameLineageObjectQuery;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueNameListing;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueNameUpdater;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePart;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceReferenceValue;
import com.cognos.xqe.ast.v5Exp.uniqueName.parser.V5ExpressionUniqueNameListingParser;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class MfwLineageExpression {
    private final String m_expression;
    private boolean m_simpleObjectReference;
    private IV5ExpressionUniqueNameListing m_updatedListing;
    private LinkedHashMap<String, IMfwLineageObject> m_referencedObjectsMap;
    private final IV5UniqueNameLineageObjectQuery m_objectFactory;

    public MfwLineageExpression(IV5UniqueNameLineageObjectQuery objectFactory, String expression) {
        this.m_objectFactory = objectFactory;
        if (expression == null) {
            throw new NullPointerException(expression);
        }
        this.m_expression = expression;
        V5ExpressionUniqueNameListingParser parser = new V5ExpressionUniqueNameListingParser();
        IV5ExpressionUniqueNameListing expressionUniqueNameListing = null;
        try {
            expressionUniqueNameListing = parser.parse(this.m_expression);
        }
        catch (MacroException e) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("com.cognos.metadataService.command.lineage.source.model.MfwLineageExpression: XQERuntimeException caught when trying to parse expression: \"" + this.m_expression + "\". Details: ", e);
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_LIN_ExpressionParsingError, e, new String[]{expression});
        }
        this.m_referencedObjectsMap = new LinkedHashMap();
        List identifiers = expressionUniqueNameListing.uniqueNameList();
        this.m_simpleObjectReference = identifiers.size() == 1 && 0 == expressionUniqueNameListing.macroList().size();
        String trimmedExpression = this.m_expression.trim();
        IV5ExpressionUniqueNameUpdater updater = this.expressionUpdater(trimmedExpression);
        this.m_updatedListing = expressionUniqueNameListing.updateUniqueNames(updater);
    }

    private IV5ExpressionUniqueNameUpdater expressionUpdater(final String trimmedExpression) {
        IV5ExpressionUniqueNameUpdater updater = new IV5ExpressionUniqueNameUpdater(){

            public IV5UniqueName update(IV5ExpressionUniqueName expressionUniqueName) {
                V5UniqueNamePieceReferenceValue replacementUniqueName = null;
                String displayValue = expressionUniqueName.expressionValue();
                if (MfwLineageExpression.this.m_simpleObjectReference && !trimmedExpression.equals(displayValue)) {
                    MfwLineageExpression.this.m_simpleObjectReference = false;
                }
                IV5UniqueNamePiece metadataPiece = expressionUniqueName.metadataPiece();
                String referenceValue = metadataPiece.referenceValue();
                IMfwLineageObject metadataObject = (IMfwLineageObject)MfwLineageExpression.this.m_referencedObjectsMap.get(referenceValue);
                if (null == metadataObject) {
                    metadataObject = MfwLineageExpression.this.m_objectFactory.query(metadataPiece);
                    if (null == metadataObject) {
                        MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("ExpressionHelper.addObjectReference(String): Could not locate object for reference: + " + referenceValue + "when processing expression: " + MfwLineageExpression.this.m_expression);
                    } else {
                        MfwLineageExpression.this.m_referencedObjectsMap.put(referenceValue, metadataObject);
                    }
                }
                if (null != metadataObject) {
                    String updateRefValue;
                    String scannedIRefValue;
                    V5UniqueNamePieceReferenceValue newIdentifier = null;
                    String localizedId = metadataObject.getLocalizedId();
                    IV5UniqueNamePiece logicalPiece = expressionUniqueName.logicalPiece();
                    IV5UniqueNamePiece physicalPiece = expressionUniqueName.physicalPiece();
                    if (null != logicalPiece || null != physicalPiece) {
                        List nameParts;
                        MfwLineageExpression.this.m_simpleObjectReference = false;
                        IV5UniqueNamePiece lastDataPartPiece = physicalPiece;
                        if (null == lastDataPartPiece) {
                            lastDataPartPiece = logicalPiece;
                        }
                        if (0 < (nameParts = lastDataPartPiece.nameParts()).size()) {
                            IV5UniqueNamePart namePart = (IV5UniqueNamePart)nameParts.get(nameParts.size() - 1);
                            String lastPhysicalPart = namePart.namePartValue();
                            newIdentifier = new V5UniqueNamePieceReferenceValue(lastPhysicalPart);
                        }
                    } else {
                        newIdentifier = new V5UniqueNamePieceReferenceValue(localizedId);
                    }
                    if (null != newIdentifier && !(scannedIRefValue = displayValue).equals(updateRefValue = newIdentifier.referenceValue())) {
                        replacementUniqueName = newIdentifier;
                    }
                }
                return replacementUniqueName;
            }
        };
        return updater;
    }

    public Collection<IMfwLineageObject> getReferencedObjects() {
        return this.m_referencedObjectsMap.values();
    }

    public String getUpdatedValue() {
        return this.m_updatedListing.expression();
    }

    public boolean isObjectReference() {
        return this.m_simpleObjectReference;
    }
}

