/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.mdprovider;

import com.cognos.metadataService.command.mdprovider.MDProviderCommand;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.misc.XMLHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.Element;

public class TestDataSourceConnectionCommand
extends MDProviderCommand {
    private static final String TESTDATASOURCECONNECTION = "testDataSourceConnection";
    private static final String UPDATEMETADATA = "md1:updateMetadata";
    private static final String XMLNS_MD = "md1";
    private static final String MDNAMESPACE = "http://developer.cognos.com/schemas/metadataService/1";
    private static final String REQUEST = "request";
    private static final String CONNECTIONSTRING = "connectionString";
    private static final String CREDENTIALS = "credentials";

    @Override
    public boolean invokeRequest(MessageContext mc) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element requestBody = request.getBody();
        requestBody.addNamespace(XMLNS_MD, MDNAMESPACE);
        Element queryMetadataElem = requestBody.addElement(UPDATEMETADATA);
        Element requestElem = queryMetadataElem.addElement(REQUEST);
        String requestXML = this.buildRequestXML(requestBody);
        requestElem.addText(requestXML);
        return super.invokeRequest(mc);
    }

    private String buildRequestXML(Element requestBody) {
        Element testElem = requestBody.element(TESTDATASOURCECONNECTION);
        if (testElem == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter);
        }
        Element connStringElem = testElem.element(CONNECTIONSTRING);
        Element credentialsElem = testElem.element(CREDENTIALS);
        if (connStringElem == null || credentialsElem == null) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter);
        }
        String connectionString = XMLHelper.escapeXMLCharacters(connStringElem.getText());
        String credentials = credentialsElem.getText();
        String requestXML = "<mdprovider type=\"transientAction\" action=\"execute\" seq=\"1\" xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:md1=\"http://developer.cognos.com/schemas/metadataService/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xts=\"http://developer.cognos.com/schemas/xts/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><transaction saved=\"false\" seq=\"1\"><action seq=\"1\" type=\"TestDataSourceConnection\"><inputparams><param seq=\"1\" type=\"i18nstring\"><value>" + connectionString + "</value></param><param seq=\"2\" type=\"cclnode\"><value><![CDATA[" + credentials + "]]></value></param></inputparams><domchanges/><result success=\"t\"><outputparams/></result></action></transaction></mdprovider>";
        return requestXML;
    }
}

