/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.modelDiff;

import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.metadataService.command.modelDiff.DiffException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FmModel {
    MFWGateway m_gw = null;
    MFWModelRes m_modelRes = null;
    String m_xpathModel = null;
    final String RID_dataSources = "dataSources";
    final String RID_packages = "packages";
    final String RID_package = "package";
    final String RID_guid = "guid";
    int m_nSerializeIndentLevel = 0;
    private String m_sModelDesignLocale = "";

    FmModel(MFWGateway gw, String xpathModel) {
        this.m_gw = gw;
        this.m_modelRes = MFWModelRes.getInstance();
        this.m_xpathModel = xpathModel;
    }

    public MFWGateway getGateway() {
        return this.m_gw;
    }

    public String getModelXPath() {
        return this.m_xpathModel;
    }

    public boolean isModelObject(MFWNodeHandle node) {
        String name = node.getInfo().getName();
        short rid = this.m_modelRes.getResourceID(name);
        return rid != -1 && (rid == this.m_modelRes.RID_project || rid == this.m_modelRes.RID_namespace || rid == this.m_modelRes.RID_folder || rid == this.m_modelRes.RID_querySubject || rid == this.m_modelRes.RID_dimension || rid == this.m_modelRes.RID_queryItem || rid == this.m_modelRes.RID_queryItemFolder || rid == this.m_modelRes.RID_relationship || rid == this.m_modelRes.RID_scopeRelationship || rid == this.m_modelRes.RID_hierarchy || rid == this.m_modelRes.RID_level || rid == this.m_modelRes.RID_filter || rid == this.m_modelRes.RID_calculation || rid == this.m_modelRes.RID_shortcut || name.equals("dataSources") || rid == this.m_modelRes.RID_dataSource || rid == this.m_modelRes.RID_parameterMaps || rid == this.m_modelRes.RID_parameterMap || name.equals("packages") || name.equals("package") || rid == this.m_modelRes.RID_securityViews || rid == this.m_modelRes.RID_securityView);
    }

    public boolean isProperty(MFWNodeHandle node) {
        return node.isProperty();
    }

    public boolean isComplexProperty(MFWNodeHandle node) {
        return node.isObject() && !this.isModelObject(node);
    }

    public boolean isPropertyLocaleBased(MFWNodeHandle node) {
        return false;
    }

    public boolean isComplexPropertyLocaleBased(MFWNodeHandle node) {
        return null != node.getInfo().findChildInfo(this.m_modelRes.RID_locale);
    }

    public String getComplexPropertyName(MFWNodeHandle node) {
        String sPropertyName = "";
        if (this.isComplexProperty(node)) {
            String slash = "/";
            MFWNodeHandle childNode = node;
            MFWNodeHandle parentNode = null;
            do {
                String sChildName = node.getName();
                parentNode = node.getParent();
                MFWException.ASSERT((parentNode != null ? 1 : 0) != 0, (String)"Any kind of property always has a parent");
                if (!this.isModelObject(parentNode)) {
                    sChildName = slash + sChildName;
                }
                if (this.isComplexPropertyLocaleBased(childNode)) {
                    String sLocID = this.getComplexPropertyLocale(childNode);
                    sChildName = sChildName + "[" + sLocID + "]";
                } else {
                    short nameRID = childNode.getInfo().getRID();
                    MFWNodeHandle[] nodeSiblings = this.m_gw.getObjectChildren(parentNode, nameRID);
                    if (nodeSiblings.length > 0) {
                        int nPos = 0;
                        for (int nCount = 0; nCount < nodeSiblings.length; ++nCount) {
                            if (nodeSiblings[nCount] != node) continue;
                            nPos = nCount;
                            break;
                        }
                        sChildName = sChildName + "[" + Integer.toString(nPos) + "]";
                    }
                }
                sPropertyName = sChildName + sPropertyName;
                if (parentNode == null || this.isModelObject(parentNode)) break;
                childNode = parentNode;
            } while (parentNode != null);
        }
        return sPropertyName;
    }

    public String getComplexPropertyValue(MFWNodeHandle node) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedOutputStream outputStream = new BufferedOutputStream(bout);
            this.serializeObject(outputStream, node, 0);
            return bout.toString();
        }
        catch (Exception e) {
            MFWException.ASSERT((boolean)false, (String)"Error serializing complex property");
            return "";
        }
    }

    public String getComplexPropertyLocale(MFWNodeHandle node) {
        String value = "";
        if (this.isComplexPropertyLocaleBased(node)) {
            value = this.m_gw.getObjectPropertyValue(node, this.m_modelRes.RID_locale);
        }
        return value;
    }

    public String getPropertyName(MFWNodeHandle node) {
        return node.getName();
    }

    public String getPropertyValue(MFWNodeHandle node) {
        return this.m_gw.getPropertyValue(node);
    }

    public String getGuid(MFWNodeHandle nodeObject) {
        if (this.isModelObject(nodeObject)) {
            int i = 0;
            MFWNodeHandle[] children = this.m_gw.getObjectChildren(nodeObject, this.m_modelRes.RID_guid);
            if (i < children.length) {
                MFWNodeHandle child = children[i];
                return this.m_gw.getPropertyValue(child);
            }
            throw new DiffException("Unsupported model:  Model object \"" + this.getModelObjectID(nodeObject) + "\" with guid property not found.");
        }
        return "";
    }

    public boolean canDiffModelObject(MFWNodeHandle node) {
        String name = node.getName();
        long rid = this.m_modelRes.getResourceID(name);
        return rid != -1L && (rid == (long)this.m_modelRes.RID_project || rid == (long)this.m_modelRes.RID_namespace || rid == (long)this.m_modelRes.RID_querySubject || rid == (long)this.m_modelRes.RID_dimension || rid == (long)this.m_modelRes.RID_queryItem || rid == (long)this.m_modelRes.RID_relationship || rid == (long)this.m_modelRes.RID_scopeRelationship || rid == (long)this.m_modelRes.RID_hierarchy || rid == (long)this.m_modelRes.RID_level || rid == (long)this.m_modelRes.RID_filter || rid == (long)this.m_modelRes.RID_calculation || rid == (long)this.m_modelRes.RID_shortcut);
        {
        }
    }

    public String getModelObjectTypeName(MFWNodeHandle node) {
        if (this.isModelObject(node)) {
            return node.getName();
        }
        return "";
    }

    public long getModelObjectType(MFWNodeHandle node) {
        if (this.isModelObject(node)) {
            return this.m_modelRes.getResourceID(node.getName());
        }
        return -1L;
    }

    public boolean isProject(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_project;
    }

    public boolean isNamespace(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_namespace;
    }

    public boolean isFolder(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_folder;
    }

    public boolean isQuerySubject(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_querySubject;
    }

    public boolean isDimension(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_dimension;
    }

    public boolean isQueryItem(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_queryItem;
    }

    public boolean isQueryItemFolder(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_queryItemFolder;
    }

    public boolean isRelationship(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_relationship;
    }

    public boolean isScopeRelationship(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_scopeRelationship;
    }

    public boolean isHierarchy(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_hierarchy;
    }

    public boolean isLevel(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_level;
    }

    public boolean isFilter(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_filter;
    }

    public boolean isCalculation(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_calculation;
    }

    public boolean isDataSources(MFWNodeHandle node) {
        return node.getName().equals("dataSources");
    }

    public boolean isDataSource(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_dataSource;
    }

    public boolean isPackages(MFWNodeHandle node) {
        return node.getName().equals("packages");
    }

    public boolean isPackage(MFWNodeHandle node) {
        return node.getName().equals("package");
    }

    public boolean isMeasureFolder(MFWNodeHandle node) {
        return node.getInfo().getRID() == this.m_modelRes.RID_measureFolder;
    }

    public String getModelDesignLocale() {
        if (this.m_sModelDesignLocale == "") {
            String sQueryXPath_Project = "/" + this.m_modelRes.getResource(this.m_modelRes.RID_project) + "/" + this.m_modelRes.getResource(this.m_modelRes.RID_defaultLocale);
            MFWNodeHandle[] nodeProject = this.m_gw.query(MFWQuerySpec.create((String)sQueryXPath_Project));
            this.m_sModelDesignLocale = this.m_gw.getPropertyValue(nodeProject[0]);
        }
        return this.m_sModelDesignLocale;
    }

    public String getModelObjectName(MFWNodeHandle node) {
        MFWInfo nameInfo = node.getInfo().findChildInfo(this.m_modelRes.RID_name);
        if (nameInfo != null) {
            if (nameInfo.findChildInfo(this.m_modelRes.RID_locale) != null) {
                String desLocale = this.getModelDesignLocale();
                MFWNodeHandle[] enLocaleNameNode = this.m_gw.findChildObjects(node, this.m_modelRes.RID_name, this.m_modelRes.RID_locale, desLocale);
                if (enLocaleNameNode.length == 0) {
                    String name = node.getName();
                    return name;
                }
                MFWNodeHandle propHandle = this.m_gw.getObjectChildren(enLocaleNameNode[0], this.m_modelRes.RID__Value)[0];
                String value = this.m_gw.getPropertyValue(propHandle);
                return value;
            }
            MFWNodeHandle propHandle = this.m_gw.getObjectChildren(node, this.m_modelRes.RID_name)[0];
            String value = this.m_gw.getPropertyValue(propHandle);
            return value;
        }
        return node.getName();
    }

    private void serializeObject(OutputStream outputStream, MFWNodeHandle objNode, int indentLevel) throws IOException {
        short rid = objNode.getInfo().getRID();
        String nodeBeginElem = new String("<object ridName=\"" + this.m_modelRes.getResource(rid) + "\" rid=\"" + String.valueOf(rid) + "\">");
        outputStream.write(nodeBeginElem.getBytes());
        MFWNodeHandle[] childNodes = this.m_gw.getAllObjectChildren(objNode);
        for (int childNodesIdx = 0; childNodesIdx < childNodes.length; ++childNodesIdx) {
            MFWNodeHandle childNode = childNodes[childNodesIdx];
            if (childNode.isObject()) {
                this.serializeObject(outputStream, childNode, indentLevel + 1);
                continue;
            }
            if (!childNode.isProperty()) continue;
            this.serializeProp(outputStream, childNode, indentLevel + 1);
        }
        outputStream.write("</object>".getBytes());
        outputStream.flush();
    }

    private void serializeProp(OutputStream outputStream, MFWNodeHandle objNode, int indentLevel) throws IOException {
        short rid = objNode.getInfo().getRID();
        String propLine = "<prop ridName=\"" + this.m_modelRes.getResource(rid) + "\" rid=\"" + String.valueOf(rid) + "\">" + CCLXMLUtils.xmlEncode((String)this.m_gw.getPropertyValue(objNode)) + "</prop>";
        outputStream.write(propLine.getBytes());
    }

    public String getModelObjectID(MFWNodeHandle node) {
        String sID = "";
        if (node != null && this.isModelObject(node)) {
            sID = this.m_gw.getObjectPropertyValue(node, this.m_modelRes.RID_ID);
        }
        return sID;
    }
}

