/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.modelDiff;

import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFControl;
import com.cognos.metadataService.command.modelDiff.DiffException;
import com.cognos.metadataService.command.modelDiff.FmModel;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public final class ModelDiff {
    FmModel m_fmModel_Old = null;
    FmModel m_fmModel_New = null;
    ArrayList m_diffDatabase = new ArrayList();
    LinkedHashMap m_modelObjectDictionary_Old = null;
    LinkedHashMap m_modelObjectDictionary_New = null;
    static boolean m_bTraceModelObjects = false;
    static boolean m_bTraceProperties = false;
    static boolean m_bTraceComplexProperties = false;
    String m_sGatewayID = null;
    String m_sProductLocale = null;
    String m_sContentLocale = null;
    String m_sPassport = null;

    ModelDiff() {
    }

    public static void initStandaloneRequiredComponents() {
        ICCLConfiguration configuration = CCLConfigurationFactory.getInstance();
        try {
            configuration.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!LogIPFControl.initialize()) {
            ModelDiff.debugTrace(0, "MDSRV:  Model Diff failed to initialize");
        }
        if (!LogIPFControl.configure((ICCLConfiguration)configuration)) {
            ModelDiff.debugTrace(0, "MDSRV:  Model Diff failed to configure IPF");
            throw new DiffException("MDSRV:  Model Diff failed to configure IPF");
        }
        SAXReaderPool.prepare((boolean)true, (int)1);
        String contentManagerPath = "localhost:9300/p2pd/servlet";
        NodeIdGuidMapper.setContentManagerNID((NodeID)NodeID.getNodeID((String)contentManagerPath));
    }

    public void initConnectionVariables(String sGatewayID, String sProductLocale, String sContentLocale, String sPassport) {
        this.m_sGatewayID = sGatewayID;
        this.m_sProductLocale = sProductLocale;
        this.m_sContentLocale = sContentLocale;
        this.m_sPassport = sPassport;
    }

    public void initConnectionVariables(String sGatewayID, String sProductLocale, String sContentLocale, String sCMUserNamespace, String sCMUserId, String sCMPassword) {
        this.m_sGatewayID = sGatewayID;
        this.m_sProductLocale = sProductLocale;
        this.m_sContentLocale = sContentLocale;
        MFWContentHelper helper = MFWContentHelper.create((String)sProductLocale, (String)sContentLocale);
        this.m_sPassport = helper.authenticateUser(sCMUserNamespace, sCMUserId, sCMPassword);
    }

    static boolean notEmpty(String s) {
        return s != null && s.length() != 0;
    }

    public void openOldModel(String xpathOldModel) {
        if (!ModelDiff.notEmpty(this.m_sGatewayID)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sProductLocale)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sContentLocale)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sPassport)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        MFWMetadataSource sourceOld = MFWMetadataSource.create((String)"modelFM");
        sourceOld.addConnectionItem("cmSearchPath", (Object)xpathOldModel);
        MFWGateway gw = MFWGateway.open((String)this.m_sGatewayID, (MFWRequestContext)MFWRequestContext.create((String)this.m_sProductLocale, (String)this.m_sContentLocale, (String)this.m_sPassport), (MFWMetadataSource)sourceOld);
        this.validateModel(gw);
        this.m_fmModel_Old = new FmModel(gw, xpathOldModel);
    }

    public void openNewModel(String xpathNewModel) {
        if (!ModelDiff.notEmpty(this.m_sGatewayID)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sProductLocale)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sContentLocale)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        if (!ModelDiff.notEmpty(this.m_sPassport)) {
            throw new DiffException("Failed to initialize connection variables");
        }
        MFWMetadataSource sourceNew = MFWMetadataSource.create((String)"modelFM");
        sourceNew.addConnectionItem("cmSearchPath", (Object)xpathNewModel);
        MFWGateway gw = MFWGateway.open((String)this.m_sGatewayID, (MFWRequestContext)MFWRequestContext.create((String)this.m_sProductLocale, (String)this.m_sContentLocale, (String)this.m_sPassport), (MFWMetadataSource)sourceNew);
        this.validateModel(gw);
        this.m_fmModel_New = new FmModel(gw, xpathNewModel);
    }

    private void validateModel(MFWGateway gw) {
        MFWNodeHandle[] projectGuids = gw.query(MFWQuerySpec.create((String)"/project/guid"));
        if (projectGuids.length < 1) {
            throw new DiffException("Unsupported model for Model Diff:  No model objects with a guid property were found.");
        }
    }

    private void loadModelObjectDictionary(FmModel fmModel, HashMap modelObjectDictionary) {
        MFWNodeHandle[] projectNodes = fmModel.getGateway().query(MFWQuerySpec.create((String)"/project"));
        ArrayList modelObjectsWithGuids = new ArrayList();
        this.findModelObjects(fmModel, modelObjectsWithGuids, projectNodes[0], 0);
        for (int i = 0; i < modelObjectsWithGuids.size(); ++i) {
            MFWNodeHandle modelObject = (MFWNodeHandle)modelObjectsWithGuids.get(i);
            if (!fmModel.canDiffModelObject(modelObject)) continue;
            String sGuid = fmModel.getGuid(modelObject);
            modelObjectDictionary.put(sGuid, modelObject);
        }
    }

    private void loadModelObjectPropertyNames(FmModel fmModel, HashMap guidDictionary, String sGuid, HashMap propertyNameDictionary) {
        MFWNodeHandle node = (MFWNodeHandle)guidDictionary.get(sGuid);
        if (fmModel.isModelObject(node)) {
            MFWNodeHandle[] childrenNodes = fmModel.getGateway().getAllObjectChildren(node);
            for (int i = 0; i < childrenNodes.length; ++i) {
                MFWNodeHandle childNode = childrenNodes[i];
                if (fmModel.isModelObject(childNode)) continue;
                if (fmModel.isComplexProperty(childNode)) {
                    String sComplexPropertyName = fmModel.getComplexPropertyName(childNode);
                    propertyNameDictionary.put(sComplexPropertyName, childNode);
                    continue;
                }
                if (!fmModel.isProperty(childNode)) continue;
                String sPropertyName = fmModel.getPropertyName(childNode);
                propertyNameDictionary.put(sPropertyName, childNode);
            }
        }
    }

    private void loadModelObjectPropertyValues(FmModel fmModel, HashMap propertyNameDictionary, HashMap propertyValueDictionary) {
        Set setPropertyNames = propertyNameDictionary.keySet();
        for (String propertyName : setPropertyNames) {
            String sPropertyValue;
            MFWNodeHandle propertyNode = (MFWNodeHandle)propertyNameDictionary.get(propertyName);
            if (fmModel.isComplexProperty(propertyNode)) {
                sPropertyValue = fmModel.getComplexPropertyValue(propertyNode);
                propertyValueDictionary.put(propertyNode, sPropertyValue);
                continue;
            }
            if (!fmModel.isProperty(propertyNode)) continue;
            sPropertyValue = fmModel.getPropertyValue(propertyNode);
            propertyValueDictionary.put(propertyNode, sPropertyValue);
        }
    }

    public void createDiffRecords() {
        this.m_diffDatabase.clear();
        this.m_modelObjectDictionary_Old = new LinkedHashMap();
        this.m_modelObjectDictionary_New = new LinkedHashMap();
        this.loadModelObjectDictionary(this.m_fmModel_Old, this.m_modelObjectDictionary_Old);
        this.loadModelObjectDictionary(this.m_fmModel_New, this.m_modelObjectDictionary_New);
        LinkedHashMap modelObjectsAdded = new LinkedHashMap(this.m_modelObjectDictionary_New);
        modelObjectsAdded.keySet().removeAll(this.m_modelObjectDictionary_Old.keySet());
        Set setModelObjectsAdded = modelObjectsAdded.keySet();
        for (String sGuidAdded : setModelObjectsAdded) {
            this.m_diffDatabase.add(new DiffRecord_ObjectAdded(sGuidAdded, (MFWNodeHandle)modelObjectsAdded.get(sGuidAdded)));
        }
        LinkedHashMap modelObjectsRemoved = new LinkedHashMap(this.m_modelObjectDictionary_Old);
        modelObjectsRemoved.keySet().removeAll(this.m_modelObjectDictionary_New.keySet());
        Set setModelObjectsRemoved = modelObjectsRemoved.keySet();
        for (String sGuidRemoved : setModelObjectsRemoved) {
            this.m_diffDatabase.add(new DiffRecord_ObjectDeleted(sGuidRemoved, (MFWNodeHandle)modelObjectsRemoved.get(sGuidRemoved)));
        }
        LinkedHashMap modelObjectsCommon = new LinkedHashMap(this.m_modelObjectDictionary_New);
        modelObjectsCommon.keySet().removeAll(modelObjectsRemoved.keySet());
        modelObjectsCommon.keySet().removeAll(modelObjectsAdded.keySet());
        Set setModelObjectsCommon = modelObjectsCommon.keySet();
        for (String sGuid : setModelObjectsCommon) {
            LinkedHashMap propertyNamesDictionary_oldModel = new LinkedHashMap();
            this.loadModelObjectPropertyNames(this.m_fmModel_Old, this.m_modelObjectDictionary_Old, sGuid, propertyNamesDictionary_oldModel);
            LinkedHashMap propertyNamesDictionary_newModel = new LinkedHashMap();
            this.loadModelObjectPropertyNames(this.m_fmModel_New, this.m_modelObjectDictionary_New, sGuid, propertyNamesDictionary_newModel);
            LinkedHashMap propertyValuesDictionary_oldModel = new LinkedHashMap();
            this.loadModelObjectPropertyValues(this.m_fmModel_Old, propertyNamesDictionary_oldModel, propertyValuesDictionary_oldModel);
            LinkedHashMap propertyValuesDictionary_newModel = new LinkedHashMap();
            this.loadModelObjectPropertyValues(this.m_fmModel_New, propertyNamesDictionary_newModel, propertyValuesDictionary_newModel);
            LinkedHashMap propertiesAdded = new LinkedHashMap(propertyNamesDictionary_newModel);
            propertiesAdded.keySet().removeAll(propertyNamesDictionary_oldModel.keySet());
            Set setPropertiesAdded = propertiesAdded.keySet();
            for (String sPropertyName : setPropertiesAdded) {
                MFWNodeHandle propertyNode = (MFWNodeHandle)propertiesAdded.get(sPropertyName);
                this.m_diffDatabase.add(new DiffRecord_PropertyAdded(sGuid, (MFWNodeHandle)this.m_modelObjectDictionary_Old.get(sGuid), (MFWNodeHandle)this.m_modelObjectDictionary_New.get(sGuid), propertyNode, sPropertyName, (String)propertyValuesDictionary_newModel.get(propertyNode)));
            }
            LinkedHashMap propertiesDeleted = new LinkedHashMap(propertyNamesDictionary_oldModel);
            propertiesDeleted.keySet().removeAll(propertyNamesDictionary_newModel.keySet());
            Set setPropertiesDeleted = propertiesDeleted.keySet();
            for (String sPropertyName : setPropertiesDeleted) {
                MFWNodeHandle propertyNode = (MFWNodeHandle)propertiesDeleted.get(sPropertyName);
                this.m_diffDatabase.add(new DiffRecord_PropertyDeleted(sGuid, (MFWNodeHandle)this.m_modelObjectDictionary_Old.get(sGuid), (MFWNodeHandle)this.m_modelObjectDictionary_New.get(sGuid), propertyNode, sPropertyName, (String)propertyValuesDictionary_newModel.get(propertyNode)));
            }
            HashSet propertiesChanged = new HashSet(propertyNamesDictionary_newModel.keySet());
            propertiesChanged.removeAll(propertiesAdded.keySet());
            propertiesChanged.removeAll(propertiesDeleted.keySet());
            for (String sPropertyName : propertiesChanged) {
                MFWNodeHandle nodePropertyOldModel;
                String sPropertyValueOldModel;
                MFWNodeHandle nodePropertyNewModel = (MFWNodeHandle)propertyNamesDictionary_newModel.get(sPropertyName);
                String sPropertyValueNewModel = (String)propertyValuesDictionary_newModel.get(nodePropertyNewModel);
                if (sPropertyValueNewModel.compareTo(sPropertyValueOldModel = (String)propertyValuesDictionary_oldModel.get(nodePropertyOldModel = (MFWNodeHandle)propertyNamesDictionary_oldModel.get(sPropertyName))) == 0) continue;
                MFWNodeHandle newPropertyNode = (MFWNodeHandle)propertyNamesDictionary_newModel.get(sPropertyName);
                MFWNodeHandle oldPropertyNode = (MFWNodeHandle)propertyNamesDictionary_oldModel.get(sPropertyName);
                this.m_diffDatabase.add(new DiffRecord_PropertyValueChanged(sGuid, (MFWNodeHandle)this.m_modelObjectDictionary_Old.get(sGuid), (MFWNodeHandle)this.m_modelObjectDictionary_New.get(sGuid), oldPropertyNode, newPropertyNode, sPropertyName, (String)propertyValuesDictionary_oldModel.get(oldPropertyNode), (String)propertyValuesDictionary_newModel.get(newPropertyNode)));
            }
        }
    }

    public void createDiffReport(Writer xmlDiffReport) throws IOException {
        xmlDiffReport.write("<ModelDiff>");
        for (int i = 0; i < this.m_diffDatabase.size(); ++i) {
            DiffRecord diffRecord = (DiffRecord)this.m_diffDatabase.get(i);
            diffRecord.write(xmlDiffReport);
        }
        xmlDiffReport.write("</ModelDiff>");
    }

    private static void debugTrace(int nDepth, String sMsg) {
        String sTraceIndent = "";
        for (int i = 0; i < nDepth; ++i) {
            sTraceIndent = sTraceIndent + "\t";
        }
        System.out.println(sTraceIndent + sMsg);
        System.out.flush();
    }

    private void findModelObjects(FmModel fmModel, ArrayList nodesMatching, MFWNodeHandle currentNode, int nDepth) {
        block8: {
            block7: {
                if (!fmModel.isModelObject(currentNode)) break block7;
                nodesMatching.add(currentNode);
                if (m_bTraceModelObjects) {
                    if (nDepth == 0) {
                        ModelDiff.debugTrace(nDepth, "_________________________");
                        ModelDiff.debugTrace(nDepth, "Dumping contents of model:  " + fmModel.getModelXPath());
                    }
                    ModelDiff.debugTrace(nDepth, "_________________________");
                    ModelDiff.debugTrace(nDepth, "Model Object Name:       " + fmModel.getModelObjectName(currentNode));
                    ModelDiff.debugTrace(nDepth, "Model Object Type:       " + fmModel.getModelObjectTypeName(currentNode));
                    ModelDiff.debugTrace(nDepth, "Model Object ID:         " + fmModel.getModelObjectID(currentNode));
                }
                MFWNodeHandle[] children = fmModel.getGateway().getAllObjectChildren(currentNode);
                if (m_bTraceModelObjects) {
                    ModelDiff.debugTrace(nDepth, "Model Object Children#:  " + children.length);
                }
                for (int i = 0; i < children.length; ++i) {
                    MFWNodeHandle child = children[i];
                    this.findModelObjects(fmModel, nodesMatching, child, nDepth + 1);
                }
                break block8;
            }
            if (!fmModel.isComplexProperty(currentNode)) break block8;
            if (m_bTraceComplexProperties) {
                ModelDiff.debugTrace(nDepth, "Complex Property:        " + fmModel.getComplexPropertyName(currentNode));
            }
            MFWNodeHandle[] children = fmModel.getGateway().getAllObjectChildren(currentNode);
            if (m_bTraceComplexProperties) {
                ModelDiff.debugTrace(nDepth, "Complex Children#:       " + children.length);
            }
            for (int i = 0; i < children.length; ++i) {
                MFWNodeHandle child = children[i];
                this.findModelObjects(fmModel, nodesMatching, child, nDepth + 1);
            }
        }
    }

    public static void main(String[] args) {
        String sDiffReportFilename = args[0];
        String xpathOldModel = args[1];
        String xpathNewModel = args[2];
        String sCMUserNamespace = "";
        String sCMUserId = "";
        String sCMPassword = "";
        String sGatewayID = "mfwTest";
        String sProductLocale = "en";
        String sContentLocale = "en";
        try {
            ModelDiff.debugTrace(0, "Status:  Initializing...");
            ModelDiff.initStandaloneRequiredComponents();
            ModelDiff.debugTrace(0, "Status:  Initializing done.");
            ModelDiff.debugTrace(0, "Status:  Authenticating...");
            MFWContentHelper helper = MFWContentHelper.create((String)"en", (String)"en");
            String sPassport = helper.authenticateUser(sCMUserNamespace, sCMUserId, sCMPassword);
            ModelDiff.debugTrace(0, "Status:  Authenticating done.");
            ModelDiff.debugTrace(0, "Status:  Connecting...");
            ModelDiff myDiff = new ModelDiff();
            myDiff.initConnectionVariables(sGatewayID, sProductLocale, sContentLocale, sPassport);
            ModelDiff.debugTrace(0, "Status:  Connecting to old model \"" + xpathOldModel + "\".");
            myDiff.openOldModel(xpathOldModel);
            ModelDiff.debugTrace(0, "Status:  Connecting to new model \"" + xpathNewModel + "\".");
            myDiff.openNewModel(xpathNewModel);
            ModelDiff.debugTrace(0, "Status:  Connecting done.");
            ModelDiff.debugTrace(0, "Status:  Differenciating...");
            myDiff.createDiffRecords();
            ModelDiff.debugTrace(0, "Status:  Differenciating done.");
            ModelDiff.debugTrace(0, "Status:  Generating report...");
            ModelDiff.debugTrace(0, "--------------------------------------------------------------------------------");
            FileWriter fw = new FileWriter(sDiffReportFilename);
            BufferedWriter bw = new BufferedWriter(fw);
            myDiff.createDiffReport(bw);
            bw.close();
            ModelDiff.debugTrace(0, "--------------------------------------------------------------------------------");
            ModelDiff.debugTrace(0, "Status:  Generating report done.");
        }
        catch (MFWException e) {
            String message = e.getMessage();
            System.err.println(message);
            e.printStackTrace();
        }
        catch (Exception e) {
            String message = e.getMessage();
            System.err.println(message);
            e.printStackTrace();
        }
        catch (Throwable e) {
            String message = e.getMessage();
            System.err.println(message);
            e.printStackTrace();
        }
    }

    public final class DiffRecord_PropertyValueChanged
    extends DiffRecord {
        final MFWNodeHandle m_nodeModelObject_OldModel;
        final MFWNodeHandle m_nodeModelObject_NewModel;
        final String m_objectID_OldModel;
        final String m_objectID_NewModel;
        final MFWNodeHandle m_nodeProperty_OldModel;
        final MFWNodeHandle m_nodeProperty_NewModel;
        final String m_propertyID;
        final String m_propertyValue_OldModel;
        final String m_propertyValue_NewModel;

        DiffRecord_PropertyValueChanged(String guidModelObject, MFWNodeHandle nodeModelObject_OldModel, MFWNodeHandle nodeModelObject_NewModel, MFWNodeHandle nodeProperty_OldModel, MFWNodeHandle nodeProperty_NewModel, String propertyID, String propertyValue_OldModel, String propertyValue_NewModel) {
            super(guidModelObject, nodeModelObject_NewModel);
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid guid NULL value");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid guid empty string value");
            MFWException.ASSERT((nodeModelObject_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeModelObject_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeProperty_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property node NULL value");
            MFWException.ASSERT((nodeProperty_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property node NULL value");
            MFWException.ASSERT((propertyID != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property ID null value");
            MFWException.ASSERT((propertyID != "" ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property ID value");
            MFWException.ASSERT((propertyValue_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property null value");
            MFWException.ASSERT((propertyValue_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyValueChanged Record:  Invalid property null value");
            this.m_nodeModelObject_OldModel = nodeModelObject_OldModel;
            this.m_nodeModelObject_NewModel = nodeModelObject_NewModel;
            this.m_objectID_OldModel = ModelDiff.this.m_fmModel_Old.getModelObjectID(nodeModelObject_OldModel);
            this.m_objectID_NewModel = ModelDiff.this.m_fmModel_New.getModelObjectID(nodeModelObject_NewModel);
            this.m_nodeProperty_OldModel = nodeProperty_OldModel;
            this.m_nodeProperty_NewModel = nodeProperty_NewModel;
            this.m_propertyID = propertyID;
            this.m_propertyValue_OldModel = propertyValue_OldModel;
            this.m_propertyValue_NewModel = propertyValue_NewModel;
        }

        @Override
        void write(Writer xmlDiffReport) throws IOException {
            String sModelObjectType = ModelDiff.this.m_fmModel_New.getModelObjectTypeName(this.m_nodeModelObject_NewModel);
            String sRecordInfo = "<PropertyChanged><objectType>" + CCLXMLUtils.xmlEncode((String)sModelObjectType) + "</objectType>" + "<objectIDOldModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_OldModel) + "</objectIDOldModel>" + "<objectIDNewModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_NewModel) + "</objectIDNewModel>" + "<guid>" + CCLXMLUtils.xmlEncode((String)this.m_guidModelObject) + "</guid>" + "<propertyName>" + CCLXMLUtils.xmlEncode((String)this.m_propertyID) + "</propertyName>" + "<propertyOldValue>" + CCLXMLUtils.xmlEncode((String)this.m_propertyValue_OldModel) + "</propertyOldValue>" + "<propertyNewValue>" + CCLXMLUtils.xmlEncode((String)this.m_propertyValue_NewModel) + "</propertyNewValue>" + this.getXmlChangeManagementInfo() + "</PropertyChanged>";
            xmlDiffReport.write(sRecordInfo);
        }
    }

    public final class DiffRecord_PropertyDeleted
    extends DiffRecord {
        public final MFWNodeHandle m_nodeModelObject_OldModel;
        public final MFWNodeHandle m_nodeModelObject_NewModel;
        public final String m_objectID_NewModel;
        public final String m_objectID_OldModel;
        public final MFWNodeHandle m_nodeProperty_OldModel;
        public final String m_propertyID;
        public final String m_propertyValue_OldModel;

        DiffRecord_PropertyDeleted(String guidModelObject, MFWNodeHandle nodeModelObject_OldModel, MFWNodeHandle nodeModelObject_NewModel, MFWNodeHandle nodeProperty_OldModel, String propertyID, String propertyValue_OldModel) {
            super(guidModelObject, nodeModelObject_NewModel);
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid guid NULL value");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid guid empty string value");
            MFWException.ASSERT((nodeModelObject_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeModelObject_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeProperty_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid property node NULL value");
            MFWException.ASSERT((propertyID != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid property ID null value");
            MFWException.ASSERT((propertyID != "" ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid property ID value");
            MFWException.ASSERT((propertyValue_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyDeleted Record:  Invalid property null value");
            this.m_nodeModelObject_OldModel = nodeModelObject_OldModel;
            this.m_nodeModelObject_NewModel = nodeModelObject_NewModel;
            this.m_objectID_NewModel = ModelDiff.this.m_fmModel_New.getModelObjectID(nodeModelObject_NewModel);
            this.m_objectID_OldModel = ModelDiff.this.m_fmModel_Old.getModelObjectID(nodeModelObject_OldModel);
            this.m_nodeProperty_OldModel = nodeProperty_OldModel;
            this.m_propertyID = propertyID;
            this.m_propertyValue_OldModel = propertyValue_OldModel;
        }

        @Override
        void write(Writer xmlDiffReport) throws IOException {
            String sModelObjectType = ModelDiff.this.m_fmModel_New.getModelObjectTypeName(this.m_nodeModelObject_NewModel);
            String sRecordInfo = "<PropertyDeleted><objectType>" + CCLXMLUtils.xmlEncode((String)sModelObjectType) + "</objectType>" + "<objectIDOldModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_OldModel) + "</objectIDOldModel>" + "<objectIDNewModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_NewModel) + "</objectIDNewModel>" + "<guid>" + CCLXMLUtils.xmlEncode((String)this.m_guidModelObject) + "</guid>" + "<propertyName>" + CCLXMLUtils.xmlEncode((String)this.m_propertyID) + "</propertyName>" + "<propertyOldValue>" + CCLXMLUtils.xmlEncode((String)this.m_propertyValue_OldModel) + "</propertyOldValue>" + this.getXmlChangeManagementInfo() + "</PropertyDeleted>";
            xmlDiffReport.write(sRecordInfo);
        }
    }

    public final class DiffRecord_PropertyAdded
    extends DiffRecord {
        public final MFWNodeHandle m_nodeModelObject_OldModel;
        public final MFWNodeHandle m_nodeModelObject_NewModel;
        public final String m_objectID_NewModel;
        public final String m_objectID_OldModel;
        public final MFWNodeHandle m_nodeProperty_NewModel;
        public final String m_propertyID;
        public final String m_propertyValue_NewModel;

        DiffRecord_PropertyAdded(String guidModelObject, MFWNodeHandle nodeModelObject_OldModel, MFWNodeHandle nodeModelObject_NewModel, MFWNodeHandle nodeProperty_NewModel, String propertyID, String propertyValue_NewModel) {
            super(guidModelObject, nodeModelObject_NewModel);
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid guid NULL value");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid guid empty string value");
            MFWException.ASSERT((nodeModelObject_OldModel != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeModelObject_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid model object node NULL value");
            MFWException.ASSERT((nodeProperty_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid property node NULL value");
            MFWException.ASSERT((propertyID != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid property ID null value");
            MFWException.ASSERT((propertyID != "" ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid property ID value");
            MFWException.ASSERT((propertyValue_NewModel != null ? 1 : 0) != 0, (String)"Diff PropertyAdded Record:  Invalid property null value");
            this.m_nodeModelObject_OldModel = nodeModelObject_OldModel;
            this.m_nodeModelObject_NewModel = nodeModelObject_NewModel;
            this.m_objectID_NewModel = ModelDiff.this.m_fmModel_New.getModelObjectID(nodeModelObject_NewModel);
            this.m_objectID_OldModel = ModelDiff.this.m_fmModel_Old.getModelObjectID(nodeModelObject_OldModel);
            this.m_nodeProperty_NewModel = nodeProperty_NewModel;
            this.m_propertyID = propertyID;
            this.m_propertyValue_NewModel = propertyValue_NewModel;
        }

        @Override
        void write(Writer xmlDiffReport) throws IOException {
            String sModelObjectType = ModelDiff.this.m_fmModel_New.getModelObjectTypeName(this.m_nodeModelObject_NewModel);
            String sRecordInfo = "<PropertyAdded><objectType>" + CCLXMLUtils.xmlEncode((String)sModelObjectType) + "</objectType>" + "<objectIDOldModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_OldModel) + "</objectIDOldModel>" + "<objectIDNewModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_NewModel) + "</objectIDNewModel>" + "<guid>" + CCLXMLUtils.xmlEncode((String)this.m_guidModelObject) + "</guid>" + "<propertyName>" + CCLXMLUtils.xmlEncode((String)this.m_propertyID) + "</propertyName>" + "<propertyNewValue>" + CCLXMLUtils.xmlEncode((String)this.m_propertyValue_NewModel) + "</propertyNewValue>" + this.getXmlChangeManagementInfo() + "</PropertyAdded>";
            xmlDiffReport.write(sRecordInfo);
        }
    }

    public final class DiffRecord_ObjectDeleted
    extends DiffRecord {
        public final MFWNodeHandle m_nodeModelObject_OldModel;
        public final String m_objectID_OldModel;

        DiffRecord_ObjectDeleted(String guidModelObject, MFWNodeHandle nodeModelObject_OldModel) {
            super(guidModelObject, null);
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Diff Record:  Invalid guid NULL value");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Diff Record:  Invalid guid empty string value");
            MFWException.ASSERT((nodeModelObject_OldModel != null ? 1 : 0) != 0, (String)"Diff Record:  Invalid node NULL value");
            this.m_nodeModelObject_OldModel = nodeModelObject_OldModel;
            this.m_objectID_OldModel = ModelDiff.this.m_fmModel_Old.getModelObjectID(nodeModelObject_OldModel);
        }

        @Override
        void write(Writer xmlDiffReport) throws IOException {
            String sModelObjectType = ModelDiff.this.m_fmModel_Old.getModelObjectTypeName(this.m_nodeModelObject_OldModel);
            String sRecordInfo = "<modelObjectDeleted><objectType>" + CCLXMLUtils.xmlEncode((String)sModelObjectType) + "</objectType>" + "<objectIDOldModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_OldModel) + "</objectIDOldModel>" + "<guid>" + CCLXMLUtils.xmlEncode((String)this.m_guidModelObject) + "</guid>" + "</modelObjectDeleted>";
            xmlDiffReport.write(sRecordInfo);
        }
    }

    public final class DiffRecord_ObjectAdded
    extends DiffRecord {
        public final MFWNodeHandle m_nodeModelObject_NewModel;
        public final String m_objectID_NewModel;

        DiffRecord_ObjectAdded(String guidModelObject, MFWNodeHandle nodeModelObject_NewModel) {
            super(guidModelObject, nodeModelObject_NewModel);
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Diff Record:  Invalid guid NULL value");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Diff Record:  Invalid guid empty string value");
            MFWException.ASSERT((nodeModelObject_NewModel != null ? 1 : 0) != 0, (String)"Diff Record:  Invalid node NULL value");
            this.m_nodeModelObject_NewModel = nodeModelObject_NewModel;
            this.m_objectID_NewModel = ModelDiff.this.m_fmModel_New.getModelObjectID(nodeModelObject_NewModel);
        }

        @Override
        void write(Writer xmlDiffReport) throws IOException {
            String sModelObjectType = ModelDiff.this.m_fmModel_New.getModelObjectTypeName(this.m_nodeModelObject_NewModel);
            String sRecordInfo = "<modelObjectAdded><objectType>" + CCLXMLUtils.xmlEncode((String)sModelObjectType) + "</objectType>" + "<objectIDNewModel>" + CCLXMLUtils.xmlEncode((String)this.m_objectID_NewModel) + "</objectIDNewModel>" + "<guid>" + CCLXMLUtils.xmlEncode((String)this.m_guidModelObject) + "</guid>" + this.getXmlChangeManagementInfo() + "</modelObjectAdded>";
            xmlDiffReport.write(sRecordInfo);
        }
    }

    abstract class DiffRecord {
        protected final String m_guidModelObject;
        protected final String m_lastChangedDate;
        protected final String m_lastChangedUser;
        protected final String m_lastChangedComment;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DiffRecord(String guidModelObject, MFWNodeHandle node) {
            MFWException.ASSERT((guidModelObject != null ? 1 : 0) != 0, (String)"Model Objects cannot have null guids");
            MFWException.ASSERT((!"".equals(guidModelObject) ? 1 : 0) != 0, (String)"Model Objects cannot have empty string guids");
            this.m_guidModelObject = guidModelObject;
            String lastChangedDate = "";
            try {
                if (node != null) {
                    lastChangedDate = ModelDiff.this.m_fmModel_New.getGateway().getObjectPropertyValue(node, MFWModelRes.getInstance().RID_lastChanged);
                }
            }
            catch (MFWException e) {
                String message = e.getMessage();
                System.err.println(message);
                System.err.flush();
            }
            finally {
                this.m_lastChangedDate = lastChangedDate;
            }
            String lastChangedUser = "";
            try {
                if (node != null) {
                    lastChangedUser = ModelDiff.this.m_fmModel_New.getGateway().getObjectPropertyValue(node, MFWModelRes.getInstance().RID_lastChangedBy);
                }
            }
            catch (MFWException e) {
                String message = e.getMessage();
                System.err.println(message);
                System.err.flush();
            }
            finally {
                this.m_lastChangedUser = lastChangedUser;
            }
            String lastChangedComment = "";
            try {
                if (node != null) {
                    lastChangedComment = ModelDiff.this.m_fmModel_New.getGateway().getObjectPropertyValue(node, MFWModelRes.getInstance().RID_comment);
                }
            }
            catch (MFWException e) {
                String message = e.getMessage();
                System.err.println(message);
                System.err.flush();
            }
            finally {
                this.m_lastChangedComment = lastChangedComment;
            }
        }

        abstract void write(Writer var1) throws IOException;

        protected String getXmlChangeManagementInfo() throws IOException {
            String sChangeMgmtInfo = "";
            if (this.m_lastChangedDate.length() > 0) {
                sChangeMgmtInfo = sChangeMgmtInfo + "<lastChangedDate>" + CCLXMLUtils.xmlEncode((String)this.m_lastChangedDate) + "</lastChangedDate>";
            }
            if (this.m_lastChangedUser.length() > 0) {
                sChangeMgmtInfo = sChangeMgmtInfo + "<lastChangedUser>" + CCLXMLUtils.xmlEncode((String)this.m_lastChangedUser) + "</lastChangedUser>";
            }
            if (this.m_lastChangedComment.length() > 0) {
                sChangeMgmtInfo = sChangeMgmtInfo + "<lastChangedComment>" + CCLXMLUtils.xmlEncode((String)this.m_lastChangedComment) + "</lastChangedComment>";
            }
            return sChangeMgmtInfo;
        }
    }
}

