/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.modelDiff;

import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.modelDiff.ModelDiff;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Element;

public final class ModelDiffCommand
extends Command {
    public Vector getRequiredCapabilities() {
        return null;
    }

    public BIBusEnvelope execute(Element requestRootElem, MessageContext mc, HashMap serviceParams) throws MDSRVException {
        BIBusEnvelope response = new BIBusEnvelope();
        Element responseBody = response.getBody();
        Element responseRoot = responseBody.addElement("pingResponse");
        responseRoot.addText("ModelDiffCommand: execute() has been pinged.\n");
        return response;
    }

    public boolean abandonRequest(MessageContext mc) {
        return false;
    }

    public boolean cancelRequest(MessageContext mc) {
        return false;
    }

    @Override
    public boolean getOutputForRequest(MessageContext mc) {
        return false;
    }

    public boolean invokeRequest(MessageContext mc) {
        boolean isFaulted = false;
        try {
            BIBusEnvelope soapRequest = (BIBusEnvelope)mc.getProperty("request.envelope");
            Element requestBody = soapRequest.getBody();
            Iterator childElemsIter = requestBody.elementIterator();
            Element diffCommandElem = null;
            if (childElemsIter.hasNext()) {
                diffCommandElem = (Element)childElemsIter.next();
            }
            String xmlDiffReport = "ModelDiffCommand: invokeRequest() has been pinged.\n";
            if (diffCommandElem != null) {
                Element diffCommandArgs = diffCommandElem.element("Arguments");
                Element diffModelOld = diffCommandArgs.element("oldModel");
                Element diffModelNew = diffCommandArgs.element("newModel");
                xmlDiffReport = this.doModeldiff(diffModelOld.getText(), diffModelNew.getText());
            }
            BIBusEnvelope soapResponse = new BIBusEnvelope();
            soapResponse.getBody().setText(xmlDiffReport);
            mc.setProperty("response.envelope", (Object)soapResponse);
            return true;
        }
        catch (MDSRVException mdsrvExc) {
            Fault fault = mdsrvExc.getFault();
            mc.setFault(fault);
            isFaulted = true;
        }
        catch (Exception ex) {
            Fault fault = new Fault(MDSRVException.determineMessageCode(ex), ex);
            mc.setFault(fault);
            isFaulted = true;
        }
        catch (Throwable th) {
            Fault fault = new Fault(MDSRVException.determineMessageCode(th));
            mc.setFault(fault);
            isFaulted = true;
        }
        return isFaulted;
    }

    private String doModeldiff(String xpathOldModel, String xpathNewModel) throws IOException {
        ModelDiff myDiff = new ModelDiff();
        String sGatewayID = "mfwTest";
        String sProductLocale = "en";
        String sContentLocale = "en";
        String sCMUserNamespace = "";
        String sCMUserId = "";
        String sCMPassword = "";
        myDiff.initConnectionVariables(sGatewayID, sProductLocale, sContentLocale, sCMUserNamespace, sCMUserId, sCMPassword);
        myDiff.openOldModel(xpathOldModel);
        myDiff.openNewModel(xpathNewModel);
        myDiff.createDiffRecords();
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        myDiff.createDiffReport(bw);
        bw.close();
        return sw.toString();
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean releaseRequest(MessageContext mc) {
        return false;
    }

    @Override
    public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
        return false;
    }
}

