/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringArrayProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandFixtures;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.metadataService.command.personalData.PersonalDataGovernors;
import com.cognos.metadataService.command.personalData.PersonalDataRelationBuilder;
import com.cognos.metadataService.command.personalData.UpdateMetadataHandler;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.misc.XMLHelper;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.RequestInvoker;
import com.cognos.pogo.util.CROneCookie;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class CommandAddData
extends Command {
    private static StringBuffer gTemplateModel = null;
    private static StringBuffer gTemplateScript = null;
    private static StringBuffer gTemplatePDNamespace = null;
    private static StringBuffer gTemplateQSubj = null;
    private static StringBuffer gTemplateQItem = null;
    private static StringBuffer gTemplateQItem2 = null;
    private static StringBuffer gTemplateDataSrc = null;
    private static StringBuffer gTemplateCustomProp = null;
    private String mBaseModel = null;
    private String mReqContentLocale = null;
    private String mContentLocale = null;
    private PersonalDataRelationBuilder mRelBuilder = null;
    private StringBuffer mRelationshipIDs = new StringBuffer();
    private StringBuffer mPersonalDataNamespaces = new StringBuffer();
    private StringBuffer mPersonalDataSources = new StringBuffer();
    private String mTargetSavePath;
    private String mTargetSaveName;
    private String mRootNamespaceName = "Model";
    private ArrayList<ArrayList<String>> mMetadataInfo = new ArrayList();
    private ArrayList<ArrayList<String>> mMetadataInfoSession = new ArrayList();
    private String mDatasetName;
    private String mModelPathElement = "/model";
    private String mRoutingServerGroup = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invokeRequest(MessageContext mc) {
        this.mCommandKey = new CommandKey(mc);
        Element elmCommand = this.mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return true;
        }
        this.fixupNamespaceName(elmCommand);
        this.prepareState(mc, elmCommand);
        this.processPersonalDataDefinitions(elmCommand);
        String sModel = this.generateModel(mc, elmCommand);
        String sModelFilePath = this.writeBmeModel(mc, sModel);
        String sScript = this.generateScript();
        this.publishModel(mc, sModelFilePath, sScript);
        if (this.metadataChanged()) {
            this.deletePdSpecInSession();
        }
        if (this.mRoutingServerGroup != null) {
            StringBuilder sourcePackageSearchPath = new StringBuilder(this.mBaseModel);
            sourcePackageSearchPath.replace(sourcePackageSearchPath.lastIndexOf(this.mModelPathElement), sourcePackageSearchPath.length(), "");
            _package sourcePackage = this.getPackageFromCM(sourcePackageSearchPath.toString());
            if (sourcePackage == null) throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_LIN_InvalidCMSearchPath, sourcePackageSearchPath.toString());
            StringProp serverGroupProp = sourcePackage.getRoutingServerGroup();
            assert (serverGroupProp != null);
            String routingServerGroup = serverGroupProp.getValue();
            assert (this.mRoutingServerGroup.equals(routingServerGroup));
            StringBuilder externalPackageSearchPath = new StringBuilder(this.getTargetModelPath());
            externalPackageSearchPath.replace(externalPackageSearchPath.lastIndexOf(this.mModelPathElement), externalPackageSearchPath.length(), "");
            _package externalPackage = this.getPackageFromCM(externalPackageSearchPath.toString());
            if (externalPackage == null) throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_LIN_InvalidCMSearchPath, externalPackageSearchPath.toString());
            StringArrayProp packageRoutingHints = sourcePackage.getRoutingHints();
            this.updateRoutingHintCMPackage(externalPackage, packageRoutingHints);
        }
        this.generateResponse(mc);
        return false;
    }

    private void fixupNamespaceName(Element elmCommand) {
        Element elmName = (Element)elmCommand.selectSingleNode("input/pdCollection/pdSpec/dataSet/name");
        if (elmName != null) {
            Matcher m;
            String namespaceNameTrimmed;
            String namespaceName = elmName.getText();
            if (namespaceName.equals(namespaceNameTrimmed = namespaceName.trim())) {
                return;
            }
            String namespaceNameTrimBrackets = "[" + namespaceNameTrimmed + "]";
            elmName.setText(namespaceNameTrimmed);
            String regex = "\\[\\s*" + namespaceNameTrimmed + "\\s*\\]";
            Pattern p = Pattern.compile(regex);
            Element elmPersonalData = (Element)elmCommand.selectSingleNode("input/pdCollection/pdSpec/personalData");
            if (elmPersonalData != null) {
                String name = elmPersonalData.attributeValue("name");
                name = name.trim();
                elmPersonalData.addAttribute("name", name);
                String id = elmPersonalData.attributeValue("ID");
                Matcher m2 = p.matcher(id);
                id = m2.replaceAll(namespaceNameTrimBrackets);
                elmPersonalData.addAttribute("ID", id);
            }
            List listPersonalDataItems = elmCommand.selectNodes("input/pdCollection/pdSpec/personalData/item");
            for (Element elmItem : listPersonalDataItems) {
                String name = elmItem.attributeValue("ID");
                m = p.matcher(name);
                name = m.replaceAll(namespaceNameTrimBrackets);
                elmItem.addAttribute("ID", name);
            }
            Element elmCntID = (Element)elmCommand.selectSingleNode("containerID");
            if (elmCntID != null) {
                String containerID = elmCntID.getText();
                m = p.matcher(containerID);
                containerID = m.replaceAll(namespaceNameTrimBrackets);
                elmCntID.setText(containerID);
            }
        }
    }

    void generateResponse(MessageContext mc) {
        StringBuffer targetPkgPath = new StringBuffer(this.mTargetSavePath);
        String packageNameSeparator = this.mTargetSaveName.contains("\"") ? "'" : "\"";
        targetPkgPath.append("/package[@name=");
        targetPkgPath.append(packageNameSeparator);
        targetPkgPath.append(this.mTargetSaveName);
        targetPkgPath.append(packageNameSeparator);
        targetPkgPath.append("]");
        DocumentFactory fac = new DocumentFactory();
        Element elmResponse = fac.createElement("output");
        elmResponse.addElement("personalPackagePath").addText(targetPkgPath.toString());
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(elmResponse);
        mc.setProperty("response.envelope", (Object)soapResponse);
    }

    void prepareState(MessageContext mc, Element elmCommand) {
        Element elmModel;
        BIBusEnvelope soapRequest = (BIBusEnvelope)mc.getProperty("request.envelope");
        String cookieString = soapRequest.getCookieValue("CRN");
        CROneCookie aCookie = cookieString == null ? null : new CROneCookie(cookieString);
        this.mRoutingServerGroup = soapRequest.getRoutingServerGroup();
        if (aCookie != null) {
            this.mReqContentLocale = (String)aCookie.getPreferences().get("contentLocale");
        }
        if (this.mReqContentLocale == null) {
            this.mReqContentLocale = soapRequest.getUserPreferenceValue("contentLocale");
        }
        if (this.mReqContentLocale == null) {
            this.mReqContentLocale = "en";
        }
        if ((elmModel = (Element)elmCommand.selectSingleNode(".//baseModelSearchPath")) != null) {
            this.mBaseModel = elmModel.getText();
        }
        if (this.mBaseModel == null || this.mBaseModel.length() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "pdCollection/baseModelSearchPath");
        }
        this.setTargetPackagePath(elmCommand);
        this.mRelBuilder = new PersonalDataRelationBuilder(soapRequest, this.mBaseModel);
        this.mContentLocale = this.mRelBuilder.getBaseDesignLocale(this.mReqContentLocale);
        Element elmPersonalData = (Element)elmCommand.selectSingleNode("input/pdCollection/pdSpec/personalData");
        if (elmPersonalData != null) {
            this.mDatasetName = elmPersonalData.attributeValue("name");
            List listPersonalDataItems = elmCommand.selectNodes("input/pdCollection/pdSpec/personalData/item");
            if (listPersonalDataItems.size() > 0) {
                for (Element elmItem : listPersonalDataItems) {
                    String name = elmItem.attributeValue("name");
                    String datatype = elmItem.attributeValue("datatype");
                    String precision = elmItem.attributeValue("precision");
                    String scale = elmItem.attributeValue("scale");
                    ArrayList<String> itemInfo = new ArrayList<String>();
                    itemInfo.add(name);
                    itemInfo.add(datatype);
                    itemInfo.add(precision);
                    itemInfo.add(scale);
                    this.mMetadataInfo.add(itemInfo);
                }
            }
        }
    }

    void processPersonalDataDefinitions(Element elmCommand) {
        this.ensureNameUniqueness(elmCommand);
        this.fixNamespaceCollisions(elmCommand);
        List lstSpecs = elmCommand.selectNodes(".//pdSpec");
        if (lstSpecs.size() > 0) {
            PersonalDataGovernors myGov = new PersonalDataGovernors(this.mRelBuilder.getMFWGateway());
            myGov.enforceMaxSources(lstSpecs.size());
        }
        ArrayList<String> baseModelDSNames = this.mRelBuilder.collectBaseModelDataSourceNames();
        for (int idx = 0; idx < lstSpecs.size(); ++idx) {
            Element elmSpec = (Element)lstSpecs.get(idx);
            this.createPersonalData(elmSpec, baseModelDSNames);
        }
        this.mRelBuilder.closeGateway();
    }

    private void ensureNameUniqueness(Element elmCommand) {
        List lstNames = elmCommand.selectNodes(".//pdSpec/dataSet/name");
        ArrayList<String> tempList = new ArrayList<String>(lstNames.size() + 2);
        for (int idx = 0; idx < lstNames.size(); ++idx) {
            String aName = ((Element)lstNames.get(idx)).getTextTrim();
            if (tempList.contains(aName)) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_DuplicateSpecName, aName);
            }
            tempList.add(aName);
        }
        List lstRSubjs = elmCommand.selectNodes(".//pdSpec/reportExtract/reportSubject");
        for (int idx = 0; idx < lstRSubjs.size(); ++idx) {
            String aName = ((Element)lstRSubjs.get(idx)).attributeValue("name");
            if (tempList.contains(aName)) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_DuplicateSpecName, aName);
            }
            tempList.add(aName);
        }
    }

    private void fixNamespaceCollisions(Element elmCommand) {
        ArrayList<String> namesToCheck = this.mRelBuilder.collectBaseModelNamespaceNames();
        if (namesToCheck.contains(this.mRootNamespaceName)) {
            this.mRootNamespaceName = MFWStringHelper.makeUnique((String)this.mRootNamespaceName, namesToCheck, (boolean)false);
        }
        List lstNames = elmCommand.selectNodes(".//pdSpec/dataSet/name");
        for (int idx = 0; idx < lstNames.size(); ++idx) {
            String pdsName = ((Element)lstNames.get(idx)).getTextTrim();
            if (!namesToCheck.contains(pdsName)) continue;
            pdsName = MFWStringHelper.makeUnique((String)pdsName, namesToCheck, (boolean)false);
            ((Element)lstNames.get(idx)).setText(pdsName);
        }
    }

    private void setTargetPackagePath(Element elmCommand) {
        int idxStart = this.mBaseModel.indexOf("/package[@name='");
        if (idxStart <= 0) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, this.mBaseModel, "pdCollection/baseModelSearchPath");
        }
        String baseModelPkgCont = this.mBaseModel.substring(0, idxStart);
        int idxEnd = this.mBaseModel.indexOf("']", idxStart + 16);
        if (idxEnd <= 0) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, this.mBaseModel, "pdCollection/baseModelSearchPath");
        }
        String baseModelPkgName = this.mBaseModel.substring(idxStart + 16, idxEnd);
        this.mTargetSavePath = "~/folder[@name='My Folders']";
        Element elmPath = (Element)elmCommand.selectSingleNode(".//pdCollection/targetPath");
        if (elmPath != null && elmPath.getText() != null && elmPath.getText().length() > 0) {
            this.mTargetSavePath = elmPath.getText();
        }
        this.mTargetSaveName = baseModelPkgName;
        Element elmName = (Element)elmCommand.selectSingleNode(".//pdCollection/targetName");
        if (elmName != null && elmName.getText() != null && elmName.getText().length() > 0) {
            this.mTargetSaveName = elmName.getText();
        }
        if (baseModelPkgCont.equals(this.mTargetSavePath) && baseModelPkgName.equals(this.mTargetSaveName)) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_InvalidTargetPkgPath, this.getTargetModelPath());
        }
    }

    private String getTargetModelPath() {
        StringBuffer outStr = new StringBuffer(this.mTargetSavePath);
        outStr.append("/package[@name='");
        outStr.append(this.mTargetSaveName);
        outStr.append("']/model");
        return outStr.toString();
    }

    private String getPersonalDataConnectionString(String pdsName, boolean isPersonalData) {
        try {
            StringBuffer outPath = new StringBuffer("#'' + getConfigurationEntry(\"sdk\") + ");
            outPath.append("'/metadataUIService?pid=xml_dstream&amp;m_passportID=' + CAMPassport() + '&amp;");
            if (isPersonalData) {
                outPath.append("st=s&amp;pds=");
            } else {
                outPath.append("st=r&amp;pds=");
            }
            outPath.append(URLEncoder.encode(pdsName, "UTF8"));
            outPath.append("&amp;contentLocale=");
            outPath.append(URLEncoder.encode(this.mReqContentLocale, "UTF8"));
            outPath.append("&amp;model=' + urlencode($modelPath) + ''#");
            return outPath.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void createPersonalData(Element elmSpec, ArrayList<String> baseModelDSNames) {
        String pdsName = ((Element)elmSpec.selectSingleNode("dataSet/name")).getText();
        String namespaceID = MFWCrnIDHelper.addEntryToID((String)"", (String)pdsName);
        Element elmCntID = (Element)elmSpec.selectSingleNode("containerID");
        if (elmCntID == null) {
            elmSpec.addElement("containerID").addText(namespaceID);
        } else {
            elmCntID.setText(namespaceID);
        }
        String pdNamespace = gTemplatePDNamespace.toString();
        pdNamespace = MFWStringHelper.replaceAll((String)pdNamespace, (String)"#PDSNAME#", (String)MFWStringHelper.escapeXMLChars((String)pdsName));
        pdNamespace = MFWStringHelper.replaceAll((String)pdNamespace, (String)"#LOCALE#", (String)this.mContentLocale);
        pdNamespace = MFWStringHelper.replaceAll((String)pdNamespace, (String)"#PDSPEC#", (String)MFWStringHelper.escapeXMLChars((String)elmSpec.asXML()));
        this.mRelBuilder.makeRelationships(namespaceID, elmSpec);
        pdNamespace = MFWStringHelper.replaceAll((String)pdNamespace, (String)"#RELATIONSHIPS#", (String)this.mRelBuilder.getRelationshipsSpec());
        String dataSrcName = pdsName;
        if (baseModelDSNames.contains(dataSrcName)) {
            dataSrcName = MFWStringHelper.makeUnique((String)dataSrcName, baseModelDSNames, (boolean)false);
        }
        String qsName = elmSpec.element("personalData").attributeValue("name");
        String sQuerySubjects = this.createQuerySubject(elmSpec, qsName, dataSrcName, "personalData/item");
        String sDataSources = this.createDataSource(elmSpec, dataSrcName, true);
        if (elmSpec.element("reportExtract") != null) {
            String reportExtName = ((Element)elmSpec.selectSingleNode("reportExtract/reportSubject")).attributeValue("name");
            dataSrcName = reportExtName;
            if (baseModelDSNames.contains(dataSrcName)) {
                dataSrcName = MFWStringHelper.makeUnique((String)dataSrcName, baseModelDSNames, (boolean)false);
            }
            sQuerySubjects = sQuerySubjects + this.createQuerySubject(elmSpec, reportExtName, dataSrcName, "reportExtract/reportSubject/item");
            sDataSources = sDataSources + this.createDataSource(elmSpec, dataSrcName, false);
        }
        pdNamespace = MFWStringHelper.replaceAll((String)pdNamespace, (String)"#QUERYSUBJECTS#", (String)sQuerySubjects);
        this.mPersonalDataNamespaces.append(pdNamespace);
        this.mRelationshipIDs.append(this.mRelBuilder.getRelationshipRefs());
        this.mPersonalDataSources.append(sDataSources);
    }

    private String createQuerySubject(Element elmSpec, String nameQuerySubj, String nameDataSrc, String xpathItems) {
        String sQuerySubj = gTemplateQSubj.toString();
        sQuerySubj = MFWStringHelper.replaceAll((String)sQuerySubj, (String)"#LOCALE#", (String)this.mContentLocale);
        sQuerySubj = MFWStringHelper.replaceAll((String)sQuerySubj, (String)"#PDQSUBJNAME#", (String)MFWStringHelper.escapeXMLChars((String)nameQuerySubj));
        String pdsName_esc = MFWStringHelper.escapeXMLChars((String)nameDataSrc);
        sQuerySubj = MFWStringHelper.replaceAll((String)sQuerySubj, (String)"#PDSNAME#", (String)pdsName_esc);
        sQuerySubj = MFWStringHelper.replaceAll((String)sQuerySubj, (String)"#PDSNAME_ESC#", (String)pdsName_esc.replaceAll("]", "]]"));
        StringBuffer qItems = new StringBuffer();
        String tmplQItem = "";
        List lstItems = elmSpec.selectNodes(xpathItems);
        for (int idx = 0; idx < lstItems.size(); ++idx) {
            String size;
            String sSemiAgg;
            String sRegAgg;
            Element elm = (Element)lstItems.get(idx);
            String type = elm.attributeValue("datatype");
            boolean qiStrType = false;
            if (!"characterLength16".equals(type) && !"characterLength32".equals(type)) {
                tmplQItem = gTemplateQItem.toString();
            } else {
                String precision = elm.attributeValue("precision");
                if (precision == null || precision.length() == 0) {
                    tmplQItem = gTemplateQItem2.toString();
                    qiStrType = true;
                } else {
                    tmplQItem = gTemplateQItem.toString();
                }
            }
            String sHidden = elm.attributeValue("hidden");
            if (sHidden != null && sHidden.contentEquals("true")) continue;
            String qName = elm.attributeValue("name");
            String qItem = MFWStringHelper.replaceAll((String)tmplQItem, (String)"#COLNAME#", (String)MFWStringHelper.escapeXMLChars((String)qName));
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#LOCALE#", (String)this.mContentLocale);
            PersonalDataConvertorHelper.DataTypeInfo dTypeInfo = PersonalDataConvertorHelper.getMFWMapingInfo(elm.attributeValue("datatype"));
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#DATATYPE#", (String)elm.attributeValue("datatype"));
            String[] outValues = PersonalDataConvertorHelper.calculateBasicUsageAggregate(dTypeInfo, this.mRelBuilder.isRelated(elm.attributeValue("ID")));
            String sUsage = elm.attributeValue("usage");
            if (sUsage == null || sUsage.length() == 0) {
                sUsage = outValues[0];
            }
            if ((sRegAgg = elm.attributeValue("regularAggregate")) == null || sRegAgg.length() == 0) {
                sRegAgg = outValues[1];
            }
            if ((sSemiAgg = elm.attributeValue("semiAggregate")) == null || sSemiAgg.length() == 0) {
                sSemiAgg = outValues[2];
            }
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#USAGE#", (String)sUsage);
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#REGULARAGGREGATE#", (String)sRegAgg);
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#SEMIAGGREGATE#", (String)sSemiAgg);
            if (!qiStrType) {
                String precision = elm.attributeValue("precision");
                if (precision == null || precision.length() == 0) {
                    precision = Integer.toString(dTypeInfo.getDefaultPrecision());
                }
                qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#PRECISION#", (String)precision);
                String scale = elm.attributeValue("scale");
                if (scale == null || scale.length() == 0) {
                    scale = Integer.toString(dTypeInfo.getDefaultScale());
                }
                qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#SCALE#", (String)scale);
            }
            if ((size = elm.attributeValue("length")) == null || 0 >= Integer.parseInt(size)) {
                size = Integer.toString(dTypeInfo.getDefaultSize());
            }
            qItem = MFWStringHelper.replaceAll((String)qItem, (String)"#SIZE#", (String)size);
            qItems.append(qItem);
        }
        sQuerySubj = MFWStringHelper.replaceAll((String)sQuerySubj, (String)"#QUERYITEMS#", (String)qItems.toString());
        return sQuerySubj;
    }

    private String createDataSource(Element elmSpec, String nameDataSrc, boolean isPersonalData) {
        String sDataSrc = gTemplateDataSrc.toString();
        sDataSrc = MFWStringHelper.replaceAll((String)sDataSrc, (String)"#PDSNAME#", (String)MFWStringHelper.escapeXMLChars((String)nameDataSrc));
        StringBuffer custProps = new StringBuffer();
        String sPropSrcType = gTemplateCustomProp.toString();
        sPropSrcType = MFWStringHelper.replaceAll((String)sPropSrcType, (String)"#PROPNAME#", (String)"sourceType");
        sPropSrcType = MFWStringHelper.replaceAll((String)sPropSrcType, (String)"#PROPVALUE#", (String)(isPersonalData ? "personalData" : "reportExtract"));
        custProps.append(sPropSrcType);
        String sPropSrcPath = gTemplateCustomProp.toString();
        sPropSrcPath = MFWStringHelper.replaceAll((String)sPropSrcPath, (String)"#PROPNAME#", (String)"sourcePath");
        sPropSrcPath = MFWStringHelper.replaceAll((String)sPropSrcPath, (String)"#PROPVALUE#", (String)(isPersonalData ? MFWStringHelper.escapeXMLChars((String)((Element)elmSpec.selectSingleNode("dataSet/sourcePath")).getTextTrim()) : MFWStringHelper.escapeXMLChars((String)((Element)elmSpec.selectSingleNode("reportExtract/reportSearchPath")).getTextTrim())));
        custProps.append(sPropSrcPath);
        Element elmAccessDirectly = (Element)elmSpec.selectSingleNode("dataSet/accessDirectly");
        if (elmAccessDirectly != null) {
            String sPropSrcDirect = gTemplateCustomProp.toString();
            sPropSrcDirect = MFWStringHelper.replaceAll((String)sPropSrcDirect, (String)"#PROPNAME#", (String)"directAccess");
            sPropSrcDirect = MFWStringHelper.replaceAll((String)sPropSrcDirect, (String)"#PROPVALUE#", (String)elmAccessDirectly.getTextTrim());
            custProps.append(sPropSrcDirect);
        }
        sDataSrc = MFWStringHelper.replaceAll((String)sDataSrc, (String)"#CUSTPROPERTIES#", (String)custProps.toString());
        sDataSrc = MFWStringHelper.replaceAll((String)sDataSrc, (String)"#CONNECTIONSTR#", (String)this.getPersonalDataConnectionString(nameDataSrc, isPersonalData));
        return sDataSrc;
    }

    String generateModel(MessageContext mc, Element elmCommand) {
        Element elmFirstPD = (Element)elmCommand.selectSingleNode(".//pdSpec/dataSet/name");
        String myProj = elmFirstPD == null ? "Proj" : elmFirstPD.getTextTrim();
        String sModel = gTemplateModel.toString();
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#MYPROJ#", (String)MFWStringHelper.escapeXMLChars((String)myProj));
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#ROOTNAMESPACE#", (String)this.mRootNamespaceName);
        String mRootNamespaceName_esc = this.mRootNamespaceName;
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#ROOTNAMESPACE_ESC#", (String)mRootNamespaceName_esc.replaceAll("]", "]]"));
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#LOCALE#", (String)this.mContentLocale);
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#BASEMODELPATH#", (String)XMLHelper.escapeXMLCharacters(((Element)elmCommand.selectSingleNode(".//baseModelSearchPath")).getText()));
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#PDNAMESPACES#", (String)this.mPersonalDataNamespaces.toString());
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#DATASOURCES#", (String)this.mPersonalDataSources.toString());
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#RELATIONSHIPIDS#", (String)this.mRelationshipIDs.toString());
        String mTargetSaveName_esc = MFWStringHelper.escapeXMLChars((String)this.mTargetSaveName);
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#TARGETPKGNAME#", (String)mTargetSaveName_esc);
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#TARGETPKGNAME_ESC#", (String)mTargetSaveName_esc.replaceAll("]", "]]"));
        String sUseV5 = this.isPackageConsumedByV5DataServer(mc) ? "true" : "false";
        sModel = MFWStringHelper.replaceAll((String)sModel, (String)"#USEV5DATASERVER#", (String)("<useV5DataServer>" + sUseV5 + "</useV5DataServer>"));
        return sModel;
    }

    private boolean isPackageConsumedByV5DataServer(MessageContext mc) {
        BIBusEnvelope soapEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        MFWContentHelper hlprRCI = MFWContentHelper.create((String)soapEnvelope.getPassportID(), (String)this.mContentLocale, (String)this.mContentLocale, (BIBusEnvelope)soapEnvelope);
        MFWRequestContext mfwContext = CommandAddData.MakeMFWReqContext(soapEnvelope);
        MFWContentHelper.CMObjectInfo cmObjectInfo = hlprRCI.getCMObjectProperties(this.mBaseModel, mfwContext);
        String qo = cmObjectInfo.getQueryStack();
        return "queryService".equals(qo);
    }

    final String generateScript() {
        String sScript = gTemplateScript.toString();
        sScript = MFWStringHelper.replaceAll((String)sScript, (String)"#LOCALE#", (String)this.mContentLocale);
        sScript = MFWStringHelper.replaceAll((String)sScript, (String)"#TARGETPKGPATH#", (String)MFWStringHelper.escapeXMLChars((String)this.mTargetSavePath));
        String mTargetSaveName_esc = MFWStringHelper.escapeXMLChars((String)this.mTargetSaveName);
        sScript = MFWStringHelper.replaceAll((String)sScript, (String)"#TARGETPKGNAME#", (String)mTargetSaveName_esc);
        sScript = MFWStringHelper.replaceAll((String)sScript, (String)"#TARGETPKGNAME_ESC#", (String)mTargetSaveName_esc.replaceAll("]", "]]"));
        return sScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishModel(MessageContext mc, String sModelFilePath, String sScript) {
        UpdateMetadataHandler updateHndlr = null;
        try {
            BIBusEnvelope reqEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
            RequestInvoker reqInvoker = (RequestInvoker)this.m_fixtures.get(CommandFixtures.MDPROVIDERREQUESTINVOKER);
            updateHndlr = new UpdateMetadataHandler(sModelFilePath, reqEnvelope, reqInvoker);
            updateHndlr.openCreateModel(false);
            updateHndlr.execute(sScript);
        }
        finally {
            if (updateHndlr != null) {
                updateHndlr.closeModel();
            }
            File aFile = new File(sModelFilePath);
            aFile.delete();
        }
    }

    private String writeBmeModel(MessageContext mc, String bmeModel) {
        StringBuffer bmeModelPath = new StringBuffer(PersonalDataConvertor.getPersonalDataDirectoryPath());
        bmeModelPath.append("/BME");
        UUID uuid = UUID.randomUUID();
        String sessionID = uuid.toString();
        bmeModelPath.append(Long.toString(Calendar.getInstance().getTimeInMillis()));
        sessionID = MFWStringHelper.cleanupFileName((String)sessionID);
        bmeModelPath.append(sessionID);
        bmeModelPath.append(".xml");
        try {
            FileOutputStream bmeFile = new FileOutputStream(bmeModelPath.toString());
            bmeFile.write(bmeModel.getBytes("UTF8"));
            bmeFile.flush();
            bmeFile.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        return bmeModelPath.toString();
    }

    public void deletePdSpecInSession() {
        try {
            StringBuffer searchPath = new StringBuffer("~~/output[@name='");
            searchPath.append(this.mDatasetName);
            searchPath.append("']");
            PropEnum[] propArray = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName};
            Sort[] sortOptions = new Sort[]{new Sort()};
            sortOptions[0].setOrder(OrderEnum.ascending);
            sortOptions[0].setPropName(PropEnum.defaultName);
            ContentManagerService_PortType portCM = this.getContentManagerServicePort();
            BaseClass[] results = portCM.query(new SearchPathMultipleObject(searchPath.toString()), propArray, sortOptions, new QueryOptions());
            if (results != null && results.length > 0 && results[0] instanceof Output) {
                DeleteOptions delOptions = new DeleteOptions();
                delOptions.setForce(true);
                portCM.delete(results, delOptions);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean metadataChanged() {
        this.getMetadataInfoSession();
        Iterator<ArrayList<String>> itInfo = this.mMetadataInfo.iterator();
        Iterator<ArrayList<String>> itInfoSession = this.mMetadataInfoSession.iterator();
        while (itInfo.hasNext() && itInfoSession.hasNext()) {
            ArrayList<String> row = itInfo.next();
            ArrayList<String> rowSession = itInfoSession.next();
            Iterator<String> it1 = row.iterator();
            Iterator<String> it2 = rowSession.iterator();
            int counter = 0;
            while (it1.hasNext() && it2.hasNext()) {
                String s1 = it1.next();
                String s2 = it2.next();
                if (counter != 1) {
                    if (s1 != null && !s1.equals(s2)) {
                        return true;
                    }
                } else {
                    PersonalDataConvertorHelper.DataTypeInfo typeInfo = PersonalDataConvertorHelper.getMapingInfo(s2);
                    String typename = typeInfo.getTypeName();
                    if (s1 != null && !s1.equals(typename)) {
                        return true;
                    }
                }
                ++counter;
            }
        }
        return false;
    }

    private void getMetadataInfoSession() {
        String info = this.lookupSourceInSession();
        if (info != null) {
            info = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + info;
            byte[] decodedValue = base64.decode((int)0, (String)info);
            ByteArrayInputStream stContent = new ByteArrayInputStream(info.getBytes());
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)stContent, "UTF-8");
                InputSource is = new InputSource(reader);
                is.setEncoding("UTF-8");
                SAXReader myParser = new SAXReader();
                myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
                myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                Document requestDoc = myParser.read(is);
                Element elmRoot = requestDoc.getRootElement();
                Element elmMetadata = elmRoot.element("metadata");
                List listItems = elmMetadata.elements("item");
                for (Element elmItem : listItems) {
                    String name = elmItem.attributeValue("name");
                    String type = elmItem.attributeValue("type");
                    String precision = elmItem.attributeValue("precision");
                    String scale = elmItem.attributeValue("scale");
                    ArrayList<String> metadata = new ArrayList<String>();
                    metadata.add(name);
                    metadata.add(type);
                    metadata.add(precision);
                    metadata.add(scale);
                    this.mMetadataInfoSession.add(metadata);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String lookupSourceInSession() {
        try {
            Output cmOutput;
            Base64BinaryMIMEProp mimeProp;
            StringBuffer searchPath = new StringBuffer("~~/output[@name='");
            searchPath.append(this.mDatasetName);
            searchPath.append("']");
            PropEnum[] propArray = new PropEnum[2];
            propArray[1] = PropEnum.name;
            propArray[0] = PropEnum.data;
            QueryOptions queryOpts = new QueryOptions(EncodingEnum.MIME, null, null, null, null, false, null, null);
            queryOpts.setPermission("read");
            queryOpts.setSchemaInfo(false);
            queryOpts.setDataEncoding(EncodingEnum.base64);
            BaseClass[] results = this.getContentManagerServicePort().query(new SearchPathMultipleObject(searchPath.toString()), propArray, null, queryOpts);
            if (results != null && results.length > 0 && results[0] instanceof Output && (mimeProp = (cmOutput = (Output)results[0]).getData()) != null) {
                byte[] bytes = mimeProp.getValue();
                return new String(bytes, "UTF8");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    private void updateRoutingHintCMPackage(_package tPackage, StringArrayProp packageRoutingHints) {
        try {
            _package tempCopy = new _package();
            tempCopy.setStoreID(tPackage.getStoreID());
            tempCopy.setRoutingHints(packageRoutingHints);
            tempCopy.setSearchPath(tPackage.getSearchPath());
            BaseClass[] objects = new BaseClass[]{tempCopy};
            UpdateOptions updateOptions = new UpdateOptions();
            ContentManagerService_PortType portCM = this.getContentManagerServicePort();
            portCM.update(objects, updateOptions);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        gTemplatePDNamespace = new StringBuffer("<namespace>");
        gTemplatePDNamespace.append("<name locale=\"#LOCALE#\">#PDSNAME#</name>");
        gTemplatePDNamespace.append("<property name=\"pdSpec\">#PDSPEC#</property>");
        gTemplatePDNamespace.append("#QUERYSUBJECTS##RELATIONSHIPS#</namespace>");
        gTemplateQSubj = new StringBuffer("<querySubject status=\"valid\">");
        gTemplateQSubj.append("<name locale=\"#LOCALE#\">#PDQSUBJNAME#</name>");
        gTemplateQSubj.append("<definition><dbQuery><sources><dataSourceRef>[].[dataSources].[#PDSNAME_ESC#]</dataSourceRef></sources>");
        gTemplateQSubj.append("<sql type=\"cognos\">Select <column>*</column>from<table>[#PDSNAME_ESC#].\"#PDSNAME#\"</table></sql>");
        gTemplateQSubj.append("<tableType>table</tableType>");
        gTemplateQSubj.append("</dbQuery></definition><determinants/>");
        gTemplateQSubj.append("#QUERYITEMS#</querySubject>");
        gTemplateDataSrc = new StringBuffer("<dataSource>");
        gTemplateDataSrc.append("<name>#PDSNAME#</name>");
        gTemplateDataSrc.append("#CUSTPROPERTIES#");
        gTemplateDataSrc.append("<queryProcessing>limitedLocal</queryProcessing>");
        gTemplateDataSrc.append("<cmDataSource>#PDSNAME#</cmDataSource>");
        gTemplateDataSrc.append("<type><queryType>relational</queryType><interface>XML</interface></type>");
        gTemplateDataSrc.append("<connectionString>;LOCAL;XML;validate=on;#CONNECTIONSTR#</connectionString>");
        gTemplateDataSrc.append("</dataSource>");
        gTemplateCustomProp = new StringBuffer("<property name=\"#PROPNAME#\" type=\"hidden\">#PROPVALUE#</property>");
        gTemplateModel = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        gTemplateModel.append("<project xmlns=\"http://www.developer.cognos.com/schemas/bmt/60/2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.developer.cognos.com/schemas/bmt/60/2 BMTModelSpecification.xsd\">");
        gTemplateModel.append("<name>#MYPROJ#</name>");
        gTemplateModel.append("<locales><locale>#LOCALE#</locale></locales>");
        gTemplateModel.append("<defaultLocale>#LOCALE#</defaultLocale>");
        gTemplateModel.append("<namespace>");
        gTemplateModel.append("<name locale=\"#LOCALE#\">#ROOTNAMESPACE#</name>");
        gTemplateModel.append("<property name=\"personalDataBaseModel\" type=\"hidden\">#BASEMODELPATH#</property>");
        gTemplateModel.append("<linkedNode type=\"namespace\">");
        gTemplateModel.append("<source type=\"modelFM\">");
        gTemplateModel.append("<connection name=\"cmSearchPath\" value=\"#BASEMODELPATH#\"/>");
        gTemplateModel.append("</source>");
        gTemplateModel.append("<queryPath value=\"/project/namespace[0]\"/>");
        gTemplateModel.append("</linkedNode>");
        gTemplateModel.append("#PDNAMESPACES#</namespace>");
        gTemplateModel.append("<dataSources>#DATASOURCES#</dataSources>");
        gTemplateModel.append("<parameterMaps/>");
        gTemplateModel.append("<securityViews><securityView>");
        gTemplateModel.append("<name>#TARGETPKGNAME#</name>");
        gTemplateModel.append("<definition><set includeRule=\"include\">");
        gTemplateModel.append("<refobj>[#ROOTNAMESPACE_ESC#]</refobj>#RELATIONSHIPIDS#</set></definition>");
        gTemplateModel.append("<access/></securityView></securityViews>");
        gTemplateModel.append("<packages><package><name locale=\"#LOCALE#\">#TARGETPKGNAME#</name>");
        gTemplateModel.append("<locales><locale>#LOCALE#</locale></locales>");
        gTemplateModel.append("<definition><viewref>[].[securityViews].[#TARGETPKGNAME_ESC#]</viewref></definition>");
        gTemplateModel.append("<adminAccess/>#USEV5DATASERVER#</package></packages></project>");
        gTemplateQItem = new StringBuffer("<queryItem>");
        gTemplateQItem.append("<name locale=\"#LOCALE#\">#COLNAME#</name>");
        gTemplateQItem.append("<externalName>#COLNAME#</externalName>");
        gTemplateQItem.append("<usage>#USAGE#</usage>");
        gTemplateQItem.append("<datatype>#DATATYPE#</datatype>");
        gTemplateQItem.append("<precision>#PRECISION#</precision>");
        gTemplateQItem.append("<scale>#SCALE#</scale>");
        gTemplateQItem.append("<size>#SIZE#</size>");
        gTemplateQItem.append("<nullable>true</nullable>");
        gTemplateQItem.append("<regularAggregate>#REGULARAGGREGATE#</regularAggregate>");
        gTemplateQItem.append("<semiAggregate>#SEMIAGGREGATE#</semiAggregate>");
        gTemplateQItem.append("</queryItem>");
        gTemplateQItem2 = new StringBuffer("<queryItem>");
        gTemplateQItem2.append("<name locale=\"#LOCALE#\">#COLNAME#</name>");
        gTemplateQItem2.append("<externalName>#COLNAME#</externalName>");
        gTemplateQItem2.append("<usage>#USAGE#</usage>");
        gTemplateQItem2.append("<datatype>#DATATYPE#</datatype>");
        gTemplateQItem2.append("<size>#SIZE#</size>");
        gTemplateQItem2.append("<nullable>true</nullable>");
        gTemplateQItem2.append("<regularAggregate>#REGULARAGGREGATE#</regularAggregate>");
        gTemplateQItem2.append("<semiAggregate>#SEMIAGGREGATE#</semiAggregate>");
        gTemplateQItem2.append("</queryItem>");
        gTemplateScript = new StringBuffer("<transaction saved=\"true\" seq=\"1\">");
        gTemplateScript.append("<action seq=\"1\" type=\"SetActiveLocale\">");
        gTemplateScript.append("<inputparams><param seq=\"1\" type=\"i18nstring\"><value>#LOCALE#</value></param>");
        gTemplateScript.append("</inputparams><domchanges/><result success=\"t\"><outputparams/></result></action>");
        gTemplateScript.append("<action seq=\"2\" type=\"Publish\"><inputparams>");
        gTemplateScript.append("<param seq=\"1\" type=\"handle\"><mappingpath>package</mappingpath>");
        gTemplateScript.append("<value>[].[packages].[#TARGETPKGNAME_ESC#]</value></param>");
        gTemplateScript.append("<param seq=\"2\" type=\"integer\"><value>2</value></param>");
        gTemplateScript.append("<param seq=\"3\" type=\"i18nstring\"><value>#TARGETPKGPATH#</value></param>");
        gTemplateScript.append("<param seq=\"4\" type=\"i18nstring\"><value>#TARGETPKGNAME#</value></param>");
        gTemplateScript.append("<param seq=\"5\" type=\"integer\"><value>1</value></param>");
        gTemplateScript.append("<param seq=\"6\" type=\"integer\"><value>1</value></param>");
        gTemplateScript.append("<param seq=\"7\" type=\"integer\"><value>1</value></param>");
        gTemplateScript.append("<param seq=\"8\" type=\"integer\"><value>0</value></param>");
        gTemplateScript.append("<param seq=\"9\" type=\"i18nstring\"><value></value></param>");
        gTemplateScript.append("<param seq=\"10\" type=\"integer\"><value>1</value></param>");
        gTemplateScript.append("</inputparams><domchanges/><result success=\"t\"><outputparams/></result>");
        gTemplateScript.append("</action></transaction>");
    }
}

