/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.personalData.PersonalDataGovernors;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommandGetData
extends Command {
    private CommandKey mCommandKey;

    public boolean invokeRequest(MessageContext mc) {
        this.mCommandKey = new CommandKey(mc);
        Element elmCommand = this.mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return true;
        }
        BIBusEnvelope soapRequest = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element elmModel = (Element)elmCommand.selectSingleNode("input/modelSearchPath");
        if (elmModel == null) {
            return true;
        }
        String sModelPath = elmModel.getText();
        if (sModelPath == null || sModelPath.length() == 0) {
            return true;
        }
        DocumentFactory fac = new DocumentFactory();
        Element elmResponse = fac.createElement("output");
        this.getPersonalDataSpecs(soapRequest, sModelPath, elmResponse);
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(elmResponse);
        mc.setProperty("response.envelope", (Object)soapResponse);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPersonalDataSpecs(BIBusEnvelope soapEnvelope, String modelPath, Element elmResponse) {
        Element elmPDs = elmResponse.addElement("pdCollection");
        String baseModel = modelPath;
        MFWRequestContext myReqContext = CommandGetData.MakeMFWReqContext(soapEnvelope);
        MFWMetadataSource myMDSource = MFWMetadataSource.create((String)"modelFM");
        myMDSource.addConnectionItem("cmSearchPath", (Object)modelPath);
        MFWGateway myGW = null;
        try {
            myGW = MFWGateway.open((String)"pdGet", (MFWRequestContext)myReqContext, (MFWMetadataSource)myMDSource);
            Element elmBaseModel = elmPDs.addElement("baseModelSearchPath");
            MFWQuerySpec baseQuerySpec = MFWQuerySpec.create((String)"/project/namespace[0]/property[name='personalDataBaseModel']");
            MFWNodeHandle[] hBase = myGW.query(baseQuerySpec);
            if (hBase.length > 0) {
                baseModel = myGW.getObjectPropertyValue(hBase[0], MFWModelRes.getInstance().RID__Value);
                elmBaseModel.addText(baseModel);
            }
            PersonalDataGovernors myGovernor = new PersonalDataGovernors(soapEnvelope, baseModel);
            myGovernor.addUsedValues(elmResponse);
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"/project/namespace[0]/namespace/property[name='pdSpec']");
            MFWNodeHandle[] hPDSpecs = myGW.query(aQuerySpec);
            for (int idx = 0; idx < hPDSpecs.length; ++idx) {
                String sPDSpec = myGW.getObjectPropertyValue(hPDSpecs[idx], MFWModelRes.getInstance().RID__Value);
                SAXReader saxReader = new SAXReader();
                try {
                    saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    StringReader valueReader = new StringReader(sPDSpec);
                    Document requestDoc = saxReader.read((Reader)valueReader);
                    Element elmPDSpec = requestDoc.getRootElement();
                    String sParentID = myGW.getObjectPropertyValue(hPDSpecs[idx].getParent(), MFWModelRes.getInstance().RID_ID);
                    Element elmCntID = (Element)elmPDSpec.selectSingleNode("containerID");
                    if (elmCntID == null) {
                        elmPDSpec.addElement("containerID").addText(sParentID);
                    } else {
                        elmCntID.setText(sParentID);
                    }
                    elmPDs.add(elmPDSpec);
                    continue;
                }
                catch (DocumentException e) {
                    throw new RuntimeException(e);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        finally {
            if (myGW != null) {
                myGW.close();
            }
        }
    }
}

