/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.cclcfgapi.base64;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataGovernors;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayInputStream;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public final class CommandProcessData
extends Command {
    private CommandKey mCommandKey;

    public boolean invokeRequest(MessageContext mc) {
        this.mCommandKey = new CommandKey(mc);
        Element elmCommand = this.mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return true;
        }
        this.doProcessData(mc, elmCommand, true);
        return false;
    }

    void doProcessData(MessageContext mc, Element elmCommand, boolean bSaveData) {
        String extRaw;
        String ext;
        int dotPos;
        String sourcePath;
        Element elmDataSrc = (Element)elmCommand.selectSingleNode("input/dataSet");
        if (elmDataSrc == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "input/dataSet");
        }
        Element elmContent = (Element)elmDataSrc.selectSingleNode("./content");
        if (elmContent == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "input/dataSet/content");
        }
        Element elmBaseModel = (Element)elmCommand.selectSingleNode("input/baseModelSearchPath");
        String baseModel = elmBaseModel == null ? null : elmBaseModel.getTextTrim();
        Element elmSourcePath = (Element)elmCommand.selectSingleNode("input/dataSet/sourcePath");
        String string = sourcePath = elmSourcePath == null ? null : elmSourcePath.getTextTrim();
        if (!(sourcePath == null || (dotPos = sourcePath.lastIndexOf(46)) == -1 || (ext = (extRaw = sourcePath.substring(dotPos)).toLowerCase()).equals(".csv") || ext.equals(".xml") || ext.equals(".xls") || ext.equals(".xlsx") || ext.equals(".txt"))) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_WrongFileType, "input/sourcePath");
        }
        PersonalDataGovernors myGovernor = null;
        if (baseModel != null && baseModel.length() > 0) {
            BIBusEnvelope soapRequest = (BIBusEnvelope)mc.getProperty("request.envelope");
            myGovernor = new PersonalDataGovernors(soapRequest, baseModel);
        } else {
            myGovernor = new PersonalDataGovernors();
        }
        String sEncodedContent = elmContent.getText();
        int inLength = sEncodedContent.length();
        long freeMemory = Runtime.getRuntime().freeMemory();
        if ((long)(inLength * 10) > freeMemory / 10L * 8L) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_ExceededAvailableFreeMemory);
        }
        myGovernor.enforceMaxDataFileSize(sEncodedContent.length());
        byte[] decodedValue = base64.decode((int)0, (String)sEncodedContent);
        ByteArrayInputStream stContent = new ByteArrayInputStream(decodedValue);
        PersonalDataConvertor myConvertor = PersonalDataConvertor.create(((Element)elmDataSrc.selectSingleNode("./name")).getText(), elmDataSrc.attributeValue("type"), mc, null);
        Element elmDataset = myConvertor.convert(stContent);
        myGovernor.enforceMaxDataRowCount(elmDataset);
        if (bSaveData) {
            myConvertor.save(mc);
        }
        this.prepareResponse(mc, elmCommand, myConvertor);
    }

    private void prepareResponse(MessageContext mc, Element elmCommand, PersonalDataConvertor myConvertor) {
        DocumentFactory fac = new DocumentFactory();
        Element html = fac.createElement("html");
        Element head = html.addElement("head");
        Element meta = head.addElement("meta");
        meta.addAttribute("content", "text/html; charset=UTF-8");
        meta.addAttribute("http-equiv", "Content-Type");
        Element title = head.addElement("title");
        title.addText("External data response");
        Element body = html.addElement("body");
        Element div = body.addElement("div");
        div.addAttribute("id", "pdSpec");
        Element respPDSpec = fac.createElement("pdSpec");
        Element respDS = respPDSpec.addElement("dataSet");
        Element elmDataSrc = (Element)elmCommand.selectSingleNode("input/dataSet");
        respDS.addAttribute("type", elmDataSrc.attributeValue("type"));
        respDS.add(((Element)elmDataSrc.selectSingleNode("name")).createCopy());
        respDS.add(((Element)elmDataSrc.selectSingleNode("sourcePath")).createCopy());
        myConvertor.addMetadata(mc, respPDSpec, "personalData");
        div.addText(respPDSpec.asXML());
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(html);
        mc.setProperty("response.envelope", (Object)soapResponse);
    }
}

