/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.ReportRunner;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public final class CommandProcessExtractReport
extends Command {
    private ReportRunner mReportRunner = null;

    public final boolean invokeRequest(MessageContext mc) {
        this.mCommandKey = new CommandKey(mc);
        Element elmCommand = this.mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return true;
        }
        String routingServerGroup = "";
        Element elmReport = (Element)elmCommand.selectSingleNode("input/reportSearchPath");
        if (elmReport != null) {
            String sReportPath = elmReport.getText();
            String sourcePackageSearchPath = null;
            _package sourcePackage = null;
            String regex = "package\\[@name='[^']*'\\]";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(sReportPath);
            if (m.find()) {
                sourcePackageSearchPath = sReportPath.substring(0, m.end());
            }
            if (sourcePackageSearchPath == null) {
                sourcePackageSearchPath = this.getPackagePathFromCM(sReportPath);
            }
            if (sourcePackageSearchPath != null) {
                sourcePackage = this.getPackageFromCM(sourcePackageSearchPath);
            }
            if (sourcePackage != null) {
                StringProp serverGroupProp = sourcePackage.getRoutingServerGroup();
                assert (serverGroupProp != null);
                routingServerGroup = serverGroupProp.getValue();
                if (routingServerGroup != null && routingServerGroup.length() > 0) {
                    BIBusEnvelope envelope = this.mCommandKey.getRequest();
                    envelope.setRoutingServerGroup(routingServerGroup);
                }
            }
        }
        BIBusEnvelope soapRequest = (BIBusEnvelope)mc.getProperty("request.envelope");
        this.mReportRunner = new ReportRunner(soapRequest);
        if (routingServerGroup != null && routingServerGroup.length() > 0) {
            this.mReportRunner.setRoutingServerGroup(routingServerGroup);
        }
        if (elmReport == null) {
            return true;
        }
        String sReportPath = elmReport.getText();
        if (sReportPath == null || sReportPath.length() == 0) {
            return true;
        }
        DocumentFactory fac = new DocumentFactory();
        Element elmResponse = fac.createElement("output");
        this.doProcessReport(mc, sReportPath, elmResponse);
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(elmResponse);
        mc.setProperty("response.envelope", (Object)soapResponse);
        return false;
    }

    @Override
    public boolean cancelRequest(MessageContext arg0, AsyncContext arg1) {
        this.mReportRunner.setIsCanceled(true);
        return true;
    }

    private final void doProcessReport(MessageContext mc, String sReportPath, Element elmResponse) {
        String[] outPages = this.mReportRunner.runReport(sReportPath);
        if (outPages == null || outPages.length == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_NoReportResult);
        }
        ByteArrayInputStream stContent = null;
        try {
            stContent = new ByteArrayInputStream(outPages[0].getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        int length = stContent.available();
        byte[] buff = new byte[length];
        try {
            stContent.read(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stContent.reset();
        String sBuff = new String(buff);
        if (sBuff.indexOf("C_PromptManager();") >= 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_ReportInvalidPrompt);
        }
        String repName = this.extractReportName(sReportPath);
        PersonalDataConvertor myConvertor = PersonalDataConvertor.create(repName, "XML", mc, null);
        myConvertor.convert(stContent);
        myConvertor.save(mc);
        Element elmRepExt = elmResponse.addElement("reportExtract");
        elmRepExt.addElement("reportSearchPath").addText(sReportPath);
        myConvertor.addMetadata(mc, elmRepExt, "reportSubject");
    }

    private final String extractReportName(String sReportPath) {
        int idx = sReportPath.indexOf("/report[@name='");
        if (idx != -1) {
            return sReportPath.substring(idx + 15, sReportPath.indexOf("']", idx));
        }
        idx = sReportPath.indexOf("/analysis[@name='");
        if (idx != -1) {
            return sReportPath.substring(idx + 17, sReportPath.indexOf("']", idx));
        }
        idx = sReportPath.indexOf("/query[@name='");
        if (idx == -1) {
            return sReportPath.substring(idx + 14, sReportPath.indexOf("']", idx));
        }
        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "reportSearchPath", sReportPath);
    }
}

