/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Configuration;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorCSV;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorExcel03;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorXML;
import com.cognos.metadataService.command.personalData.ReportRunner;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public abstract class PersonalDataConvertor {
    public static final String SourceTYPE_XML = "XML";
    public static final String SourceTYPE_CSV = "CSV";
    public static final String SourceTYPE_EXCEL2003 = "Excel2003";
    private static String sPersonalDataDir = null;
    protected String mPersonalDataName = null;
    protected ArrayList<ArrayList<String>> mMetadataMap = null;

    static String getPersonalDataDirectoryPath() {
        return sPersonalDataDir;
    }

    public static PersonalDataConvertor create(String dataSrcName, String dataSrcType, MessageContext mc, ArrayList<ArrayList<String>> metadataMap) {
        PersonalDataConvertor outConvertor = null;
        if (SourceTYPE_XML.equals(dataSrcType)) {
            outConvertor = new PersonalDataConvertorXML(dataSrcName, metadataMap);
        } else if (SourceTYPE_CSV.equals(dataSrcType)) {
            outConvertor = new PersonalDataConvertorCSV(dataSrcName, mc, metadataMap);
        } else if (SourceTYPE_EXCEL2003.equals(dataSrcType)) {
            outConvertor = new PersonalDataConvertorExcel03(dataSrcName, mc, metadataMap);
        }
        return outConvertor;
    }

    protected PersonalDataConvertor(String dataSrcName, ArrayList<ArrayList<String>> metadataMap) {
        this.mPersonalDataName = dataSrcName;
        this.mMetadataMap = metadataMap;
    }

    public static String getDefaultPDSType(String FileName) {
        if (FileName == null) {
            return null;
        }
        String sExtension = FileName.substring(FileName.lastIndexOf(".") + 1);
        if (sExtension.equalsIgnoreCase("csv")) {
            return SourceTYPE_CSV;
        }
        if (sExtension.equalsIgnoreCase("xls") || sExtension.equalsIgnoreCase("xlsx")) {
            return SourceTYPE_EXCEL2003;
        }
        if (sExtension.equalsIgnoreCase("xml")) {
            return SourceTYPE_XML;
        }
        return SourceTYPE_CSV;
    }

    public Element convert(InputStream isContent) {
        return this.convert(isContent, 0);
    }

    public Element convert(InputStream isContent, int lineLimit) {
        Element elmDataSource = this.convertContent(isContent, lineLimit);
        Element elmMetadata = this.getXMLMetadata();
        List lstItems = elmMetadata.elements("item");
        ArrayList<String> tempList = new ArrayList<String>(lstItems.size());
        for (int idx = 0; idx < lstItems.size(); ++idx) {
            Element elm = (Element)lstItems.get(idx);
            String qName = "";
            if (elm.attributeValue("name") != null) {
                qName = MFWCrnIDHelper.cleanIDEntry((String)elm.attributeValue("name"));
            }
            if (qName.isEmpty()) {
                if (elm.attributeValue("type") != null) {
                    String type = elm.attributeValue("type");
                    PersonalDataConvertorHelper.DataTypeInfo dataTypeInfo = PersonalDataConvertorHelper.getMapingInfo(type);
                    qName = MFWCrnIDHelper.cleanIDEntry((String)dataTypeInfo.getSimpleTypeName());
                } else {
                    qName = "Text";
                }
                elm.addAttribute("name", qName);
            }
            if (tempList.contains(qName)) {
                qName = MFWStringHelper.makeUnique((String)qName, tempList, (boolean)true);
                elm.addAttribute("name", qName);
            }
            tempList.add(qName);
        }
        return elmDataSource;
    }

    public abstract Element convertContent(InputStream var1, int var2);

    abstract String save(MessageContext var1);

    abstract Element getXMLMetadata();

    abstract Element getXMLPreviewData();

    public void addMetadata(MessageContext mc, Element elmResponse, String tagName) {
        this.addMetadata(mc, elmResponse, tagName, false, false);
    }

    public void addMetadata(MessageContext mc, Element elmResponse, String tagName, boolean includePreview, boolean favourFacts) {
        Element ePreview;
        HashMap<String, HashMap<String, String>> reportMetadata = null;
        if (tagName.equals("reportSubject")) {
            reportMetadata = this.readReportSpecification(mc);
        }
        Element elmMetadata = this.getXMLMetadata();
        String cleanedName = MFWCrnIDHelper.cleanIDEntry((String)this.mPersonalDataName);
        String qsID = MFWCrnIDHelper.addEntryToID((String)"", (String)cleanedName);
        Element elmQS = elmResponse.addElement(tagName);
        elmQS.addAttribute("name", this.mPersonalDataName);
        elmQS.addAttribute("ID", qsID);
        List lstItems = elmMetadata.elements("item");
        for (int idx = 0; idx < lstItems.size(); ++idx) {
            String aPrecision;
            Element elm = (Element)lstItems.get(idx);
            String qName = MFWCrnIDHelper.cleanIDEntry((String)elm.attributeValue("name"));
            String type = elm.attributeValue("type");
            PersonalDataConvertorHelper.DataTypeInfo dataTypeInfo = PersonalDataConvertorHelper.getMapingInfo(type);
            Element elmQItem = elmQS.addElement("item");
            elmQItem.addAttribute("name", qName);
            elmQItem.addAttribute("ID", MFWCrnIDHelper.addEntryToID((String)qsID, (String)qName));
            String typeName = dataTypeInfo.getTypeName();
            elmQItem.addAttribute("datatype", typeName);
            elmQItem.addAttribute("simpletype", dataTypeInfo.getSimpleTypeName());
            if (dataTypeInfo.getTypeCategory() == 11 || dataTypeInfo.getTypeCategory() == 4) {
                aPrecision = elm.attributeValue("length");
                if (aPrecision != null && !aPrecision.isEmpty()) {
                    elmQItem.addAttribute("precision", aPrecision);
                    int length = Integer.parseInt(aPrecision) * 2 + 2;
                    elmQItem.addAttribute("length", Integer.toString(length));
                }
            } else {
                if (dataTypeInfo.hasPrecision()) {
                    aPrecision = elm.attributeValue("precision");
                    elmQItem.addAttribute("precision", aPrecision != null && aPrecision.length() > 0 ? aPrecision : Integer.toString(dataTypeInfo.getDefaultPrecision()));
                }
                if (dataTypeInfo.hasScale()) {
                    String aScale = elm.attributeValue("scale");
                    if (aScale != null && aScale.length() > 0) {
                        int x = Integer.parseInt(aScale);
                        if (x > 7) {
                            aScale = "7";
                        }
                    } else {
                        aScale = Integer.toString(dataTypeInfo.getDefaultScale());
                    }
                    elmQItem.addAttribute("scale", aScale);
                }
                elmQItem.addAttribute("length", Integer.toString(dataTypeInfo.getDefaultSize()));
            }
            String[] outValues = PersonalDataConvertorHelper.calculateBasicUsageAggregate(dataTypeInfo, false, favourFacts);
            if (tagName.equals("reportSubject")) {
                String value;
                HashMap<String, String> props = reportMetadata.get(qName);
                if (props != null && (value = props.get("RS_dataUsage")) != null) {
                    elmQItem.addAttribute("usage", value);
                }
            } else {
                elmQItem.addAttribute("usage", outValues[0]);
            }
            elmQItem.addAttribute("regularAggregate", outValues[1]);
            elmQItem.addAttribute("semiAggregate", outValues[2]);
        }
        if (includePreview && (ePreview = this.getXMLPreviewData()) != null) {
            Element pp = DocumentHelper.createElement((String)"personalPreview");
            pp.add(this.getXMLPreviewData());
            elmResponse.add(pp);
        }
    }

    public static String persistInSession(ContentManagerService_PortType portCM, String sXMLIdentifier, String sXMLContent) {
        try {
            Output cmOutput = new Output();
            TokenProp nameToken = new TokenProp();
            nameToken.setValue(sXMLIdentifier);
            cmOutput.setDefaultName(nameToken);
            NmtokenProp frmt = new NmtokenProp();
            frmt.setValue(SourceTYPE_XML);
            cmOutput.setFormat(frmt);
            Base64BinaryMIMEProp mimeProp = new Base64BinaryMIMEProp();
            mimeProp.setValue(sXMLContent.getBytes("UTF8"));
            cmOutput.setData(mimeProp);
            AddOptions addOptions = new AddOptions();
            addOptions.setUpdateAction(UpdateActionEnum.replace);
            addOptions.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
            BaseClass[] baseClassObjects = new BaseClass[]{cmOutput};
            String actualPath = "";
            BaseClass[] addedItems = null;
            addedItems = portCM.add(new SearchPathSingleObject("~~"), baseClassObjects, addOptions);
            if (addedItems.length > 0) {
                actualPath = addedItems[0].getSearchPath().getValue();
            }
            return actualPath;
        }
        catch (Exception e) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_FailedPersistSource, e, new String[]{sXMLIdentifier});
        }
    }

    public static String getAdvancedProperty(MessageContext mc, String sPropName) {
        try {
            String sAdvancedSettings = PersonalDataConvertor.getAdvancedSettings(mc);
            if (sAdvancedSettings.length() > 0) {
                StringReader myReader = new StringReader(sAdvancedSettings);
                SAXReader myParser = new SAXReader();
                myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
                myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                Document document = myParser.read((Reader)myReader);
                String sName = "//setting[@name='" + sPropName + "']";
                Element eSetting = (Element)document.getRootElement().selectSingleNode(sName);
                if (eSetting != null) {
                    return eSetting.getText();
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getAdvancedSettings(MessageContext mc) {
        try {
            String searchPath = "/configuration";
            ContentManagerService_PortType portCM = PersonalDataConvertor.getContentManagerServicePort(mc);
            PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.advancedSettings};
            Sort[] sortBy = new Sort[]{new Sort()};
            sortBy[0].setOrder(OrderEnum.ascending);
            sortBy[0].setPropName(PropEnum.defaultName);
            QueryOptions options = new QueryOptions();
            BaseClass[] results = portCM.query(new SearchPathMultipleObject(searchPath), properties, sortBy, options);
            if (results != null && results.length > 0 && results[0] instanceof Configuration) {
                Configuration config = (Configuration)results[0];
                AnyTypeProp anyTypeProp = config.getAdvancedSettings();
                return anyTypeProp.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    protected String persistInSession(MessageContext mc, Element pdsContent) {
        try {
            return PersonalDataConvertor.persistInSession(PersonalDataConvertor.getContentManagerServicePort(mc), this.mPersonalDataName, pdsContent.asXML());
        }
        catch (ServiceException e) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_FailedPersistSource, e, new String[]{this.mPersonalDataName});
        }
    }

    static String getGateway() throws CCLConfigurationException {
        ICCLConfiguration x = CCLConfigurationFactory.getInstance();
        x.init();
        String value = x.getValue("gateway", true);
        return value;
    }

    private static ContentManagerService_PortType getContentManagerServicePort(MessageContext mc) throws ServiceException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        BiBusHeader header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)requestEnvelope);
        ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
        ContentManagerService_PortType port = null;
        port = serviceLocator.getcontentManagerService(ReportRunner.getDispatcherURL());
        ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    private HashMap<String, HashMap<String, String>> readReportSpecification(MessageContext mc) {
        HashMap<String, HashMap<String, String>> reportMetadata = new HashMap<String, HashMap<String, String>>();
        CommandKey mCommandKey = new CommandKey(mc);
        Element elmCommand = mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return reportMetadata;
        }
        Element elmReport = (Element)elmCommand.selectSingleNode("input/reportSearchPath");
        if (elmReport == null) {
            return reportMetadata;
        }
        String searchPath = elmReport.getText();
        if (searchPath == null || searchPath.length() == 0) {
            return reportMetadata;
        }
        String reportSpecification = this.getContentObjectValue(mc, searchPath, "getSpecification");
        if (reportSpecification.length() > 0) {
            String repSpec = this.normaliseXml(reportSpecification);
            SAXReader saxReader = new SAXReader();
            try {
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                StringReader valueReader = new StringReader(repSpec);
                Document requestDoc = saxReader.read((Reader)valueReader);
                List dataItems = requestDoc.selectNodes("//report/queries/query/selection/dataItem");
                if (dataItems.size() > 0) {
                    for (Element dataItem : dataItems) {
                        String dataItemName = dataItem.attributeValue("name");
                        String aggregate = dataItem.attributeValue("aggregate");
                        String rollupAggregate = dataItem.attributeValue("rollupAggregate");
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("aggregate", aggregate);
                        props.put("rollupAggregate", rollupAggregate);
                        List XMLAttributes = dataItem.selectNodes(".//XMLAttributes/XMLAttribute");
                        for (Element XMLAttribute : XMLAttributes) {
                            String RS_Name = XMLAttribute.attributeValue("name");
                            String RS_Value = XMLAttribute.attributeValue("value");
                            props.put(RS_Name, RS_Value);
                        }
                        reportMetadata.put(dataItemName, props);
                    }
                } else {
                    dataItems = requestDoc.selectNodes("//report/queries/query/selection/dataItemMeasure");
                    for (Element dataItem : dataItems) {
                        String dataItemName = dataItem.attributeValue("name");
                        HashMap<String, String> props = new HashMap<String, String>();
                        boolean usageFound = false;
                        List XMLAttributes = dataItem.selectNodes(".//XMLAttributes/XMLAttribute");
                        for (Element XMLAttribute : XMLAttributes) {
                            String RS_Name = XMLAttribute.attributeValue("name");
                            String RS_Value = XMLAttribute.attributeValue("value");
                            if (RS_Name.equals("RS_dataUsage")) {
                                usageFound = true;
                            }
                            props.put(RS_Name, RS_Value);
                        }
                        if (!usageFound) {
                            props.put("RS_dataUsage", "fact");
                        }
                        reportMetadata.put(dataItemName, props);
                    }
                }
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return reportMetadata;
    }

    private String getContentObjectValue(MessageContext mc, String searchPath, String methodName) {
        BaseClass ResCMObject;
        BaseClass myCMObject;
        String returnValue = "";
        SearchPathMultipleObject cmSearchPath = new SearchPathMultipleObject(searchPath);
        try {
            PropEnum[] properties = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.objectClass, PropEnum.hasChildren};
            myCMObject = PersonalDataConvertor.getContentManagerServicePort(mc).query(cmSearchPath, properties, new Sort[0], new QueryOptions())[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Class<?> cmObjectClass = myCMObject.getClass();
        Method[] cmObjectMethods = cmObjectClass.getMethods();
        HashMap<Method, PropEnum> objectProperties = new HashMap<Method, PropEnum>();
        for (int i = 0; i < cmObjectMethods.length; ++i) {
            String methodNameCurrent = cmObjectMethods[i].getName();
            try {
                PropEnum theProperty = PropEnum.fromString((String)this.propertyFromGetMethod(methodNameCurrent));
                objectProperties.put(cmObjectMethods[i], theProperty);
                continue;
            }
            catch (IllegalArgumentException isEx) {
                cmObjectMethods[i] = null;
            }
        }
        PropEnum[] allTheProps = new PropEnum[objectProperties.size()];
        int j = 0;
        for (int i = 0; i < cmObjectMethods.length; ++i) {
            if (cmObjectMethods[i] == null) continue;
            try {
                allTheProps[j++] = PropEnum.fromString((String)((PropEnum)objectProperties.get(cmObjectMethods[i])).getValue());
                continue;
            }
            catch (IllegalArgumentException isEx) {
                --j;
            }
        }
        try {
            SearchPathMultipleObject cmObjPath = new SearchPathMultipleObject();
            cmObjPath.set_value(myCMObject.getSearchPath().getValue());
            ResCMObject = PersonalDataConvertor.getContentManagerServicePort(mc).query(cmObjPath, allTheProps, new Sort[0], new QueryOptions())[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Method[] objectMethods = ResCMObject.getClass().getMethods();
        if (objectMethods.length <= 0) {
            return returnValue;
        }
        Method method = null;
        for (int i = 0; i < objectMethods.length; ++i) {
            if (!objectMethods[i].getName().equals(methodName)) continue;
            if (objectMethods[i].getName().indexOf("get") != 0 || objectMethods[i].getParameterTypes().length != 0) break;
            method = objectMethods[i];
            break;
        }
        Object propertyValue = null;
        if (method != null) {
            block19: {
                try {
                    propertyValue = method.invoke((Object)ResCMObject, new Object[0]);
                    if (propertyValue == null) break block19;
                    Class<?> propertyValueClass = propertyValue.getClass();
                    Method[] propertyValueMethods = propertyValueClass.getMethods();
                    for (int i = 0; i < propertyValueMethods.length; ++i) {
                        if (propertyValueMethods[i].getName().compareTo("getValue") != 0) continue;
                        propertyValue = propertyValueMethods[i].invoke(propertyValue, new Object[0]);
                        break;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (propertyValue != null) {
                returnValue = (String)propertyValue;
            }
        }
        return returnValue;
    }

    private String propertyFromGetMethod(String methodName) {
        String propertyName = null;
        if (methodName.indexOf("get") == 0) {
            propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        return propertyName;
    }

    public String normaliseXml(String message) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)message);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return "";
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        Object current = document.getRootElement();
        while (current != null) {
            if (current instanceof Element) {
                Element element = current;
                Iterator iterator = element.elementIterator();
                if (iterator.hasNext()) {
                    stack.offer(element);
                    current = iterator;
                    continue;
                }
                this.stripNamespace(element);
                current = stack.poll();
                continue;
            }
            Iterator iterator = (Iterator)current;
            if (iterator.hasNext()) {
                stack.offer(iterator);
                current = iterator.next();
                continue;
            }
            current = stack.poll();
            if (!(current instanceof Element)) continue;
            this.stripNamespace((Element)current);
            current = stack.poll();
        }
        return document.asXML();
    }

    private void stripNamespace(Element element) {
        QName name = new QName(element.getName(), Namespace.NO_NAMESPACE, element.getName());
        element.setQName(name);
        for (Object o : element.attributes()) {
            Attribute attribute = (Attribute)o;
            QName attributeName = new QName(attribute.getName(), Namespace.NO_NAMESPACE, attribute.getName());
            String attributeValue = attribute.getValue();
            element.remove(attribute);
            element.addAttribute(attributeName, attributeValue);
        }
        for (Object o : element.declaredNamespaces()) {
            Namespace namespace = (Namespace)o;
            element.remove(namespace);
        }
    }

    static {
        try {
            ICCLConfiguration icclConfig = CCLConfigurationFactory.createConfiguration();
            icclConfig.init();
            String dataDir = icclConfig.getValue("data", true);
            StringBuffer pdsDir = new StringBuffer(dataDir);
            pdsDir.append("/mdsrv/pds");
            sPersonalDataDir = icclConfig.resolveEffectivePath(pdsDir.toString());
            if (!CCLFileUtils.isDirectory((String)sPersonalDataDir)) {
                new File(sPersonalDataDir).mkdirs();
            }
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }
}

