/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.metadataService.command.personalData.CXmlType;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.util.DateFormat;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

final class PersonalDataConvertorCSV
extends PersonalDataConvertor {
    private final String TAB_PATTERN = "[^\t]*\t|[^\t]+$";
    private final String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private final String CSV_PATTERN_INTEGER = "[-+]?\\b\\d+\\b";
    private final String CSV_PATTERN_FLOAT = "((\\b[0-9]+)?\\.)?[0-9]+\\b";
    private final String CSV_PATTERN_INT_PERCENT = "[-+]?\\b\\d+%";
    private final String CSV_PATTERN_FLOAT_PERCENT = "((\\b[0-9]+)?\\.)?[0-9]+%";
    private Pattern csvRegex;
    private Pattern csvRegex_int;
    private Pattern csvRegex_float;
    private Pattern tabRegex;
    private Pattern csvRegex_int_percent;
    private Pattern csvRegex_float_percent;
    private Document mDocument = null;
    private Element mContent = null;
    private int mfileType = 0;
    private String mSeparator = ",";
    private Pattern mPattern = null;
    private Pattern mCustomRegex = null;
    private MessageContext mContext = null;
    private Locale mContentLocale = null;
    private int iTotalCol = 0;
    private ArrayList<Integer> vColumnIndexes = new ArrayList();

    PersonalDataConvertorCSV(String dataSrcName, MessageContext mc, ArrayList<ArrayList<String>> metadataMap) {
        super(dataSrcName, metadataMap);
        this.csvRegex = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");
        this.tabRegex = Pattern.compile("[^\t]*\t|[^\t]+$");
        this.csvRegex_int = Pattern.compile("[-+]?\\b\\d+\\b");
        this.csvRegex_float = Pattern.compile("((\\b[0-9]+)?\\.)?[0-9]+\\b");
        this.csvRegex_int_percent = Pattern.compile("[-+]?\\b\\d+%");
        this.csvRegex_float_percent = Pattern.compile("((\\b[0-9]+)?\\.)?[0-9]+%");
        this.mPattern = this.csvRegex;
        this.mContext = mc;
    }

    @Override
    public Element convertContent(InputStream inStream, int lineLimit) {
        if (this.mDocument == null) {
            this.mDocument = DocumentHelper.createDocument();
        } else {
            this.mDocument.clearContent();
        }
        String sDelim = PersonalDataConvertorCSV.getAdvancedProperty(this.mContext, "RSVP.CSV.DELIMITER");
        if (sDelim.length() < 1) {
            sDelim = PersonalDataConvertorCSV.getAdvancedProperty(this.mContext, "RSVP.CSV.DELIMITERS");
        }
        if (sDelim.length() > 0) {
            String sSep = sDelim;
            switch (sDelim.charAt(0)) {
                case '#': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sSep = "\\" + sDelim;
                }
            }
            String sPatt = "\"([^\"]+?)\"" + sSep + "?|([^" + sSep + "]+)" + sSep + "?|" + sSep;
            this.mCustomRegex = Pattern.compile(sPatt);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        boolean bFindFirst = false;
        boolean bChekedFileType = false;
        List<Object> rowList = new ArrayList();
        ArrayList<CXmlType> titleList = new ArrayList<CXmlType>();
        HashMap<Integer, Integer> maxLength = new HashMap<Integer, Integer>();
        ArrayList<String> columnMetadata = new ArrayList<String>();
        boolean metadataExists = false;
        if (this.mMetadataMap != null) {
            for (int k = 0; k < this.mMetadataMap.size(); ++k) {
                ArrayList mdatatypes = (ArrayList)this.mMetadataMap.get(k);
                String name = (String)mdatatypes.get(0);
                String mdatatype = (String)mdatatypes.get(1);
                columnMetadata.add(PersonalDataConvertorHelper.convertMFW2XSD(mdatatype));
            }
            metadataExists = true;
        }
        Element metadata = null;
        Element data = null;
        int lineCounter = 0;
        try {
            String sline;
            while ((sline = reader.readLine()) != null && (lineLimit == 0 || lineCounter < lineLimit)) {
                ++lineCounter;
                rowList.clear();
                if (!bChekedFileType) {
                    this.mfileType = this.checkfiletype(sline);
                    if (this.mfileType != 0) {
                        bChekedFileType = true;
                        if (this.mfileType == 2) {
                            this.mPattern = this.tabRegex;
                            this.mSeparator = "\t";
                        } else if (this.mfileType == 3) {
                            this.mPattern = this.mCustomRegex;
                            this.mSeparator = sDelim;
                        }
                    }
                }
                if (!bFindFirst) {
                    rowList = this.parse(sline, maxLength);
                    if (rowList.size() <= 0 || bFindFirst) continue;
                    this.iTotalCol = rowList.size();
                    titleList.clear();
                    for (int a = 0; a < rowList.size(); ++a) {
                        titleList.add((CXmlType)rowList.get(a));
                    }
                    if (!metadataExists) {
                        for (int c = 0; c < this.iTotalCol; ++c) {
                            String md = new String("");
                            columnMetadata.add(md);
                        }
                    }
                    bFindFirst = true;
                    continue;
                }
                rowList = this.parse(sline, maxLength);
                if (rowList.size() <= 0) continue;
                for (int i = 0; i < rowList.size(); ++i) {
                    CXmlType colInfo = (CXmlType)rowList.get(i);
                    String curType = colInfo.getType();
                    if (curType == null || metadataExists) continue;
                    String colType = (String)columnMetadata.get(i);
                    if (colType.length() == 0) {
                        columnMetadata.set(i, curType);
                        continue;
                    }
                    if (curType == colType) continue;
                    if (curType.equals("xs:string")) {
                        columnMetadata.set(i, curType);
                        continue;
                    }
                    if (!curType.equals("xs:decimal") || !colType.equals("xs:int")) continue;
                    columnMetadata.set(i, curType);
                }
                if (titleList.size() > 0) {
                    data = this.buildTitleRow(titleList, rowList, metadata);
                }
                titleList.clear();
                Element row = data.addElement("d:row");
                for (int k = 0; k < rowList.size() && k < this.iTotalCol; ++k) {
                    ((CXmlType)rowList.get(k)).Serialize(row);
                }
            }
            for (int c = 0; c < this.iTotalCol; ++c) {
                String md = (String)columnMetadata.get(c);
                if (md.length() != 0) continue;
                columnMetadata.set(c, "xs:string");
            }
            Element mdata = this.mContent.element("metadata");
            List lstItems = mdata.elements("item");
            for (int idx = 0; idx < lstItems.size(); ++idx) {
                Integer maxLen;
                Element elm = (Element)lstItems.get(idx);
                elm.addAttribute("type", (String)columnMetadata.get(idx));
                String type = elm.attributeValue("type");
                if (!"xs:string".equals(type) || (maxLen = (Integer)maxLength.get(idx)) == null) continue;
                elm.addAttribute("length", maxLen.toString());
            }
        }
        catch (IOException ex) {
            throw new CCLRuntimeException((Throwable)ex, ex.getMessage());
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, ex.getMessage());
        }
        if (lineCounter == 1) {
            data = this.buildTitleRow(titleList, rowList, metadata);
            Element row = data.addElement("d:row");
            for (int k = 0; k < this.iTotalCol; ++k) {
                row.addElement("d:value");
            }
        }
        return this.mContent;
    }

    private Element buildTitleRow(List<CXmlType> titleList, List<CXmlType> rowList, Element metadata) {
        CXmlType val = null;
        this.mContent = this.mDocument.addElement("d:dataset").addNamespace("d", "http://developer.cognos.com/schemas/xmldata/1/").addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance").addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        metadata = this.mContent.addElement("d:metadata");
        for (int k = 0; k < titleList.size(); ++k) {
            val = titleList.get(k);
            CXmlType valtemp = rowList.get(k);
            String sType = "";
            if (valtemp == null) {
                sType = val.getType();
            } else {
                String string = sType = valtemp.getType() == "" ? val.getType() : valtemp.getType();
            }
            if (sType == "xs:string") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType);
                continue;
            }
            if (sType == "xs:int") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType);
                continue;
            }
            if (sType == "xs:decimal") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("scale", "2").addAttribute("precision", "38");
                continue;
            }
            metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", "xs:string").addAttribute("length", "32");
        }
        Element data = this.mContent.addElement("d:data");
        return data;
    }

    @Override
    Element getXMLMetadata() {
        return (Element)this.mContent.selectSingleNode(".//d:metadata");
    }

    @Override
    Element getXMLPreviewData() {
        Element ePreviewData = ((Element)this.mContent.selectSingleNode(".//d:data")).createCopy();
        ePreviewData.addNamespace("xsi", this.mContent.getNamespaceForPrefix("xsi").getURI());
        return ePreviewData;
    }

    @Override
    String save(MessageContext mc) {
        return this.persistInSession(mc, this.mContent);
    }

    private List<CXmlType> parse(String line, Map<Integer, Integer> maxLength) {
        boolean bNotNull = false;
        ArrayList<CXmlType> list = new ArrayList<CXmlType>();
        Matcher m = this.mPattern.matcher(line);
        CXmlType val = null;
        int column = -1;
        while (m.find()) {
            String name = "";
            String mdatatype = "";
            String mprecision = "";
            String mscale = "";
            ++column;
            String match = m.group();
            if (match == null) break;
            if (match.endsWith(this.mSeparator) && match.length() > 0) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"") && match.length() > 1) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            if (match != null) {
                Matcher mint = this.csvRegex_int.matcher(match);
                Matcher mfloat = this.csvRegex_float.matcher(match);
                Matcher m_int_percent = this.csvRegex_int_percent.matcher(match);
                Matcher m_float_percent = this.csvRegex_float_percent.matcher(match);
                if (mint.matches() || m_int_percent.matches()) {
                    try {
                        Integer.parseInt(match);
                        val = new CXmlType("xs:int", match);
                    }
                    catch (NumberFormatException e) {
                        val = new CXmlType("xs:decimal", match);
                    }
                } else {
                    val = mfloat.matches() || m_float_percent.matches() ? new CXmlType("xs:decimal", match) : new CXmlType("xs:string", match);
                }
                Integer len = val.getValue().length();
                Integer maxVal = maxLength.get(column);
                if (maxVal == null) {
                    maxLength.put(column, len);
                } else if (maxVal < len) {
                    maxLength.put(column, len);
                }
                bNotNull = true;
            } else {
                val = new CXmlType();
            }
            list.add(val);
        }
        while (column < this.iTotalCol - 1) {
            val = new CXmlType();
            list.add(val);
            ++column;
        }
        if (!bNotNull) {
            return new ArrayList<CXmlType>();
        }
        return list;
    }

    private CXmlType convertDataTypeAndValue(String fromtype, String totype, String precision, String scale, String strCellValue) {
        if ("int64".equals(totype) || "int32".equals(totype)) {
            int aInt = Integer.parseInt(strCellValue);
            return new CXmlType("xs:int", String.format("%d", aInt));
        }
        if ("decimal".equals(totype)) {
            Double aDouble;
            if (this.mContentLocale == null) {
                BIBusEnvelope soapRequest = (BIBusEnvelope)this.mContext.getProperty("request.envelope");
                String contentLocale = soapRequest.getFormValue("contentLocale");
                contentLocale = contentLocale != null && contentLocale.length() > 2 ? contentLocale.substring(0, 2) : "en";
                this.mContentLocale = new Locale(contentLocale);
            }
            if (strCellValue.contains("%")) {
                return new CXmlType("xs:string", strCellValue);
            }
            NumberFormat format = NumberFormat.getInstance(this.mContentLocale);
            try {
                aDouble = format.parse(strCellValue).doubleValue();
            }
            catch (ParseException e) {
                return new CXmlType("xs:string", strCellValue);
            }
            return new CXmlType("xs:decimal", String.format("%f", aDouble));
        }
        if ("characterLength16".equals(totype)) {
            return new CXmlType("xs:string", strCellValue);
        }
        if ("dateTime".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)strCellValue);
            return new CXmlType("xs:dateTime", df.toString());
        }
        if ("date".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)strCellValue);
            return new CXmlType("xs:date", df.toString());
        }
        return new CXmlType("", "");
    }

    private int checkfiletype(String line) {
        Matcher mcsv = this.csvRegex.matcher(line);
        Matcher mtab = this.tabRegex.matcher(line);
        int ncsv = 0;
        int ntab = 0;
        int ncus = 0;
        while (mcsv.find()) {
            ++ncsv;
        }
        if (ncsv > 1) {
            return 1;
        }
        while (mtab.find()) {
            ++ntab;
        }
        if (ntab > 1) {
            return 2;
        }
        if (this.mCustomRegex != null) {
            Matcher csmatch = this.mCustomRegex.matcher(line);
            while (csmatch.find()) {
                ++ncus;
            }
            if (ncus > 1) {
                return 3;
            }
        }
        if (ncsv == 1) {
            return 1;
        }
        if (ntab == 1) {
            return 2;
        }
        if (ncus == 1) {
            return 3;
        }
        return 0;
    }
}

