/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.metadataService.command.personalData.CXmlType;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jd.util.DateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

final class PersonalDataConvertorExcel03
extends PersonalDataConvertor {
    private Document mDocument = null;
    private Element mContent = null;
    private Workbook mWorkbook = null;
    private MessageContext mContext = null;
    private Locale mContentLocale = null;
    private ArrayList<Integer> vColumnIndexes = null;
    private int mNumColumns = 0;

    PersonalDataConvertorExcel03(String dataSrcName, MessageContext mc, ArrayList<ArrayList<String>> metadataMap) {
        super(dataSrcName, metadataMap);
        this.mContext = mc;
    }

    @Override
    Element getXMLMetadata() {
        return (Element)this.mContent.selectSingleNode(".//d:metadata");
    }

    private void getRow(int sheetNum, int rowNum, List<CXmlType> rowList, boolean ignoreMetadata, Map<Integer, Integer> maxLength, Map<Integer, CXmlType> cellsMetadata) {
        Object obj;
        HashMap<Integer, CXmlType> mapCells = new HashMap<Integer, CXmlType>();
        rowList.clear();
        try {
            Sheet sheet = this.mWorkbook.getSheetAt(sheetNum);
            Row row = sheet.getRow(rowNum);
            if (row == null) {
                boolean lastRow;
                boolean bl = lastRow = sheet.getLastRowNum() == rowNum;
                if (!lastRow && !ignoreMetadata) {
                    for (int c = 0; c < this.mNumColumns; ++c) {
                        CXmlType val = new CXmlType("xs:unknown", "");
                        rowList.add(val);
                    }
                }
                return;
            }
            CXmlType val = null;
            short cells = row.getLastCellNum();
            if (ignoreMetadata && this.vColumnIndexes == null) {
                this.vColumnIndexes = new ArrayList(cells);
            }
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                String name = "";
                String mdatatype = "";
                String mprecision = "";
                String mscale = "";
                int cellIndex = cell.getColumnIndex();
                if (this.mMetadataMap != null) {
                    ArrayList mdatatypes;
                    int x;
                    if (ignoreMetadata) {
                        boolean bMatched = false;
                        for (x = 0; x < this.mMetadataMap.size() && !bMatched; ++x) {
                            String cellName;
                            mdatatypes = (ArrayList)this.mMetadataMap.get(x);
                            name = (String)mdatatypes.get(0);
                            if (!name.equals(cellName = MFWCrnIDHelper.cleanIDEntry((String)cell.getStringCellValue()))) continue;
                            mdatatype = (String)mdatatypes.get(1);
                            mprecision = (String)mdatatypes.get(2);
                            mscale = (String)mdatatypes.get(3);
                            this.vColumnIndexes.add(cellIndex);
                            bMatched = true;
                        }
                        if (!bMatched) {
                            continue;
                        }
                    } else {
                        boolean bMatched = false;
                        for (x = 0; x < this.vColumnIndexes.size() && !bMatched; ++x) {
                            if (cellIndex != this.vColumnIndexes.get(x)) continue;
                            mdatatypes = (ArrayList)this.mMetadataMap.get(x);
                            name = (String)mdatatypes.get(0);
                            mdatatype = (String)mdatatypes.get(1);
                            mprecision = (String)mdatatypes.get(2);
                            mscale = (String)mdatatypes.get(3);
                            bMatched = true;
                        }
                        if (!bMatched) continue;
                    }
                }
                try {
                    this.getCell(cell.getCellType(), cell, val, cellIndex, ignoreMetadata, mapCells, rowList, mdatatype, mprecision, mscale, maxLength);
                }
                catch (Exception excellType) {
                    if (ignoreMetadata) {
                        val = new CXmlType("", "");
                        rowList.add(val);
                    }
                    MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("Error calling getCell: ", excellType);
                }
            }
        }
        catch (Exception e) {
            rowList.clear();
            MDSRVLogUtil.getLogUtilInstance().unexpectedHandledException("Error calling getRow: ", e);
        }
        if (!ignoreMetadata) {
            rowList.clear();
            for (int c = 0; c < this.mNumColumns; ++c) {
                CXmlType val;
                int colIndex = this.vColumnIndexes.size() > 0 ? this.vColumnIndexes.get(c) : c;
                obj = mapCells.get(colIndex);
                if (obj != null) {
                    val = (CXmlType)obj;
                    rowList.add(val);
                    continue;
                }
                val = new CXmlType("xs:unknown", "");
                rowList.add(val);
            }
        }
        for (int c = 0; c < this.mNumColumns; ++c) {
            int colIndex = this.vColumnIndexes.size() > 0 ? this.vColumnIndexes.get(c) : c;
            obj = mapCells.get(colIndex);
            if (obj == null) continue;
            CXmlType val = (CXmlType)obj;
            cellsMetadata.put(colIndex, val);
        }
    }

    private void getCell(CellType cellType, Cell cell, CXmlType val, int cellIndex, boolean ignoreMetadata, Map<Integer, CXmlType> mapCells, List<CXmlType> rowList, String mdatatype, String mprecision, String mscale, Map<Integer, Integer> maxLength) {
        Calendar cal = Calendar.getInstance();
        DataFormat format = this.mWorkbook.createDataFormat();
        switch (cellType) {
            case ERROR: {
                break;
            }
            case BOOLEAN: {
                val = new CXmlType("xs:string", "" + cell.getRichStringCellValue());
                if (ignoreMetadata) {
                    rowList.add(val);
                    break;
                }
                mapCells.put(cellIndex, val);
                break;
            }
            case FORMULA: {
                this.getCell(cell.getCachedFormulaResultType(), cell, val, cellIndex, ignoreMetadata, mapCells, rowList, mdatatype, mprecision, mscale, maxLength);
                break;
            }
            case BLANK: {
                val = new CXmlType("xs:unknown", "");
                if (ignoreMetadata) {
                    rowList.add(val);
                    break;
                }
                mapCells.put(cellIndex, val);
                break;
            }
            case NUMERIC: {
                double d = cell.getNumericCellValue();
                short cs = cell.getCellStyle().getDataFormat();
                String strCellValue = "";
                switch (cs) {
                    case 0: {
                        long lVal = (long)d;
                        if (d == (double)lVal) {
                            int iVal = (int)d;
                            if ((long)iVal == lVal) {
                                String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:int").getTypeName();
                                if (this.mMetadataMap != null && mdatatype != oldType) {
                                    val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                                    break;
                                }
                                val = new CXmlType("xs:int", String.format("%d", iVal));
                                break;
                            }
                            String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:long").getTypeName();
                            if (this.mMetadataMap != null && mdatatype != oldType) {
                                val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                                break;
                            }
                            val = new CXmlType("xs:long", String.format("%d", lVal));
                            break;
                        }
                        String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:decimal").getTypeName();
                        if (this.mMetadataMap != null && mdatatype != oldType) {
                            int iVal = (int)d;
                            val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                            break;
                        }
                        val = new CXmlType("xs:decimal", String.format("%f", d));
                        break;
                    }
                    case 1: {
                        long lVal = (long)d;
                        int iVal = (int)d;
                        if ((long)iVal == lVal) {
                            String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:int").getTypeName();
                            if (this.mMetadataMap != null && mdatatype != oldType) {
                                val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                                break;
                            }
                            val = new CXmlType("xs:int", String.format("%d", iVal));
                            break;
                        }
                        String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:long").getTypeName();
                        if (this.mMetadataMap != null && mdatatype != oldType) {
                            val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                            break;
                        }
                        val = new CXmlType("xs:long", String.format("%d", lVal));
                        break;
                    }
                    case 2: {
                        String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:decimal").getTypeName();
                        if (this.mMetadataMap != null && mdatatype != oldType) {
                            int iVal = (int)d;
                            long lVal = (long)d;
                            val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                            break;
                        }
                        String df = format.getFormat(cs);
                        DecimalFormat theFormat = this.getNumberFormat(df);
                        val = new CXmlType("xs:decimal", theFormat.format(d));
                        break;
                    }
                    case 4: {
                        String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:decimal").getTypeName();
                        if (this.mMetadataMap != null && mdatatype != oldType) {
                            int iVal = (int)d;
                            long lVal = (long)d;
                            val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                            break;
                        }
                        String df = format.getFormat(cs);
                        df = df.substring(df.indexOf(48));
                        DecimalFormat theFormat = new DecimalFormat(df, new DecimalFormatSymbols(Locale.US));
                        val = new CXmlType("xs:decimal", theFormat.format(d));
                        break;
                    }
                    default: {
                        boolean bIsDate = false;
                        boolean bIsTime = false;
                        String df = format.getFormat(cs);
                        String sNumFormat = this.cleanFormat(df);
                        if (!DateUtil.isCellDateFormatted((Cell)cell) && this.isNumberFormat(sNumFormat)) {
                            int iVal = (int)d;
                            long lVal = (long)d;
                            DecimalFormat theFormat = this.getNumberFormat(sNumFormat);
                            if (this.isDecimalNumberFormat(sNumFormat)) {
                                String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:decimal").getTypeName();
                                if (this.mMetadataMap != null && mdatatype != oldType) {
                                    val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                                    break;
                                }
                                val = new CXmlType("xs:decimal", theFormat.format(d));
                                break;
                            }
                            String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:int").getTypeName();
                            if (this.mMetadataMap != null && mdatatype != oldType) {
                                val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                                break;
                            }
                            val = new CXmlType("xs:int", theFormat.format(d));
                            break;
                        }
                        if (df.indexOf(100) >= 0 || df.indexOf(121) >= 0) {
                            bIsDate = true;
                        }
                        if (df.indexOf(115) >= 0 || df.indexOf(104) >= 0) {
                            bIsTime = true;
                        }
                        if (bIsDate || bIsTime) {
                            cal.setTime(DateUtil.getJavaDate((double)d));
                            String sText = "";
                            String sTypeText = "xs:string";
                            if (bIsDate) {
                                sTypeText = sText = String.format("%04d-%02d-%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
                                if (bIsTime) {
                                    sText = sText + "T";
                                    sTypeText = "xs:dateTime";
                                } else {
                                    sTypeText = "xs:date";
                                }
                            }
                            if (bIsTime) {
                                sText = sText + String.format("%02d:%02d:%02d", cal.get(11), cal.get(12), cal.get(13));
                            }
                            String oldType = PersonalDataConvertorHelper.getMapingInfo(sTypeText).getTypeName();
                            if (this.mMetadataMap != null && mdatatype != oldType) {
                                val = this.convertDataTypeAndValue(oldType, mdatatype, d, 0, 0L, cs, strCellValue, mprecision, mscale);
                                break;
                            }
                            val = new CXmlType(sTypeText, sText);
                            break;
                        }
                        if (DateUtil.isCellDateFormatted((Cell)cell) && DateUtil.isValidExcelDate((double)d)) {
                            String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:date").getTypeName();
                            if (this.mMetadataMap != null && mdatatype != oldType) {
                                val = this.convertDataTypeAndValue(oldType, mdatatype, d, 0, 0L, cs, strCellValue, mprecision, mscale);
                                break;
                            }
                            cal.setTime(DateUtil.getJavaDate((double)d));
                            String cellText = String.format("%04d-%02d-%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
                            val = new CXmlType("xs:date", "" + cellText);
                            break;
                        }
                        String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:decimal").getTypeName();
                        if (this.mMetadataMap != null && mdatatype != oldType) {
                            int iVal = (int)d;
                            long lVal = (long)d;
                            val = this.convertDataTypeAndValue(oldType, mdatatype, d, iVal, lVal, cs, strCellValue, mprecision, mscale);
                            break;
                        }
                        val = new CXmlType("xs:decimal", String.format("%f", d));
                    }
                }
                if (ignoreMetadata) {
                    rowList.add(val);
                    break;
                }
                mapCells.put(cellIndex, val);
                break;
            }
            case STRING: {
                String oldType = PersonalDataConvertorHelper.getMapingInfo("xs:string").getTypeName();
                val = this.mMetadataMap != null && mdatatype != oldType && !ignoreMetadata ? this.convertDataTypeAndValue(oldType, mdatatype, "" + cell.getRichStringCellValue(), mprecision, mscale) : new CXmlType("xs:string", "" + cell.getRichStringCellValue());
                if (ignoreMetadata) {
                    rowList.add(val);
                    break;
                }
                String text = val.getValue();
                if (text.length() <= 0) break;
                mapCells.put(cellIndex, val);
                Integer len = val.getValue().length();
                Integer maxVal = maxLength.get(cellIndex);
                if (maxVal == null) {
                    maxLength.put(cellIndex, len);
                    break;
                }
                if (maxVal >= len) break;
                maxLength.put(cellIndex, len);
                break;
            }
        }
    }

    private CXmlType convertDataTypeAndValue(String fromtype, String totype, double value, int ivalue, long lvalue, short excelDataFormat, String strCellValue, String precision, String scale) {
        if ("int32".equals(totype)) {
            if ("long".equals(fromtype) || "int64".equals(fromtype)) {
                long iVal = (long)value;
                return new CXmlType("xs:long", String.format("%d", iVal));
            }
            int iVal = (int)value;
            return new CXmlType("xs:int", String.format("%d", iVal));
        }
        if ("int64".equals(totype) || "long".equals(totype)) {
            long iVal = (long)value;
            return new CXmlType("xs:long", String.format("%d", iVal));
        }
        if ("decimal".equals(totype)) {
            return new CXmlType("xs:decimal", String.format("%f", value));
        }
        if ("characterLength16".equals(totype)) {
            return new CXmlType("xs:string", Long.valueOf(lvalue).toString());
        }
        if ("dateTime".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)Double.valueOf(value).toString());
            return new CXmlType("xs:dateTime", df.toString());
        }
        if ("date".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)Double.valueOf(value).toString());
            return new CXmlType("xs:date", df.toString());
        }
        return new CXmlType("", "");
    }

    private CXmlType convertDataTypeAndValue(String fromtype, String totype, String strCellValue, String precision, String scale) {
        if ("int32".equals(totype)) {
            if ("long".equals(fromtype) || "int64".equals(fromtype)) {
                long aInt = Long.parseLong(strCellValue);
                return new CXmlType("xs:long", String.format("%d", aInt));
            }
            int aInt = Integer.parseInt(strCellValue);
            return new CXmlType("xs:int", String.format("%d", aInt));
        }
        if ("int64".equals(totype) || "long".equals(totype)) {
            long aInt = Long.parseLong(strCellValue);
            return new CXmlType("xs:long", String.format("%d", aInt));
        }
        if ("decimal".equals(totype)) {
            Double aDouble;
            if (this.mContentLocale == null) {
                BIBusEnvelope soapRequest = (BIBusEnvelope)this.mContext.getProperty("request.envelope");
                String contentLocale = soapRequest.getFormValue("contentLocale");
                contentLocale = contentLocale != null && contentLocale.length() > 2 ? contentLocale.substring(0, 2) : "en";
                this.mContentLocale = new Locale(contentLocale);
            }
            if (strCellValue.contains("%")) {
                return new CXmlType("xs:string", strCellValue);
            }
            NumberFormat format = NumberFormat.getInstance(this.mContentLocale);
            try {
                aDouble = format.parse(strCellValue).doubleValue();
            }
            catch (ParseException e) {
                return new CXmlType("xs:string", strCellValue);
            }
            return new CXmlType("xs:decimal", String.format("%f", aDouble));
        }
        if ("characterLength16".equals(totype)) {
            return new CXmlType("xs:string", strCellValue);
        }
        if ("dateTime".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)strCellValue);
            return new CXmlType("xs:dateTime", df.toString());
        }
        if ("date".equals(totype)) {
            DateFormat df = DateFormat.getFormat((String)strCellValue);
            return new CXmlType("xs:date", df.toString());
        }
        return new CXmlType("", "");
    }

    private int skipTerm(String sFormat, int iIndex, char cSearch) {
        return sFormat.indexOf(cSearch, iIndex);
    }

    private String cleanFormat(String sFormat) {
        String sTrimmed = "";
        block6: for (int i = 0; i < sFormat.length(); ++i) {
            char iCurrent = sFormat.charAt(i);
            switch (iCurrent) {
                case '[': {
                    i = this.skipTerm(sFormat, i, ']');
                    continue block6;
                }
                case '#': {
                    if (sTrimmed.length() <= 0) continue block6;
                    sTrimmed = sTrimmed + iCurrent;
                    continue block6;
                }
                case '%': 
                case '.': 
                case '0': {
                    sTrimmed = sTrimmed + iCurrent;
                    continue block6;
                }
                case ';': {
                    return sTrimmed;
                }
            }
        }
        return sTrimmed;
    }

    private boolean isNumberFormat(String sFormat) {
        if (sFormat.indexOf(48) >= 0) {
            return true;
        }
        return sFormat.indexOf(35) >= 0;
    }

    private boolean isDecimalNumberFormat(String sFormat) {
        if (sFormat.indexOf(46) >= 0) {
            return true;
        }
        return sFormat.indexOf(37) >= 0;
    }

    private DecimalFormat getNumberFormat(String sFormat) {
        String df = "0.00";
        boolean bPercentage = false;
        int numIndex = sFormat.indexOf(48);
        if (numIndex >= 0) {
            df = sFormat.substring(numIndex);
            int i = 0;
            for (i = 0; i < df.length(); ++i) {
                char tc = df.charAt(i);
                if (tc == '.' || tc == '0' || tc == '#') continue;
                if (tc != '%') break;
                bPercentage = true;
                break;
            }
            if (i > 0) {
                df = df.substring(0, i);
            }
            if (df.length() < 1) {
                df = "0.00";
            }
            if (bPercentage) {
                df = df.indexOf(46) >= 0 ? df + "00" : "0.00";
            }
        }
        DecimalFormat theFormat = new DecimalFormat(df, new DecimalFormatSymbols(Locale.US));
        return theFormat;
    }

    @Override
    public Element convertContent(InputStream inStream, int rowLimit) {
        PushbackInputStream inpbis = new PushbackInputStream(inStream);
        if (this.mDocument == null) {
            this.mDocument = DocumentHelper.createDocument();
        } else {
            this.mDocument.clearContent();
        }
        try {
            String type;
            Element elm;
            int idx;
            this.mWorkbook = WorkbookFactory.create((InputStream)inpbis);
            Sheet sheet = this.mWorkbook.getSheetAt(0);
            int iTotalPhysicalRow = sheet.getPhysicalNumberOfRows();
            int iTotalCol = 0;
            Element metadata = null;
            Element data = null;
            ArrayList<CXmlType> rowList = new ArrayList<CXmlType>();
            ArrayList<CXmlType> titleList = new ArrayList<CXmlType>();
            HashMap<Integer, Integer> maxLength = new HashMap<Integer, Integer>();
            HashMap<Integer, CXmlType> cellsMetadata = new HashMap<Integer, CXmlType>();
            HashMap<Integer, String> currentMetadata = new HashMap<Integer, String>();
            boolean ignoreMetadata = true;
            this.getRow(0, 0, rowList, ignoreMetadata, maxLength, cellsMetadata);
            if (rowList.size() > 0) {
                titleList.clear();
                for (int a = 0; a < rowList.size(); ++a) {
                    titleList.add((CXmlType)rowList.get(a));
                }
                this.mNumColumns = rowList.size();
            }
            ignoreMetadata = false;
            if (iTotalPhysicalRow == 1) {
                iTotalCol = this.buildTitleRow(titleList, rowList, metadata);
                data = this.mContent.addElement("d:data");
                Element row = data.addElement("d:row");
                for (int k = 0; k < titleList.size(); ++k) {
                    row.addElement("d:value");
                }
                titleList.clear();
            }
            int i = 0;
            int iTotalRow = sheet.getLastRowNum();
            while (i <= iTotalRow && (rowLimit == 0 || i < rowLimit)) {
                this.getRow(0, ++i, rowList, ignoreMetadata, maxLength, cellsMetadata);
                if (rowList.size() > 0) {
                    if (titleList.size() > 0) {
                        iTotalCol = this.buildTitleRow(titleList, rowList, metadata);
                        titleList.clear();
                        data = this.mContent.addElement("d:data");
                    }
                    Element row = data.addElement("d:row");
                    for (int k = 0; k < rowList.size() && k < iTotalCol; ++k) {
                        ((CXmlType)rowList.get(k)).Serialize(row);
                    }
                }
                this.gatherMetadata(cellsMetadata, currentMetadata);
            }
            metadata = this.mContent.element("metadata");
            this.fixupMetadata(currentMetadata, metadata);
            Element mdata = this.mContent.element("metadata");
            List lstItems = mdata.elements("item");
            for (idx = 0; idx < lstItems.size(); ++idx) {
                Integer maxLen;
                elm = (Element)lstItems.get(idx);
                type = elm.attributeValue("type");
                if (!"xs:string".equals(type) || (maxLen = (Integer)maxLength.get(idx)) == null) continue;
                maxLen = maxLen + 1;
                elm.addAttribute("length", maxLen.toString());
            }
            for (idx = 0; idx < lstItems.size(); ++idx) {
                elm = (Element)lstItems.get(idx);
                type = elm.attributeValue("type");
                if (!"xs:unknown".equals(type)) continue;
                elm.addAttribute("type", "xs:string");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_WrongExcelFileVersion);
        }
        catch (IOException ex) {
            String sErr = ex.getMessage();
            ex.printStackTrace();
            throw new CCLRuntimeException((Throwable)ex, sErr);
        }
        catch (Exception ex) {
            String sErr = ex.getMessage();
            if (sErr != null && sErr.indexOf("Invalid header signature; read") == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_WrongExcelFileVersion);
            }
            throw new CCLRuntimeException((Throwable)ex, ex.getMessage());
        }
        return this.mContent;
    }

    private int buildTitleRow(List<CXmlType> titleList, List<CXmlType> rowList, Element metadata) {
        int iTotalCol = 0;
        CXmlType val = null;
        this.mContent = this.mDocument.addElement("d:dataset").addNamespace("d", "http://developer.cognos.com/schemas/xmldata/1/").addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        metadata = this.mContent.addElement("d:metadata");
        for (int k = 0; k < titleList.size() && k < rowList.size(); ++k) {
            String sType;
            val = titleList.get(k);
            CXmlType valtemp = rowList.get(k);
            String string = sType = valtemp.getType() == "" ? val.getType() : valtemp.getType();
            if (sType == "xs:string") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType);
            } else if (sType == "xs:int") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("precision", "9");
            } else if (sType == "xs:long") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("precision", "19");
            } else if (sType == "xs:date") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("length", "10");
            } else if (sType == "xs:decimal") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("scale", "2").addAttribute("precision", "38");
            } else if (sType == "xs:dateTime") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType).addAttribute("length", "10");
            } else if (sType == "xs:boolean") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType);
            } else if (sType == "xs:unknown") {
                metadata.addElement("d:item").addAttribute("name", val.getValue()).addAttribute("type", sType);
            } else if (val.getValue() == "" && sType == "") break;
            ++iTotalCol;
        }
        return iTotalCol;
    }

    private void fixupMetadata(Map<Integer, String> currentMetadata, Element metadata) {
        if (metadata == null) {
            return;
        }
        if (this.mMetadataMap != null) {
            String name = "";
            String mdatatype = "";
            String mprecision = "";
            String mscale = "";
            for (int x = 0; x < this.mMetadataMap.size(); ++x) {
                Element metadataElement;
                ArrayList mdatatypes = (ArrayList)this.mMetadataMap.get(x);
                name = (String)mdatatypes.get(0);
                mdatatype = (String)mdatatypes.get(1);
                mprecision = (String)mdatatypes.get(2);
                mscale = (String)mdatatypes.get(3);
                List elements = metadata.elements("item");
                if (elements == null || elements.size() <= x || (metadataElement = (Element)elements.get(x)) == null) continue;
                String attrValue = metadataElement.attributeValue("type");
                PersonalDataConvertorHelper.DataTypeInfo dtInfo = PersonalDataConvertorHelper.getMapingInfo(attrValue);
                String mdType = dtInfo.getTypeName();
                if (mdType != null && mdatatype != null) {
                    if (mdType.equals(mdatatype)) {
                        metadataElement.addAttribute("type", attrValue);
                    } else {
                        String type = PersonalDataConvertorHelper.convertMFW2XSD(mdatatype);
                        metadataElement.addAttribute("type", type);
                    }
                }
                if ((attrValue = metadataElement.attributeValue("precision")) != null && mprecision != null) {
                    metadataElement.addAttribute("precision", mprecision);
                }
                if ((attrValue = metadataElement.attributeValue("scale")) == null || mscale == null) continue;
                metadataElement.addAttribute("scale", mscale);
            }
        } else {
            Set<Map.Entry<Integer, String>> enSet = currentMetadata.entrySet();
            for (Map.Entry<Integer, String> ent : enSet) {
                PersonalDataConvertorHelper.DataTypeInfo dataTypeInfo;
                Element metadataElement;
                Integer key = ent.getKey();
                String sType = ent.getValue();
                List elements = metadata.elements("item");
                if (elements == null || elements.size() <= key || (metadataElement = (Element)elements.get(key)) == null) continue;
                String attrValue = metadataElement.attributeValue("type");
                if (attrValue != null && sType != null) {
                    metadataElement.addAttribute("type", sType);
                }
                if ((dataTypeInfo = PersonalDataConvertorHelper.getMapingInfo(sType)).getTypeCategory() == 11 || dataTypeInfo.getTypeCategory() == 4) continue;
                if (dataTypeInfo.hasPrecision()) {
                    metadataElement.addAttribute("precision", Integer.toString(dataTypeInfo.getDefaultPrecision()));
                }
                if (!dataTypeInfo.hasScale()) continue;
                String aScale = Integer.toString(dataTypeInfo.getDefaultScale());
                metadataElement.addAttribute("scale", aScale);
            }
        }
    }

    private void gatherMetadata(Map<Integer, CXmlType> cellsMetadata, Map<Integer, String> currentMetadata) {
        Set<Map.Entry<Integer, CXmlType>> enSet = cellsMetadata.entrySet();
        for (Map.Entry<Integer, CXmlType> ent : enSet) {
            Integer key = ent.getKey();
            CXmlType value = ent.getValue();
            String sType = value.getType();
            String currentType = currentMetadata.get(key);
            if (currentType != null) {
                if ("xs:unknown".equals(currentType)) {
                    currentMetadata.put(key, sType);
                    continue;
                }
                if ("xs:int".equals(currentType)) {
                    if (!"xs:long".equals(sType) && !"xs:int64".equals(sType) && !"xs:decimal".equals(sType) && !"xs:string".equals(sType)) continue;
                    currentMetadata.put(key, sType);
                    continue;
                }
                if ("xs:long".equals(currentType) || "xs:int64".equals(currentType)) {
                    if (!"xs:decimal".equals(sType) && !"xs:string".equals(sType)) continue;
                    currentMetadata.put(key, sType);
                    continue;
                }
                if (!"xs:decimal".equals(currentType) || !"xs:string".equals(sType)) continue;
                currentMetadata.put(key, sType);
                continue;
            }
            currentMetadata.put(key, sType);
        }
    }

    @Override
    String save(MessageContext mc) {
        return this.persistInSession(mc, this.mContent);
    }

    @Override
    Element getXMLPreviewData() {
        return null;
    }
}

