/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import java.util.ArrayList;
import java.util.HashMap;

public final class PersonalDataConvertorHelper {
    public static final byte kOperandTypeUnknown = 0;
    public static final byte kOperandTypeUnsupported = 1;
    public static final byte kOperandTypeUnspecified = 2;
    public static final byte kOperandTypeBinary = 3;
    public static final byte kOperandTypeBlob = 4;
    public static final byte kOperandTypeBoolean = 5;
    public static final byte kOperandTypeDatabaseKey = 6;
    public static final byte kOperandTypeDate = 7;
    public static final byte kOperandTypeDateTime = 8;
    public static final byte kOperandTypeNull = 9;
    public static final byte kOperandTypeNumeric = 10;
    public static final byte kOperandTypeString = 11;
    public static final byte kOperandTypeTime = 12;
    public static final byte kOperandTypeTimeInterval = 13;
    public static final byte kOperandTypeTuple = 14;
    public static final byte kOperandTypeYMDInterval = 15;
    private static DataTypeInfo gType_unknown = new DataTypeInfo("unknown", 0, false, 0, false, 0, 0, "xs:unknown");
    private static DataTypeInfo gType_characterLength16 = new DataTypeInfo("characterLength16", 11, true, 255, false, 0, 512, "xs:token");
    private static DataTypeInfo gType_boolean = new DataTypeInfo("boolean", 5, false, 0, false, 0, 2, "xs:boolean");
    private static DataTypeInfo gType_decimal = new DataTypeInfo("decimal", 10, true, 38, true, 2, 19, "xs:decimal");
    private static DataTypeInfo gType_float32 = new DataTypeInfo("float32", 10, true, 38, false, 0, 4, "xs:float");
    private static DataTypeInfo gType_float64 = new DataTypeInfo("float64", 10, true, 38, false, 0, 8, "xs:double");
    private static DataTypeInfo gType_timeInterval = new DataTypeInfo("timeInterval", 13, true, 2, false, 0, 8, "xs:duration");
    private static DataTypeInfo gType_dateTime = new DataTypeInfo("dateTime", 8, true, 9, false, 0, 12, "xs:dateTime");
    private static DataTypeInfo gType_date = new DataTypeInfo("date", 7, false, 0, false, 0, 4, "xs:date");
    private static DataTypeInfo gType_time = new DataTypeInfo("time", 12, true, 9, false, 0, 12, "xs:time");
    private static DataTypeInfo gType_int16 = new DataTypeInfo("int16", 10, true, 5, true, 0, 2, "xs:byte");
    private static DataTypeInfo gType_int32 = new DataTypeInfo("int32", 10, true, 9, true, 0, 4, "xs:integer");
    private static DataTypeInfo gType_int64 = new DataTypeInfo("int64", 10, true, 19, true, 0, 8, "xs:long");
    private static DataTypeInfo gType_blob = new DataTypeInfo("blob", 4, false, 0, false, 0, 0, "xs:hexBinary");
    private static DataTypeInfo[] gMFWDataTypes = new DataTypeInfo[]{gType_unknown, gType_characterLength16, gType_boolean, gType_decimal, gType_float32, gType_float64, gType_timeInterval, gType_dateTime, gType_date, gType_time, gType_int16, gType_int32, gType_int64, gType_blob};
    private static HashMap<String, DataTypeInfo> gXSD2MFWMapping = new HashMap(50);
    private static HashMap<String, String> gPhysical2SimpleMapping = new HashMap(14);
    private static HashMap<DataTypeInfo, ArrayList<String>> gMFW2XSDMapping = new HashMap();

    public static DataTypeInfo getMapingInfo(String xsdDataType) {
        DataTypeInfo dtInfo = gXSD2MFWMapping.get(xsdDataType);
        if (dtInfo != null) {
            return dtInfo;
        }
        return gMFWDataTypes[0];
    }

    static DataTypeInfo getMFWMapingInfo(String mfwDataType) {
        for (int idx = 0; idx < gMFWDataTypes.length; ++idx) {
            if (!gMFWDataTypes[idx].mMFWType.equals(mfwDataType)) continue;
            return gMFWDataTypes[idx];
        }
        return gMFWDataTypes[0];
    }

    public static String convertMFW2XSD(String mfwDataType) {
        ArrayList<String> dtInfo = gMFW2XSDMapping.get(PersonalDataConvertorHelper.getMFWMapingInfo(mfwDataType));
        if (dtInfo != null) {
            return dtInfo.get(0);
        }
        return null;
    }

    static String[] calculateBasicUsageAggregate(DataTypeInfo typeInfo, boolean isRelated) {
        return PersonalDataConvertorHelper.calculateBasicUsageAggregate(typeInfo, isRelated, false);
    }

    static String[] calculateBasicUsageAggregate(DataTypeInfo typeInfo, boolean isRelated, boolean favourFacts) {
        String[] outValues = new String[3];
        outValues[0] = isRelated || typeInfo.getTypeCategory() == 7 || typeInfo.getTypeCategory() == 8 || typeInfo.getTypeCategory() == 12 ? "identifier" : (favourFacts && (typeInfo.getTypeCategory() == 10 || typeInfo.getTypeCategory() == 13) ? "fact" : "attribute");
        if (typeInfo.getTypeCategory() == 10 || typeInfo.getTypeCategory() == 13) {
            if ("fact".equals(outValues[0])) {
                outValues[1] = "sum";
                outValues[2] = "sum";
            } else {
                outValues[1] = "unsupported";
                outValues[2] = "unsupported";
            }
        } else {
            outValues[1] = "unsupported";
            outValues[2] = "unsupported";
        }
        return outValues;
    }

    static {
        gXSD2MFWMapping.put("xs:unknown", gType_unknown);
        gXSD2MFWMapping.put("xs:string", gType_characterLength16);
        gXSD2MFWMapping.put("xs:boolean", gType_boolean);
        gXSD2MFWMapping.put("xs:decimal", gType_decimal);
        gXSD2MFWMapping.put("xs:float", gType_float32);
        gXSD2MFWMapping.put("xs:double", gType_float64);
        gXSD2MFWMapping.put("xs:duration", gType_timeInterval);
        gXSD2MFWMapping.put("xs:dateTime", gType_dateTime);
        gXSD2MFWMapping.put("xs:time", gType_time);
        gXSD2MFWMapping.put("xs:date", gType_date);
        gXSD2MFWMapping.put("xs:gYearMonth", gType_unknown);
        gXSD2MFWMapping.put("xs:gYear", gType_unknown);
        gXSD2MFWMapping.put("xs:gMonthDay", gType_unknown);
        gXSD2MFWMapping.put("xs:gDay", gType_unknown);
        gXSD2MFWMapping.put("xs:gMonth", gType_unknown);
        gXSD2MFWMapping.put("xs:hexBinary", gType_blob);
        gXSD2MFWMapping.put("xs:base64Binary", gType_blob);
        gXSD2MFWMapping.put("xs:anyURI", gType_characterLength16);
        gXSD2MFWMapping.put("xs:QName", gType_characterLength16);
        gXSD2MFWMapping.put("xs:NOTATION", gType_characterLength16);
        gXSD2MFWMapping.put("xs:normalizedString", gType_characterLength16);
        gXSD2MFWMapping.put("xs:token", gType_characterLength16);
        gXSD2MFWMapping.put("xs:language", gType_characterLength16);
        gXSD2MFWMapping.put("xs:NMTOKEN", gType_characterLength16);
        gXSD2MFWMapping.put("xs:NMTOKENS", gType_characterLength16);
        gXSD2MFWMapping.put("xs:Name", gType_characterLength16);
        gXSD2MFWMapping.put("xs:NCName", gType_characterLength16);
        gXSD2MFWMapping.put("xs:ID", gType_characterLength16);
        gXSD2MFWMapping.put("xs:IDREF", gType_characterLength16);
        gXSD2MFWMapping.put("xs:IDREFS", gType_characterLength16);
        gXSD2MFWMapping.put("xs:ENTITY", gType_characterLength16);
        gXSD2MFWMapping.put("xs:ENTITIES", gType_characterLength16);
        gXSD2MFWMapping.put("xs:integer", gType_int32);
        gXSD2MFWMapping.put("xs:nonPositiveInteger", gType_int32);
        gXSD2MFWMapping.put("xs:negativeInteger", gType_int32);
        gXSD2MFWMapping.put("xs:long", gType_int64);
        gXSD2MFWMapping.put("xs:int", gType_int32);
        gXSD2MFWMapping.put("xs:short", gType_int16);
        gXSD2MFWMapping.put("xs:byte", gType_int16);
        gXSD2MFWMapping.put("xs:nonNegativeInteger", gType_int32);
        gXSD2MFWMapping.put("xs:unsignedLong", gType_decimal);
        gXSD2MFWMapping.put("xs:unsignedInt", gType_int64);
        gXSD2MFWMapping.put("xs:unsignedShort", gType_int32);
        gXSD2MFWMapping.put("xs:unsignedByte", gType_int16);
        gXSD2MFWMapping.put("xs:positiveInteger", gType_int64);
        ArrayList<String> aType_decimal = new ArrayList<String>();
        aType_decimal.add("xs:decimal");
        aType_decimal.add("xs:unsignedLong");
        ArrayList<String> aType_blob = new ArrayList<String>();
        aType_blob.add("xs:hexBinary");
        aType_blob.add("xs:base64Binary");
        ArrayList<String> aType_int64 = new ArrayList<String>();
        aType_int64.add("xs:long");
        aType_int64.add("xs:unsignedInt");
        aType_int64.add("xs:positiveInteger");
        ArrayList<String> aType_int32 = new ArrayList<String>();
        aType_int32.add("xs:int");
        aType_int32.add("xs:nonNegativeInteger");
        aType_int32.add("xs:unsignedShort");
        ArrayList<String> aType_int16 = new ArrayList<String>();
        aType_int16.add("xs:short");
        aType_int16.add("xs:byte");
        aType_int16.add("xs:unsignedByte");
        ArrayList<String> aType_unknown = new ArrayList<String>();
        aType_unknown.add("xs:unknown");
        ArrayList<String> aType_characterLength16 = new ArrayList<String>();
        aType_characterLength16.add("xs:string");
        ArrayList<String> aType_boolean = new ArrayList<String>();
        aType_boolean.add("xs:boolean");
        ArrayList<String> aType_float32 = new ArrayList<String>();
        aType_float32.add("xs:float");
        ArrayList<String> aType_float64 = new ArrayList<String>();
        aType_float64.add("xs:double");
        ArrayList<String> aType_timeInterval = new ArrayList<String>();
        aType_timeInterval.add("xs:duration");
        ArrayList<String> aType_dateTime = new ArrayList<String>();
        aType_dateTime.add("xs:dateTime");
        ArrayList<String> aType_time = new ArrayList<String>();
        aType_time.add("xs:time");
        ArrayList<String> aType_date = new ArrayList<String>();
        aType_date.add("xs:date");
        gPhysical2SimpleMapping.put(gType_unknown.getTypeName(), "Unknown");
        gPhysical2SimpleMapping.put(gType_characterLength16.getTypeName(), "Text");
        gPhysical2SimpleMapping.put(gType_boolean.getTypeName(), "Boolean");
        gPhysical2SimpleMapping.put(gType_decimal.getTypeName(), "Decimal");
        gPhysical2SimpleMapping.put(gType_float32.getTypeName(), "Decimal");
        gPhysical2SimpleMapping.put(gType_float64.getTypeName(), "Decimal");
        gPhysical2SimpleMapping.put(gType_timeInterval.getTypeName(), "Interval");
        gPhysical2SimpleMapping.put(gType_dateTime.getTypeName(), "DateTime");
        gPhysical2SimpleMapping.put(gType_date.getTypeName(), "Date");
        gPhysical2SimpleMapping.put(gType_time.getTypeName(), "Time");
        gPhysical2SimpleMapping.put(gType_int16.getTypeName(), "Integer");
        gPhysical2SimpleMapping.put(gType_int32.getTypeName(), "Integer");
        gPhysical2SimpleMapping.put(gType_int64.getTypeName(), "Integer");
        gPhysical2SimpleMapping.put(gType_blob.getTypeName(), "Blob");
        gMFW2XSDMapping.put(gType_unknown, aType_unknown);
        gMFW2XSDMapping.put(gType_characterLength16, aType_characterLength16);
        gMFW2XSDMapping.put(gType_boolean, aType_boolean);
        gMFW2XSDMapping.put(gType_decimal, aType_decimal);
        gMFW2XSDMapping.put(gType_float32, aType_float32);
        gMFW2XSDMapping.put(gType_float64, aType_float64);
        gMFW2XSDMapping.put(gType_timeInterval, aType_timeInterval);
        gMFW2XSDMapping.put(gType_dateTime, aType_dateTime);
        gMFW2XSDMapping.put(gType_time, aType_time);
        gMFW2XSDMapping.put(gType_date, aType_date);
        gMFW2XSDMapping.put(gType_blob, aType_blob);
        gMFW2XSDMapping.put(gType_int64, aType_int64);
        gMFW2XSDMapping.put(gType_int32, aType_int32);
        gMFW2XSDMapping.put(gType_int16, aType_int16);
    }

    public static final class DataTypeInfo {
        private String mMFWType;
        private byte mCategory;
        private boolean mHasPrecision;
        private int mPrecision;
        private boolean mHasScale;
        private int mScale;
        private int mSize;
        private String mXsdType;

        DataTypeInfo(String mfwType, byte typeCategory, boolean hasPrecision, int precision, boolean hasScale, int scale, int size, String xsdType) {
            this.mMFWType = mfwType;
            this.mCategory = typeCategory;
            this.mHasPrecision = hasPrecision;
            this.mPrecision = hasPrecision ? precision : 0;
            this.mHasScale = hasScale;
            this.mScale = hasScale ? scale : 0;
            this.mSize = size;
            this.mXsdType = xsdType;
        }

        public String getTypeName() {
            return this.mMFWType;
        }

        public String getSimpleTypeName() {
            return (String)gPhysical2SimpleMapping.get(this.mMFWType);
        }

        public byte getTypeCategory() {
            return this.mCategory;
        }

        public boolean hasPrecision() {
            return this.mHasPrecision;
        }

        public int getDefaultPrecision() {
            return this.mPrecision;
        }

        public boolean hasScale() {
            return this.mHasScale;
        }

        public int getDefaultScale() {
            return this.mScale;
        }

        public int getDefaultSize() {
            return this.mSize;
        }

        public String getXsdType() {
            return this.mXsdType;
        }
    }
}

