/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.metadataService.command.personalData.PersonalDataConvertor;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.metadataService.command.personalData.ReportRunner;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.pogo.pdk.MessageContext;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

final class PersonalDataConvertorXML
extends PersonalDataConvertor {
    Element mContent = null;

    PersonalDataConvertorXML(String dataSrcName, ArrayList<ArrayList<String>> metadataMap) {
        super(dataSrcName, metadataMap);
    }

    @Override
    public Element convertContent(InputStream isContent, int rowLimit) {
        HashMap<Integer, Integer> maxLength = new HashMap<Integer, Integer>();
        try {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            cfg.init();
            String binPath = cfg.resolveEffectivePath("xmldata.xsd");
            binPath = MFWStringHelper.replaceAll((String)binPath, (String)" ", (String)"%20");
            String xsdPath = "http://developer.cognos.com/schemas/xmldata/1/ file:///" + binPath;
            SAXReader reader = new SAXReader(true);
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)xsdPath);
            Document document = reader.read(isContent);
            this.mContent = document.getRootElement();
            if (this.mContent.element("metadata") == null || this.mContent.element("data") == null) {
                throw new DocumentException();
            }
            this.getMaxLengthPerStringColumn(this.mContent, maxLength);
            if (this.mMetadataMap != null) {
                this.updatetMetadata(this.mContent);
            }
            Element mdata = this.mContent.element("metadata");
            List lstItems = mdata.elements("item");
            for (int idx = 0; idx < lstItems.size(); ++idx) {
                Integer maxLen;
                Element elm = (Element)lstItems.get(idx);
                String type = elm.attributeValue("type");
                if (!"xs:string".equals(type) || (maxLen = (Integer)maxLength.get(idx)) == null) continue;
                elm.addAttribute("length", maxLen.toString());
            }
            ReportRunner.fixupResultMetadata(this.mContent);
        }
        catch (DocumentException e) {
            String sMsg = e.getMessage();
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_InvalidXMLDataSource, sMsg);
        }
        catch (CCLConfigurationException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        catch (Exception ex) {
            throw new CCLRuntimeException((Throwable)ex, ex.getMessage());
        }
        return this.mContent;
    }

    private void getMaxLengthPerStringColumn(Element elmResultPage, Map<Integer, Integer> maxLength) {
        List lstItems = elmResultPage.element("metadata").elements("item");
        List lstRows = elmResultPage.element("data").elements("row");
        for (int r = 0; r < lstRows.size(); ++r) {
            Element elmRow = (Element)lstRows.get(r);
            List lstValues = elmRow.elements("value");
            for (int idx = 0; idx < lstItems.size(); ++idx) {
                Element elm = (Element)lstItems.get(idx);
                String type = elm.attributeValue("type");
                if (!"xs:string".equals(type)) continue;
                Element elmValue = (Element)lstValues.get(idx);
                String value = elmValue.getText();
                Integer len = value.length();
                Integer maxVal = maxLength.get(idx);
                if (maxVal == null) {
                    maxLength.put(idx, len);
                    continue;
                }
                if (maxVal >= len) continue;
                maxLength.put(idx, len);
            }
        }
    }

    private void updatetMetadata(Element elmResultPage) {
        List lstItems = elmResultPage.element("metadata").elements("item");
        for (int i = 0; i < this.mMetadataMap.size(); ++i) {
            for (int idx = 0; idx < lstItems.size(); ++idx) {
                Attribute attr;
                ArrayList row;
                String mname;
                Element elm = (Element)lstItems.get(idx);
                String name = elm.attributeValue("name");
                if (!name.equals(mname = (String)(row = (ArrayList)this.mMetadataMap.get(i)).get(0))) continue;
                String type = elm.attributeValue("type");
                String precision = elm.attributeValue("precision");
                String scale = elm.attributeValue("scale");
                String mtype = (String)row.get(1);
                String mprecision = (String)row.get(2);
                String mscale = (String)row.get(3);
                PersonalDataConvertorHelper.DataTypeInfo dataTypeInfo = PersonalDataConvertorHelper.getMFWMapingInfo(mtype);
                String xsdType = dataTypeInfo.getXsdType();
                if (!type.equals(xsdType)) {
                    attr = elm.attribute("type");
                    attr.setValue(xsdType);
                }
                if (precision != null && mprecision != null && !precision.equals(mprecision)) {
                    attr = elm.attribute("precision");
                    attr.setValue(mprecision);
                }
                if (scale == null || mscale == null || scale.equals(mscale)) continue;
                attr = elm.attribute("scale");
                attr.setValue(mscale);
            }
        }
    }

    void open(String filePath) {
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = reader.read((Reader)new FileReader(filePath));
            this.mContent = document.getRootElement();
        }
        catch (FileNotFoundException fe) {
            throw new CCLRuntimeException((Throwable)fe, fe.getMessage());
        }
        catch (DocumentException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        catch (SAXException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    @Override
    Element getXMLMetadata() {
        return this.mContent.element("metadata");
    }

    @Override
    String save(MessageContext mc) {
        return this.persistInSession(mc, this.mContent);
    }

    @Override
    Element getXMLPreviewData() {
        return null;
    }
}

