/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.metadataService.command.personalData.CommandGetData;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Iterator;
import org.dom4j.Element;

public final class PersonalDataGovernors {
    private static final short GOVERNOR_MAX_PD_FILE_SIZE_NOT_ENTERED = -1;
    private static final short GOVERNOR_MAX_PD_ROW_COUNT_NOT_ENTERED = -1;
    private static final short GOVERNOR_DEFAULT_MAX_PD_SOURCES = 1;
    private static final short GOVERNOR_DEFAULT_MAX_PD_FILE_SIZE = -1;
    private static final short GOVERNOR_DEFAULT_MAX_PD_ROW_COUNT = -1;
    private int mMaxPDSources = 1;
    private int mMaxPDFileSize = -1;
    private int mMaxPDRowCount = -1;

    public PersonalDataGovernors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalDataGovernors(BIBusEnvelope soapEnvelope, String baseModelSearchPath) {
        MFWGateway baseModelGateway = null;
        try {
            baseModelGateway = this.openGateway(soapEnvelope, baseModelSearchPath);
            this.queryGovernors(baseModelGateway);
        }
        finally {
            if (baseModelGateway != null) {
                baseModelGateway.close();
            }
        }
    }

    public PersonalDataGovernors(MFWGateway baseModelGateway) {
        try {
            this.queryGovernors(baseModelGateway);
        }
        catch (Throwable th) {
            if (baseModelGateway != null) {
                baseModelGateway.close();
            }
            throw new RuntimeException(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalDataGovernors(String userPassport, String baseModelSearchPath) {
        MFWGateway baseModelGateway = null;
        try {
            baseModelGateway = this.openGateway(userPassport, baseModelSearchPath);
            this.queryGovernors(baseModelGateway);
        }
        finally {
            if (baseModelGateway != null) {
                baseModelGateway.close();
            }
        }
    }

    public void enforceMaxSources(int inPDSources) {
        if (inPDSources > this.mMaxPDSources) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_ExceededMaxPDSources, Integer.toString(this.mMaxPDSources));
        }
    }

    public void enforceMaxDataFileSize(int inLength) {
        if (this.mMaxPDFileSize != -1 && (double)(inLength / 1024) > (double)this.mMaxPDFileSize * 1.36) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_ExceededMaxPDFileSize, Integer.toString(this.mMaxPDFileSize));
        }
    }

    public void enforceMaxDataRowCount(Element elmDataset) {
        if (this.mMaxPDRowCount != -1) {
            int rowCount = 0;
            Element elmData = elmDataset.element("data");
            Iterator itrRow = elmData.elementIterator("row");
            while (itrRow.hasNext()) {
                itrRow.next();
                if (++rowCount <= this.mMaxPDRowCount) continue;
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_ExceededMaxPDRowCount, Integer.toString(this.mMaxPDRowCount));
            }
        }
    }

    void addUsedValues(Element elmOut) {
        Element elmGovs = elmOut.addElement("governors");
        this.addEntry(elmGovs, "maxPersonalDataSources", this.mMaxPDSources);
        this.addEntry(elmGovs, "maxPersonalDataFileSize", this.mMaxPDFileSize);
        this.addEntry(elmGovs, "maxPersonalDataRowCount", this.mMaxPDRowCount);
    }

    private void addEntry(Element elmGovs, String name, int value) {
        Element elmGov = elmGovs.addElement("governor");
        elmGov.addAttribute("name", name);
        elmGov.addText(Integer.toString(value));
    }

    private MFWGateway openGateway(BIBusEnvelope soapEnvelope, String baseModelSearchPath) {
        MFWRequestContext myReqContext = CommandGetData.MakeMFWReqContext(soapEnvelope);
        MFWMetadataSource myMDSource = MFWMetadataSource.create((String)"modelFM");
        myMDSource.addConnectionItem("cmSearchPath", (Object)baseModelSearchPath);
        MFWGateway myGW = MFWGateway.open((String)"pdGovernor", (MFWRequestContext)myReqContext, (MFWMetadataSource)myMDSource);
        return myGW;
    }

    private MFWGateway openGateway(String userPassport, String baseModelSearchPath) {
        MFWRequestContext myReqContext = MFWRequestContext.create((String)"en", (String)"en", (String)userPassport);
        CommandGetData.addNoLWM2RequestContext(myReqContext);
        MFWMetadataSource myMDSource = MFWMetadataSource.create((String)"modelFM");
        myMDSource.addConnectionItem("cmSearchPath", (Object)baseModelSearchPath);
        MFWGateway myGW = MFWGateway.open((String)"pdGovernor", (MFWRequestContext)myReqContext, (MFWMetadataSource)myMDSource);
        return myGW;
    }

    private void queryGovernors(MFWGateway baseModelGateway) {
        MFWQuerySpec qsGovernor = MFWQuerySpec.create((String)"/project/parameterMaps/parameterMap[name='_governor']");
        MFWNodeHandle[] hGovernorMaps = baseModelGateway.query(qsGovernor);
        if (hGovernorMaps == null || hGovernorMaps.length == 0) {
            return;
        }
        String outGov = this.queryGovernor(baseModelGateway, hGovernorMaps[0], "maxPersonalDataSources");
        if (outGov != null && outGov.length() > 0) {
            this.mMaxPDSources = Integer.parseInt(outGov);
        }
        if ((outGov = this.queryGovernor(baseModelGateway, hGovernorMaps[0], "maxPersonalDataFileSize")) != null && outGov.length() > 0) {
            this.mMaxPDFileSize = Integer.parseInt(outGov);
        }
        if ((outGov = this.queryGovernor(baseModelGateway, hGovernorMaps[0], "maxPersonalDataRowCount")) != null && outGov.length() > 0) {
            this.mMaxPDRowCount = Integer.parseInt(outGov);
        }
    }

    private String queryGovernor(MFWGateway aGateway, MFWNodeHandle hGovernorMap, String governorName) {
        MFWQuerySpec qsGov = MFWQuerySpec.create((String)"parameterMapEntry[key='GOV']/value".replaceFirst("GOV", governorName));
        MFWNodeHandle[] hGovernors = aGateway.queryObject(hGovernorMap, qsGov);
        if (hGovernors == null || hGovernors.length == 0) {
            return null;
        }
        return aGateway.getPropertyValue(hGovernors[0]);
    }
}

