/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLXMLUtils;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.metadataService.command.personalData.CommandGetData;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PersonalDataRelationBuilder {
    private static String[] gValidCompOr = new String[]{"eq", "ge", "gt", "le", "lt", "ne"};
    private static String[] gFMCompOr = new String[]{"=", "&gt;=", "&gt;", "&lt;=", "&lt;", "&lt;&gt;"};
    private static StringBuffer gTemplateRelation = null;
    private static ICCLConfiguration gCCLConfig = null;
    private MFWGateway mGW = null;
    private MFWRequestContext mReqContext = null;
    private MFWMetadataSource mMDSource = null;
    private StringBuffer mRelationsSpec = new StringBuffer("");
    private StringBuffer mRelationRefs = new StringBuffer("");
    private ArrayList<String> mRelatedItems = new ArrayList();
    private ArrayList<MFWNodeHandle> mQuerySubjectsWithRelationship = null;
    private MFWModelRes gRes = MFWModelRes.getInstance();
    private boolean mSilent = false;

    PersonalDataRelationBuilder(BIBusEnvelope soapRequest, String baseModelPath) {
        this.mReqContext = CommandGetData.MakeMFWReqContext(soapRequest);
        if (baseModelPath != null) {
            this.mMDSource = MFWMetadataSource.create((String)"modelFM");
            this.mMDSource.addConnectionItem("cmSearchPath", (Object)baseModelPath);
        }
    }

    PersonalDataRelationBuilder(String localeProduct, String localeContent, String userPassport, String baseModelPath) {
        this.mReqContext = MFWRequestContext.create((String)localeProduct, (String)localeContent, (String)userPassport);
        this.mMDSource = MFWMetadataSource.create((String)"modelFM");
        this.mMDSource.addConnectionItem("cmSearchPath", (Object)baseModelPath);
    }

    MFWGateway getMFWGateway() {
        if (this.mGW == null) {
            this.initialize();
        }
        return this.mGW;
    }

    final String getBaseDesignLocale(String reqContentLocale) {
        MFWNodeHandle[] hProj;
        String outValue = null;
        String mappedReqContentLocale = null;
        try {
            mappedReqContentLocale = gCCLConfig.mapContentLocale(reqContentLocale, true);
        }
        catch (CCLConfigurationException ce) {
            throw new RuntimeException(ce);
        }
        if (this.mMDSource == null) {
            return mappedReqContentLocale;
        }
        if (this.mGW == null) {
            this.initialize();
        }
        if ((hProj = this.mGW.query(MFWQuerySpec.create((String)"/project"))) == null || hProj.length == 0) {
            return reqContentLocale;
        }
        String baseDefLocale = this.mGW.getObjectPropertyValue(hProj[0], this.gRes.RID_defaultLocale);
        List baseModelLocales = this.mGW.getObjectPropertyValues(hProj[0], this.gRes.RID_locale);
        outValue = baseModelLocales != null && baseModelLocales.contains(reqContentLocale) ? reqContentLocale : (baseModelLocales != null && baseModelLocales.contains(mappedReqContentLocale) ? mappedReqContentLocale : baseDefLocale);
        if (outValue == null || outValue.length() == 0) {
            outValue = reqContentLocale;
        }
        return outValue;
    }

    void makeRelationships(String pdNamespaceID, Element pdSpec) {
        try {
            String pdQSubjID;
            this.mRelationsSpec.setLength(0);
            this.mRelationRefs.setLength(0);
            this.mRelatedItems.clear();
            if (this.mGW == null) {
                this.initialize();
            }
            if ((pdQSubjID = ((Element)pdSpec.selectSingleNode("./personalData")).attributeValue("ID")) == null || pdQSubjID.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "personalData[@ID]");
            }
            if (pdSpec.selectSingleNode("relationship") != null) {
                this.applyUserSuppliedRelationship(pdNamespaceID, pdQSubjID, pdSpec);
            }
        }
        catch (RuntimeException re) {
            this.mGW.close();
            throw re;
        }
        catch (Exception e) {
            this.mGW.close();
            throw new RuntimeException(e);
        }
    }

    void closeGateway() {
        if (this.mGW != null) {
            this.mGW.close();
        }
    }

    String getRelationshipsSpec() {
        return this.mRelationsSpec.toString();
    }

    String getRelationshipRefs() {
        return this.mRelationRefs.toString();
    }

    ArrayList<String> collectBaseModelNamespaceNames() {
        if (this.mGW == null && this.mMDSource != null) {
            this.initialize();
        }
        ArrayList<String> outNames = new ArrayList<String>(20);
        if (this.mGW != null) {
            MFWNodeHandle[] hNamespaceNames = this.mGW.query(MFWQuerySpec.create((String)"/project//namespace/name"));
            for (int idx = 0; idx < hNamespaceNames.length; ++idx) {
                outNames.add(this.mGW.getObjectPropertyValue(hNamespaceNames[idx], this.gRes.RID__Value));
            }
        }
        return outNames;
    }

    ArrayList<String> collectBaseModelDataSourceNames() {
        if (this.mGW == null && this.mMDSource != null) {
            this.initialize();
        }
        ArrayList<String> outNames = new ArrayList<String>(5);
        if (this.mGW != null) {
            MFWNodeHandle[] hDataSourceNames = this.mGW.query(MFWQuerySpec.create((String)"/project/dataSource"));
            for (int idx = 0; idx < hDataSourceNames.length; ++idx) {
                String aName = this.mGW.getObjectPropertyValue(hDataSourceNames[idx], this.gRes.RID_name);
                if (outNames.contains(aName)) continue;
                outNames.add(aName);
            }
        }
        return outNames;
    }

    void setLinkableQueryItems(Element eQuerySubject) {
        try {
            String propGenerateSQL;
            String sQuerySubjectID;
            this.mSilent = true;
            if (this.mGW == null) {
                this.initialize();
            }
            if ((sQuerySubjectID = eQuerySubject.attributeValue("_ref")) == null || sQuerySubjectID.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "querySubject");
            }
            MFWNodeHandle[] hQSAncestry = this.mGW.resolveCrnID(sQuerySubjectID);
            if (hQSAncestry.length < 1) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidID, sQuerySubjectID);
            }
            MFWNodeHandle hQSubj = hQSAncestry[hQSAncestry.length - 1];
            List lstSpecs = eQuerySubject.selectNodes(".//queryItem");
            BasedOnItem[] vBasedOnItems = new BasedOnItem[lstSpecs.size()];
            ArrayList<String> vRelTargetItems = new ArrayList<String>();
            MFWNodeHandle[] vhTargets = new MFWNodeHandle[lstSpecs.size()];
            for (int idx = 0; idx < lstSpecs.size(); ++idx) {
                Element elmQueryItem = (Element)lstSpecs.get(idx);
                String sID = elmQueryItem.attributeValue("_ref");
                vRelTargetItems.add(sID);
                MFWNodeHandle[] hAncestry = this.mGW.resolveCrnID(sID);
                if (hAncestry.length < 1) continue;
                vhTargets[idx] = hAncestry[hAncestry.length - 1];
                BasedOnItem basedOnItem = vBasedOnItems[idx] = hQSubj.getInfo().getRID() == this.gRes.RID_shortcut ? new BasedOnItem(vhTargets[idx], hQSubj) : new BasedOnItem(vhTargets[idx]);
                if (hQSubj.equals((Object)this.getParentQSubj(hAncestry, sID))) continue;
                vBasedOnItems[idx].m_bLinkable = false;
            }
            MFWNodeHandle hQS = hQSubj;
            if (hQSubj.getInfo().getRID() == this.gRes.RID_shortcut) {
                String targetID = this.mGW.getObjectPropertyValue(hQSubj, this.gRes.RID_refobj);
                hQS = this.getHandleForID(targetID);
            }
            if (!"asView".equals(propGenerateSQL = this.mGW.getObjectPropertyValue(hQS, this.gRes.RID_generateSQL))) {
                while (hQSubj != null && (hQSubj.getInfo().getRID() == this.gRes.RID_shortcut || hQSubj.getInfo().getRID() == this.gRes.RID_querySubject && this.mGW.getObjectEnumPropertyValue(hQSubj, this.gRes.RID_definitionType) == 2)) {
                    hQSubj = hQSubj.getInfo().getRID() == this.gRes.RID_shortcut ? this.UnwindShortcut(hQSubj, vhTargets, vBasedOnItems) : this.UnwindTargetItems(vRelTargetItems, vhTargets, vBasedOnItems);
                    for (int idx = 0; idx < vhTargets.length; ++idx) {
                        vhTargets[idx] = vBasedOnItems[idx].mItem;
                    }
                }
            }
            for (int i = 0; i < lstSpecs.size(); ++i) {
                Element elmQueryItem = (Element)lstSpecs.get(i);
                elmQueryItem.addAttribute("linkable", vBasedOnItems[i].m_bLinkable ? "true" : "false");
            }
        }
        catch (RuntimeException re) {
            this.mGW.close();
            throw re;
        }
        catch (Exception e) {
            this.mGW.close();
            throw new RuntimeException(e);
        }
        this.mSilent = false;
    }

    private void initialize() {
        this.mGW = MFWGateway.open((String)"pds", (MFWRequestContext)this.mReqContext, (MFWMetadataSource)this.mMDSource);
    }

    private boolean participatesInRelation(MFWNodeHandle hQSubj) {
        if (this.mQuerySubjectsWithRelationship == null) {
            this.mQuerySubjectsWithRelationship = new ArrayList(30);
            this.collectRelatedQuerysubjects();
        }
        return this.mQuerySubjectsWithRelationship.contains(hQSubj);
    }

    private void collectRelatedQuerysubjects() {
        MFWNodeHandle hRight;
        MFWNodeHandle hLeft;
        int idx;
        MFWNodeHandle[] hRels = this.mGW.query(MFWQuerySpec.create((String)"/project/namespace[0]//relationship"));
        for (idx = 0; idx < hRels.length; ++idx) {
            hLeft = this.mGW.getObjectReferencePropertyValue(hRels[idx], this.gRes.RID_leftrefobj);
            this.examineRelationEnd(hLeft, this.gRes);
            hRight = this.mGW.getObjectReferencePropertyValue(hRels[idx], this.gRes.RID_rightrefobj);
            this.examineRelationEnd(hRight, this.gRes);
        }
        hRels = this.mGW.query(MFWQuerySpec.create((String)"/project/namespace[0]//relationshipShortcut"));
        for (idx = 0; idx < hRels.length; ++idx) {
            hLeft = this.mGW.getObjectReferencePropertyValue(hRels[idx], this.gRes.RID_leftrefobj);
            this.examineRelationEnd(hLeft, this.gRes);
            hRight = this.mGW.getObjectReferencePropertyValue(hRels[idx], this.gRes.RID_rightrefobj);
            this.examineRelationEnd(hRight, this.gRes);
        }
    }

    private void examineRelationEnd(MFWNodeHandle hRelEnd, MFWModelRes gRes) {
        if (hRelEnd == null) {
            return;
        }
        short ridRelEnd = hRelEnd.getInfo().getRID();
        if (ridRelEnd == gRes.RID_querySubject || ridRelEnd == gRes.RID_shortcut) {
            this.mQuerySubjectsWithRelationship.add(hRelEnd);
        }
    }

    private void applyUserSuppliedRelationship(String pdNamespaceID, String pdQSubjID, Element pdSpec) {
        Element elmRelation = (Element)pdSpec.selectSingleNode("relationship");
        String sTarget = elmRelation.attributeValue("target");
        boolean isBaseModel = sTarget == null || !"reportExtract".equals(sTarget);
        List lsSrcItems = pdSpec.selectNodes("personalData/item");
        if (lsSrcItems.size() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "personalData/item");
        }
        ArrayList<String> vSourceItems = new ArrayList<String>();
        for (int idx = 0; idx < lsSrcItems.size(); ++idx) {
            String sHidden = ((Element)lsSrcItems.get(idx)).attributeValue("hidden");
            if (sHidden != null && sHidden.contentEquals("true")) continue;
            String sItemID = ((Element)lsSrcItems.get(idx)).attributeValue("ID");
            if (sItemID == null || sItemID.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "personalData/item/@ID");
            }
            vSourceItems.add(sItemID);
        }
        ArrayList<String> vRelTargetItems = new ArrayList<String>();
        String strExpr = this.processRelationExpression(pdNamespaceID, elmRelation, vSourceItems, vRelTargetItems);
        String sTargetID = null;
        if (isBaseModel) {
            BasedOnItem[] vRelBasedOnItems = new BasedOnItem[vRelTargetItems.size()];
            sTargetID = this.adjustTarget(pdSpec, vRelTargetItems, vRelBasedOnItems);
            strExpr = this.fixupExpression(pdNamespaceID, elmRelation, vRelTargetItems, vRelBasedOnItems);
        } else {
            sTargetID = this.processTabularExtractItems(pdSpec.element("reportExtract"), vRelTargetItems);
        }
        String relName = "RelOne";
        String aRel = gTemplateRelation.toString();
        aRel = aRel.replaceAll("#REL_NAME#", Matcher.quoteReplacement(relName));
        aRel = aRel.replaceAll("#PDS_QSUBJID#", Matcher.quoteReplacement(this.changeSinglePartID2TwoPartID(pdNamespaceID, pdQSubjID)));
        aRel = aRel.replaceAll("#RELATED_QSUBJID#", Matcher.quoteReplacement(this.changeSinglePartID2TwoPartID(pdNamespaceID, sTargetID)));
        aRel = aRel.replaceAll("#EXPRESSION#", Matcher.quoteReplacement(strExpr));
        aRel = aRel.replaceAll("#LEFT_CARD_MIN#", this.getCardinality(elmRelation.selectSingleNode("sourceCardinality/minCard")));
        aRel = aRel.replaceAll("#LEFT_CARD_MAX#", this.getCardinality(elmRelation.selectSingleNode("sourceCardinality/maxCard")));
        aRel = aRel.replaceAll("#RIGHT_CARD_MIN#", this.getCardinality(elmRelation.selectSingleNode("targetCardinality/minCard")));
        aRel = aRel.replaceAll("#RIGHT_CARD_MAX#", this.getCardinality(elmRelation.selectSingleNode("targetCardinality/maxCard")));
        aRel = aRel.replaceAll("#JOIN_FILTER_TYPE#", this.getJoinFilterType(elmRelation.selectSingleNode("joinFilterType")));
        this.mRelationsSpec.append(aRel);
        this.mRelationRefs.append("<refobj>");
        this.mRelationRefs.append(MFWCrnIDHelper.addEntryToID((String)MFWStringHelper.escapeXMLChars((String)pdNamespaceID), (String)relName));
        this.mRelationRefs.append("</refobj>");
    }

    private String adjustTarget(Element elmPDSpec, ArrayList<String> vRelTargetItems, BasedOnItem[] vRelBasedOnItems) {
        int idx;
        String outTargetID = null;
        MFWNodeHandle hTargetQSubj = null;
        MFWNodeHandle[] vhTargets = new MFWNodeHandle[vRelTargetItems.size()];
        for (idx = 0; idx < vRelTargetItems.size(); ++idx) {
            String sID = vRelTargetItems.get(idx);
            MFWNodeHandle[] hAncestry = this.mGW.resolveCrnID(sID);
            if (hAncestry.length == 0) {
                ArrayList idEntries = new ArrayList();
                MFWCrnIDHelper.parseID((String)sID, idEntries);
                if (idEntries.size() == 3) {
                    String twoPartID = MFWCrnIDHelper.addEntryToID((String)"", (String)((String)idEntries.get(1)));
                    if (this.isValidPDItem(elmPDSpec, twoPartID = MFWCrnIDHelper.addEntryToID((String)twoPartID, (String)((String)idEntries.get(2))))) {
                        String qsID = MFWCrnIDHelper.addEntryToID((String)"", (String)((String)idEntries.get(0)));
                        qsID = MFWCrnIDHelper.addEntryToID((String)qsID, (String)((String)idEntries.get(1)));
                        return qsID;
                    }
                }
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidID, sID);
            }
            if (idx == 0) {
                hTargetQSubj = this.getParentQSubj(hAncestry, sID);
            } else if (!hTargetQSubj.equals((Object)this.getParentQSubj(hAncestry, sID))) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrNoSingleParent);
            }
            vhTargets[idx] = hAncestry[hAncestry.length - 1];
        }
        if (this.isValidQSTarget(hTargetQSubj)) {
            outTargetID = this.mGW.getObjectPropertyValue(hTargetQSubj, this.gRes.RID_ID);
            for (idx = 0; idx < vhTargets.length; ++idx) {
                vRelBasedOnItems[idx] = hTargetQSubj.getInfo().getRID() == this.gRes.RID_shortcut ? new BasedOnItem(vhTargets[idx], hTargetQSubj) : new BasedOnItem(vhTargets[idx]);
            }
            return outTargetID;
        }
        while (hTargetQSubj != null && (hTargetQSubj.getInfo().getRID() == this.gRes.RID_shortcut || hTargetQSubj.getInfo().getRID() == this.gRes.RID_querySubject && this.mGW.getObjectEnumPropertyValue(hTargetQSubj, this.gRes.RID_definitionType) == 2)) {
            MFWNodeHandle mFWNodeHandle = hTargetQSubj = hTargetQSubj.getInfo().getRID() == this.gRes.RID_shortcut ? this.UnwindShortcut(hTargetQSubj, vhTargets, vRelBasedOnItems) : this.UnwindTargetItems(vRelTargetItems, vhTargets, vRelBasedOnItems);
            if (this.isValidQSTarget(hTargetQSubj)) {
                outTargetID = this.mGW.getObjectPropertyValue(hTargetQSubj, this.gRes.RID_ID);
                return outTargetID;
            }
            for (idx = 0; idx < vhTargets.length; ++idx) {
                vhTargets[idx] = vRelBasedOnItems[idx].mItem;
            }
        }
        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrFailedUnwind);
    }

    private boolean isValidQSTarget(MFWNodeHandle hQSubject) {
        if (this.participatesInRelation(hQSubject)) {
            return true;
        }
        return hQSubject.getInfo().getRID() == this.gRes.RID_querySubject && this.mGW.getObjectEnumPropertyValue(hQSubject, this.gRes.RID_definitionType) == 1;
    }

    private boolean isValidPDItem(Element elmPDSpec, String aTwoPartID) {
        Node anItem = elmPDSpec.selectSingleNode("../pdSpec/personalData/item[@ID='#XYZ#']".replace("#XYZ#", aTwoPartID));
        if (anItem == null) {
            return false;
        }
        return elmPDSpec != anItem.getParent().getParent();
    }

    private String changeTwoPartID2ThreePartID(String pdNamespaceID, String twoPartID) {
        ArrayList idEntries = new ArrayList();
        MFWCrnIDHelper.parseID((String)twoPartID, idEntries);
        if (idEntries.size() != 2 && idEntries.size() != 3) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, twoPartID, "changeTwoPartID2ThreePartID");
        }
        if (idEntries.size() == 3) {
            return MFWStringHelper.escapeXMLChars((String)twoPartID);
        }
        StringBuffer threePartID = new StringBuffer(pdNamespaceID);
        threePartID.append(".");
        threePartID.append(twoPartID);
        return MFWStringHelper.escapeXMLChars((String)threePartID.toString());
    }

    private String changeSinglePartID2TwoPartID(String pdNamespaceID, String singlePartID) {
        String eSinglePartID = MFWStringHelper.escapeXMLChars((String)singlePartID);
        ArrayList idEntries = new ArrayList();
        MFWCrnIDHelper.parseID((String)eSinglePartID, idEntries);
        if (idEntries.size() != 1 && idEntries.size() != 2) {
            throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_API_InvalidParameter, singlePartID, "changeTwoPartID2ThreePartID");
        }
        if (idEntries.size() == 2) {
            return eSinglePartID;
        }
        String sNewName = MFWStringHelper.escapeXMLChars((String)pdNamespaceID);
        sNewName = sNewName + ".";
        sNewName = sNewName + eSinglePartID;
        return sNewName;
    }

    private String fixupExpression(String pdNamespaceID, Element elmRel, ArrayList<String> vRelTargetItems, BasedOnItem[] vhBasedOnItems) {
        StringBuffer strExpr = new StringBuffer("<expression>");
        Element elmExpr = (Element)elmRel.selectSingleNode("expression");
        Iterator itrChild = elmExpr.elementIterator();
        while (itrChild.hasNext()) {
            Node aChild = (Node)itrChild.next();
            if (!"relPart".equals(aChild.getName()) && !"logicalOpr".equals(aChild.getName())) continue;
            Element elmChild = (Element)aChild;
            if ("logicalOpr".equals(aChild.getName())) {
                String logicalOpr = elmChild.getText();
                strExpr.append(logicalOpr);
                continue;
            }
            Element elmCompOpr = (Element)elmChild.selectSingleNode("compOpr");
            List lsItems = elmChild.selectNodes("itemRef");
            String sItemOne = ((Element)lsItems.get(0)).getText();
            String sItemTwo = ((Element)lsItems.get(1)).getText();
            int idx1 = vRelTargetItems.indexOf(sItemOne);
            if (idx1 != -1 && vhBasedOnItems[idx1] != null) {
                strExpr.append(vhBasedOnItems[idx1].toExpression());
            } else {
                strExpr.append("<refobj>");
                strExpr.append(this.changeTwoPartID2ThreePartID(pdNamespaceID, sItemOne));
                strExpr.append("</refobj>");
            }
            strExpr.append(this.convertCompOpr(elmCompOpr));
            int idx2 = vRelTargetItems.indexOf(sItemTwo);
            if (idx2 != -1 && vhBasedOnItems[idx2] != null) {
                strExpr.append(vhBasedOnItems[idx2].toExpression());
                continue;
            }
            strExpr.append("<refobj>");
            strExpr.append(this.changeTwoPartID2ThreePartID(pdNamespaceID, sItemTwo));
            strExpr.append("</refobj>");
        }
        strExpr.append("</expression>");
        return strExpr.toString();
    }

    private MFWNodeHandle UnwindTargetItems(ArrayList<String> vRelationItemIDs, MFWNodeHandle[] vhItems, BasedOnItem[] vhBasedOnItems) {
        MFWNodeHandle hParentQSubj = null;
        for (int idx = 0; idx < vhItems.length; ++idx) {
            BasedOnItem aBasedOn;
            String expr = this.mGW.getObjectPropertyValue(vhItems[idx], this.gRes.RID_expression);
            vhBasedOnItems[idx] = aBasedOn = this.getBasedOn(expr, vRelationItemIDs.get(idx));
            if (!aBasedOn.m_bLinkable) {
                vhBasedOnItems[idx].mItem = vhItems[idx];
                continue;
            }
            if (expr == null) continue;
            if (hParentQSubj == null) {
                hParentQSubj = aBasedOn.getParentQSubj();
                continue;
            }
            if (hParentQSubj.equals((Object)aBasedOn.getParentQSubj()) || this.mSilent) continue;
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrNoSingleParent);
        }
        return hParentQSubj;
    }

    private MFWNodeHandle UnwindShortcut(MFWNodeHandle hShortcut, MFWNodeHandle[] vhItems, BasedOnItem[] vhBasedOnItems) {
        String targetID = this.mGW.getObjectPropertyValue(hShortcut, this.gRes.RID_refobj);
        if (targetID == null || targetID.length() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "shortcut/refobj");
        }
        MFWNodeHandle hTarget = this.getHandleForID(targetID);
        for (int idx = 0; idx < vhBasedOnItems.length; ++idx) {
            if (vhBasedOnItems[idx] != null) {
                vhBasedOnItems[idx].mViaShortcut = null;
                vhBasedOnItems[idx].mItem = vhItems[idx];
                continue;
            }
            vhBasedOnItems[idx] = new BasedOnItem(vhItems[idx]);
        }
        return hTarget;
    }

    private BasedOnItem getBasedOn(String expr, String taregtID) {
        if (expr == null || expr.length() == 0) {
            if (this.mSilent) {
                BasedOnItem bonitem = new BasedOnItem();
                bonitem.m_bLinkable = true;
                return bonitem;
            }
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidID, taregtID);
        }
        try {
            StringReader myReader = new StringReader(expr);
            SAXReader myParser = new SAXReader();
            myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document myDoct = myParser.read((Reader)myReader);
            Element elmExpr = myDoct.getRootElement();
            List lsRefObjs = elmExpr.selectNodes(".//refobj");
            String sBasedOnID = null;
            String sShortcutID = null;
            if (lsRefObjs.size() == 1) {
                sBasedOnID = ((Element)lsRefObjs.get(0)).getTextTrim();
                if (sBasedOnID != null) {
                    sBasedOnID = this.xmlEncode(sBasedOnID);
                }
            } else if (lsRefObjs.size() > 1) {
                Node viaShortcut = elmExpr.selectSingleNode("./refobjViaShortcut");
                if (viaShortcut == null) {
                    if (this.mSilent) {
                        return new BasedOnItem();
                    }
                    throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrNoSingleParent);
                }
                sShortcutID = ((Element)lsRefObjs.get(0)).getTextTrim();
                sBasedOnID = ((Element)lsRefObjs.get(1)).getTextTrim();
                if (sShortcutID != null) {
                    sShortcutID = this.xmlEncode(sShortcutID);
                }
                if (sBasedOnID != null) {
                    sBasedOnID = this.xmlEncode(sBasedOnID);
                }
            } else {
                if (this.mSilent) {
                    return new BasedOnItem();
                }
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidParentType, taregtID);
            }
            if (sBasedOnID == null || sBasedOnID.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidID, taregtID);
            }
            if (sShortcutID == null) {
                return new BasedOnItem(this.getHandleForID(sBasedOnID));
            }
            return new BasedOnItem(this.getHandleForID(sBasedOnID), this.getHandleForID(sShortcutID));
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        catch (SAXException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    private MFWNodeHandle getHandleForID(String crnID) {
        MFWNodeHandle[] vhRefs = this.mGW.query(MFWQuerySpec.create((String)MFWStringHelper.replaceAll((String)"//*[ID='#CRNID#']", (String)"#CRNID#", (String)crnID)));
        if (vhRefs == null || vhRefs.length == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidID, crnID);
        }
        return vhRefs[0];
    }

    private MFWNodeHandle getParentQSubj(MFWNodeHandle[] hAncestry, String sID) {
        for (int idx = hAncestry.length - 1; idx >= 0; --idx) {
            if (hAncestry[idx].getInfo().getRID() != this.gRes.RID_querySubject) continue;
            if (idx - 1 >= 0 && hAncestry[idx - 1].getInfo().getRID() == this.gRes.RID_shortcut) {
                return hAncestry[idx - 1];
            }
            return hAncestry[idx];
        }
        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidParentType, sID);
    }

    private MFWNodeHandle getParentQSubj(MFWNodeHandle hItem) {
        for (MFWNodeHandle hParent = hItem.getParent(); hParent != null; hParent = hParent.getParent()) {
            if (hParent.getInfo().getRID() != this.gRes.RID_querySubject) continue;
            return hParent;
        }
        String sID = this.mGW.getObjectPropertyValue(hItem, this.gRes.RID_ID);
        throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidParentType, sID);
    }

    private String processTabularExtractItems(Element reportExtract, ArrayList<String> vRelTargetItems) {
        int idx;
        Element elmReportQSubj = reportExtract.element("reportSubject");
        if (elmReportQSubj == null || elmReportQSubj.getNodeType() != 1) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "pdSpec/reportExtract/reportSubject");
        }
        String sTblrExtractID = elmReportQSubj.attributeValue("ID");
        if (sTblrExtractID == null || sTblrExtractID.length() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "pdSpec/reportExtract/reportSubject/@ID");
        }
        List lsAllTblrItems = elmReportQSubj.elements("item");
        if (lsAllTblrItems.size() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "pdSpec/reportSubject/item");
        }
        ArrayList<String> vAllItems = new ArrayList<String>();
        for (idx = 0; idx < lsAllTblrItems.size(); ++idx) {
            String sItemID = ((Element)lsAllTblrItems.get(idx)).attributeValue("ID");
            if (sItemID == null || sItemID.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "reportSubject/item/@ID");
            }
            vAllItems.add(sItemID);
        }
        for (idx = 0; idx < vRelTargetItems.size(); ++idx) {
            if (vAllItems.contains(vRelTargetItems.get(idx))) continue;
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, vRelTargetItems.get(idx), "relationship/expression/relPart/itemRef");
        }
        return sTblrExtractID;
    }

    private String getCardinality(Node nodeCard) {
        if (nodeCard == null || nodeCard.getNodeType() != 1) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "relationship//[minCard or maxCard]");
        }
        String sCard = ((Element)nodeCard).getText();
        if (!("one".equals(sCard) || "zero".equals(sCard) || "many".equals(sCard))) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, sCard, "relationship//[minCard or maxCard]");
        }
        return sCard;
    }

    private String getJoinFilterType(Node nodeFilterType) {
        String sFilterType = "in";
        if (nodeFilterType != null) {
            if (nodeFilterType.getNodeType() != 1) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "relationship/joinFilterType");
            }
            sFilterType = ((Element)nodeFilterType).getText();
            if (!("in".equals(sFilterType) || "between".equals(sFilterType) || "table".equals(sFilterType) || "none".equals(sFilterType))) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, sFilterType, "relationship/joinFilterType");
            }
        }
        return sFilterType;
    }

    private String processRelationExpression(String pdNamespaceID, Element elmRel, ArrayList<String> vAllSourceItems, ArrayList<String> vRelTargetItems) {
        StringBuffer strExpr = new StringBuffer("<expression>");
        Element elmExpr = (Element)elmRel.selectSingleNode("expression");
        if (elmExpr == null) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "personalData/relationship/expression");
        }
        Iterator itrChild = elmExpr.elementIterator();
        while (itrChild.hasNext()) {
            Node aChild = (Node)itrChild.next();
            if (!"relPart".equals(aChild.getName()) && !"logicalOpr".equals(aChild.getName())) continue;
            Element elmChild = (Element)aChild;
            if ("logicalOpr".equals(aChild.getName())) {
                String logicalOpr = elmChild.getText();
                if (logicalOpr == null || !"and".equals(logicalOpr) && !"or".equals(logicalOpr)) {
                    throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, "relationship/expression/logicalOpr");
                }
                strExpr.append(logicalOpr);
                continue;
            }
            Element elmCompOpr = (Element)elmChild.selectSingleNode("compOpr");
            List lsItems = elmChild.selectNodes("itemRef");
            if (lsItems == null || lsItems.size() != 2) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "relationship/expression/relPart/itemRef");
            }
            String sItemOne = ((Element)lsItems.get(0)).getText();
            String sItemTwo = ((Element)lsItems.get(1)).getText();
            if (sItemOne == null || sItemOne.length() == 0 || sItemTwo == null || sItemTwo.length() == 0) {
                throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "relationship/expression/relPart/itemRef");
            }
            if (vAllSourceItems.contains(sItemOne)) {
                this.mRelatedItems.add(sItemOne);
            } else {
                vRelTargetItems.add(sItemOne);
            }
            if (vAllSourceItems.contains(sItemTwo)) {
                this.mRelatedItems.add(sItemTwo);
            } else {
                vRelTargetItems.add(sItemTwo);
            }
            strExpr.append("<refobj>");
            strExpr.append(this.changeTwoPartID2ThreePartID(pdNamespaceID, sItemOne));
            strExpr.append("</refobj>");
            strExpr.append(this.convertCompOpr(elmCompOpr));
            strExpr.append("<refobj>");
            strExpr.append(this.changeTwoPartID2ThreePartID(pdNamespaceID, sItemTwo));
            strExpr.append("</refobj>");
        }
        strExpr.append("</expression>");
        return strExpr.toString();
    }

    private String convertCompOpr(Element elmCompOr) {
        if (elmCompOr == null || elmCompOr.getText() == null || elmCompOr.getText().length() == 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_MissingParameter, "relationship/expression/relPart/compOpr");
        }
        String compOpr = elmCompOr.getText();
        int idx = Arrays.binarySearch(gValidCompOr, compOpr);
        if (idx < 0) {
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_API_InvalidParameter, compOpr, "relationship/expression/relPart/compOpr");
        }
        return gFMCompOr[idx];
    }

    boolean isRelated(String pdsItemName) {
        return this.mRelatedItems.contains(pdsItemName);
    }

    private String xmlEncode(String toEncode) {
        StringBuffer buf = new StringBuffer();
        CCLXMLUtils.attributeEncode((String)toEncode, (StringBuffer)buf);
        return buf.toString();
    }

    static {
        gTemplateRelation = new StringBuffer("<relationship status=\"valid\">");
        gTemplateRelation.append("<name>#REL_NAME#</name>");
        gTemplateRelation.append("#EXPRESSION#");
        gTemplateRelation.append("<left><refobj>#PDS_QSUBJID#</refobj><mincard>#LEFT_CARD_MIN#</mincard><maxcard>#LEFT_CARD_MAX#</maxcard></left>");
        gTemplateRelation.append("<right><refobj>#RELATED_QSUBJID#</refobj><mincard>#RIGHT_CARD_MIN#</mincard><maxcard>#RIGHT_CARD_MAX#</maxcard></right>");
        gTemplateRelation.append("<joinFilterType>#JOIN_FILTER_TYPE#</joinFilterType>");
        gTemplateRelation.append("</relationship>");
        try {
            gCCLConfig = CCLConfigurationFactory.createConfiguration();
            gCCLConfig.init();
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private final class BasedOnItem {
        MFWNodeHandle mItem = null;
        MFWNodeHandle mViaShortcut = null;
        boolean m_bLinkable = true;

        BasedOnItem(MFWNodeHandle hItem) {
            this.mItem = hItem;
            this.mViaShortcut = null;
        }

        BasedOnItem(MFWNodeHandle hItem, MFWNodeHandle hShortcut) {
            this.mItem = hItem;
            this.mViaShortcut = hShortcut;
        }

        BasedOnItem() {
            this.m_bLinkable = false;
        }

        final MFWNodeHandle getParentQSubj() {
            if (this.mViaShortcut != null && "querySubject".equals(PersonalDataRelationBuilder.this.mGW.getObjectPropertyValue(this.mViaShortcut, ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_targetType))) {
                return this.mViaShortcut;
            }
            for (MFWNodeHandle hParent = this.mItem.getParent(); hParent != null; hParent = hParent.getParent()) {
                if (hParent.getInfo().getRID() != ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_querySubject) continue;
                return hParent;
            }
            String sID = PersonalDataRelationBuilder.this.mGW.getObjectPropertyValue(this.mItem, ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_ID);
            throw new MDSRVException(MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_PD_RelErrInvalidParentType, sID);
        }

        final String toExpression() {
            StringBuffer outExpr = new StringBuffer();
            if (this.mViaShortcut != null) {
                outExpr.append("<refobjViaShortcut><refobj>");
                outExpr.append(MFWStringHelper.escapeXMLChars((String)PersonalDataRelationBuilder.this.mGW.getObjectPropertyValue(this.mViaShortcut, ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_ID)));
                outExpr.append("</refobj><refobj>");
                outExpr.append(MFWStringHelper.escapeXMLChars((String)PersonalDataRelationBuilder.this.mGW.getObjectPropertyValue(this.mItem, ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_ID)));
                outExpr.append("</refobj></refobjViaShortcut>");
            } else {
                outExpr.append("<refobj>");
                outExpr.append(MFWStringHelper.escapeXMLChars((String)PersonalDataRelationBuilder.this.mGW.getObjectPropertyValue(this.mItem, ((PersonalDataRelationBuilder)PersonalDataRelationBuilder.this).gRes.RID_ID)));
                outExpr.append("</refobj>");
            }
            return outExpr.toString();
        }
    }
}

