/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionBoolean;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.ReportService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.metadataService.command.personalData.PersonalDataConvertorHelper;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVException;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;

public final class ReportRunner {
    private static URL gDispatcherURL = null;
    private String routingServerGroup = "";
    private boolean mIsCanceled = false;
    private BIBusEnvelope mReqEnvelope = null;
    private String mCAMPassport = null;
    private String mContentLocale = null;

    static URL getDispatcherURL() {
        try {
            ICCLConfiguration x = CCLConfigurationFactory.getInstance();
            x.init();
            String value = x.getValue("internalDispatcher", false);
            gDispatcherURL = new URL(value);
            return gDispatcherURL;
        }
        catch (CCLConfigurationException ce) {
            throw new RuntimeException(ce.getMessage(), ce);
        }
        catch (MalformedURLException me) {
            throw new RuntimeException(me.getMessage(), me);
        }
    }

    public static void fixupResultMetadata(Element elmResultPage) {
        List lstItems = elmResultPage.element("metadata").elements("item");
        for (int idx = 0; idx < lstItems.size(); ++idx) {
            Element elm = (Element)lstItems.get(idx);
            String sLen = elm.attributeValue("length");
            if (sLen == null || sLen.length() <= 0 || Integer.parseInt(sLen) > 0) continue;
            PersonalDataConvertorHelper.DataTypeInfo infoMapping = PersonalDataConvertorHelper.getMapingInfo(elm.attributeValue("type"));
            elm.addAttribute("length", Integer.toString(infoMapping.getDefaultPrecision()));
        }
    }

    public ReportRunner(BIBusEnvelope reqEnvelope) {
        this.mReqEnvelope = reqEnvelope;
        this.mCAMPassport = null;
    }

    public ReportRunner(String camPassport, String contentLocale) {
        this.mReqEnvelope = null;
        this.mCAMPassport = camPassport;
        this.mContentLocale = contentLocale;
    }

    public final void setIsCanceled(boolean isCanceled) {
        this.mIsCanceled = isCanceled;
    }

    public void setRoutingServerGroup(String routingServerGroup) {
        this.routingServerGroup = routingServerGroup;
    }

    public final String[] runReport(String sReportPath) {
        AsynchReply rsr;
        block5: {
            rsr = null;
            Option[] execReportRunOptions = this.getDefaultRunOptions();
            try {
                ReportService_PortType myRSPort = this.getReportService();
                rsr = myRSPort.run(new SearchPathSingleObject(sReportPath), new ParameterValue[0], execReportRunOptions);
                if (rsr.getStatus().equals((Object)AsynchReplyStatusEnum.complete) || rsr.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) break block5;
                while (!(this.mIsCanceled || rsr.getStatus().equals((Object)AsynchReplyStatusEnum.complete) || rsr.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete))) {
                    this.roundTripHeader(myRSPort);
                    rsr = myRSPort.wait(rsr.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                }
                if (ReportRunner.outputIsReady(rsr)) {
                    rsr = myRSPort.getOutput(rsr.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                    break block5;
                }
                return null;
            }
            catch (RemoteException re) {
                throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_FailedRunReport, re, new String[]{sReportPath});
            }
            catch (Exception e) {
                throw new MDSRVException(MDSRVErrorType.SERVER, MDSRVErrorCode.MSR_PD_FailedRunReport, e, new String[]{sReportPath});
            }
        }
        return this.getOutputPages(rsr);
    }

    private ReportService_PortType getReportService() {
        try {
            ReportService_ServiceLocator serviceLocator = new ReportService_ServiceLocator();
            ReportService_PortType port = serviceLocator.getreportService(ReportRunner.getDispatcherURL());
            BiBusHeader header = null;
            if (this.mCAMPassport != null) {
                CAMPassport pp = new CAMPassport();
                pp.setId(this.mCAMPassport);
                CAM mycam = new CAM();
                mycam.setCAMPassport(pp);
                header = new BiBusHeader();
                header.setCAM(mycam);
                if (null != this.mContentLocale) {
                    UserPreferenceVar[] userPreferenceVars = new UserPreferenceVar[1];
                    UserPreferenceVar contentLocalePref = new UserPreferenceVar();
                    contentLocalePref.setName("contentLocale");
                    contentLocalePref.setValue(this.mContentLocale);
                    userPreferenceVars[0] = contentLocalePref;
                    header.setUserPreferenceVars(userPreferenceVars);
                }
            } else {
                header = MFWBiBusHelper.buildBiBusHeaderFrom((BIBusEnvelope)this.mReqEnvelope);
                if (this.routingServerGroup.length() > 0) {
                    RoutingInfo rinfo = new RoutingInfo();
                    rinfo.setRoutingServerGroup(this.routingServerGroup);
                    header.setRouting(rinfo);
                }
            }
            ((Stub)port).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            return port;
        }
        catch (ServiceException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void roundTripHeader(ReportService_PortType aReportService) throws Exception {
        Stub myRSStub = (Stub)aReportService;
        SOAPHeaderElement responseHeader = myRSStub.getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (responseHeader != null) {
            myRSStub.clearHeaders();
            BiBusHeader bibus = (BiBusHeader)responseHeader.getObjectValue(BiBusHeader.class);
            myRSStub.setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
        }
    }

    private static boolean outputIsReady(AsynchReply response) {
        for (int i = 0; i < response.getDetails().length; ++i) {
            if (!(response.getDetails()[i] instanceof AsynchDetailReportStatus) || ((AsynchDetailReportStatus)response.getDetails()[i]).getStatus() != AsynchDetailReportStatusEnum.responseReady) continue;
            return true;
        }
        return false;
    }

    private Option[] getDefaultRunOptions() {
        RunOptionBoolean saveOutputRunOption = new RunOptionBoolean();
        saveOutputRunOption.setName(RunOptionEnum.saveOutput);
        saveOutputRunOption.setValue(false);
        RunOptionStringArray outputFormat = new RunOptionStringArray();
        outputFormat.setName(RunOptionEnum.outputFormat);
        outputFormat.setValue(new String[]{"XML"});
        RunOptionBoolean promptFlag = new RunOptionBoolean();
        promptFlag.setName(RunOptionEnum.prompt);
        promptFlag.setValue(false);
        AsynchOptionBoolean includePrimaryRequest = new AsynchOptionBoolean();
        includePrimaryRequest.setName(AsynchOptionEnum.alwaysIncludePrimaryRequest);
        includePrimaryRequest.setValue(false);
        Option[] outReportRunOptions = new Option[]{saveOutputRunOption, outputFormat, promptFlag, includePrimaryRequest};
        return outReportRunOptions;
    }

    private String[] getOutputPages(AsynchReply response) {
        AsynchDetailReportOutput reportOutput = null;
        for (int i = 0; !this.mIsCanceled && i < response.getDetails().length; ++i) {
            if (!(response.getDetails()[i] instanceof AsynchDetailReportOutput)) continue;
            reportOutput = (AsynchDetailReportOutput)response.getDetails()[i];
            break;
        }
        if (reportOutput == null) {
            return null;
        }
        return reportOutput.getOutputPages();
    }
}

