/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.personalData;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.reportservice.RequestInvoker;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class UpdateMetadataHandler {
    private static final String MDSERVICE = " seq=\"1\" xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:md1=\"http://developer.cognos.com/schemas/metadataService/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xts=\"http://developer.cognos.com/schemas/xts/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    private static final String OPEN_MDPROVIDER = "<mdprovider model=\"";
    private static final String CLOSE_MDPROVIDER = "</mdprovider>";
    private static final String ACTION_EXECUTE = "\" type=\"action\" action=\"execute\"";
    private static final String GENERIC_CREATE_MODEL = "\" type=\"generic\" action=\"createModel\"";
    private static final String GENERIC_OPEN_MODEL = "\" type=\"generic\" action=\"openModel\"";
    private static final String GENERIC_CLOSE_MODEL = "\" type=\"generic\" action=\"closeModel\"";
    private String mModelName;
    private boolean mIsCreate;
    private BIBusEnvelope mBIBusEnvelope;
    private RequestInvoker mRequestInvoker;
    private Element mConversationContext = null;

    UpdateMetadataHandler(String modelName, BIBusEnvelope biBusEnvelope, RequestInvoker reqInvoker) {
        this.mModelName = modelName;
        if (biBusEnvelope == null) {
            throw new RuntimeException("Invalid request envelope when using UpdateMetadataHandler class");
        }
        this.mBIBusEnvelope = biBusEnvelope;
        if (reqInvoker == null) {
            throw new RuntimeException("Invalid Request invoker when using UpdateMetadataHandler class");
        }
        this.mRequestInvoker = reqInvoker;
    }

    void openCreateModel(boolean bCreate) {
        this.mIsCreate = bCreate;
        StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
        commandStr.append(this.mModelName);
        commandStr.append(bCreate ? GENERIC_CREATE_MODEL : GENERIC_OPEN_MODEL);
        commandStr.append(MDSERVICE);
        commandStr.append(CLOSE_MDPROVIDER);
        try {
            this.invokeRequest(commandStr.toString());
        }
        catch (BMEModelCloseException mc) {
            throw new RuntimeException(mc);
        }
    }

    Element execute(String mdTransaction) {
        StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
        commandStr.append(this.mModelName);
        commandStr.append(ACTION_EXECUTE);
        commandStr.append(MDSERVICE);
        commandStr.append(mdTransaction);
        commandStr.append(CLOSE_MDPROVIDER);
        try {
            String res = this.invokeRequest(commandStr.toString());
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document resultsDoc = reader.read((Reader)new StringReader(res));
            return resultsDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (BMEModelCloseException mc) {
            this.mConversationContext = null;
            this.openCreateModel(this.mIsCreate);
            return this.execute(mdTransaction);
        }
        catch (SAXException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public void closeModel() {
        StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
        commandStr.append(this.mModelName);
        commandStr.append(GENERIC_CLOSE_MODEL);
        commandStr.append(MDSERVICE);
        commandStr.append(CLOSE_MDPROVIDER);
        try {
            this.invokeRequest(commandStr.toString());
        }
        catch (BMEModelCloseException bMEModelCloseException) {
            // empty catch block
        }
    }

    private String invokeRequest(String commandStr) throws BMEModelCloseException {
        try {
            MessageContextImpl mc = new MessageContextImpl();
            BIBusEnvelope requestEnvelope = new BIBusEnvelope();
            Element header = this.mBIBusEnvelope.getBIBusHeader();
            header = (Element)header.clone();
            header.detach();
            requestEnvelope.setBIBusHeader(header);
            Element soapBody = requestEnvelope.getBody();
            Document request = DocumentHelper.parseText((String)commandStr);
            Element requestBody = request.getRootElement();
            requestBody.detach();
            soapBody.add(requestBody);
            mc.setProperty("request.envelope", (Object)requestEnvelope);
            Element tracking = requestEnvelope.getTracking();
            tracking.clearContent();
            Element context = tracking.addElement(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName());
            context.setText("bibustkServer");
            if (this.mConversationContext == null) {
                mc.setProperty("request.soapaction", (Object)"bibustkServer");
            } else {
                mc.setProperty("request.soapaction", (Object)"bibustkServer.absolute");
                this.mConversationContext.detach();
                tracking.add(this.mConversationContext);
            }
            mc.setProperty("request.headers", (Object)new InternetHeaders());
            ArrayList toClean = new ArrayList();
            mc.setProperty("cleanup", toClean);
            this.mRequestInvoker.invoke((MessageContext)mc);
            for (int i = 0; i < toClean.size(); ++i) {
                Object cleanable = toClean.get(i);
                if (!(cleanable instanceof Cleanable)) continue;
                ((Cleanable)cleanable).clean((MessageContext)mc);
            }
            Fault f = mc.getFault();
            if (f != null) {
                if ("MDSRVHandler.missingProcess".equals(f.getMessageCode())) {
                    throw new BMEModelCloseException();
                }
                throw new RuntimeException(f.getMessageCode());
            }
            BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("response.envelope");
            Element responseBody = envelope.getBody();
            String outResponse = responseBody.asXML();
            UpdateMetadataHandler.checkQF(envelope.getEnvelope());
            if (this.mConversationContext == null) {
                Element convo = (Element)tracking.selectSingleNode("*[local-name()='conversationContext']");
                this.mConversationContext = (Element)convo.clone();
                this.mConversationContext.detach();
            }
            return outResponse;
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    private static void checkQF(Element soapEnvelope) throws BMEModelCloseException {
        Element faultCode;
        Element fault = (Element)soapEnvelope.selectSingleNode("*//*[local-name()='Fault']");
        if (fault != null && (faultCode = (Element)fault.selectSingleNode("faultcode")) != null) {
            String code = faultCode.getTextTrim();
            if (code.startsWith("CQE")) {
                Element faultString = (Element)fault.selectSingleNode("faultstring");
                UpdateMetadataHandler.processQF(code, faultString.getTextTrim(), fault.getDocument());
            } else {
                Element err;
                List errorCode = fault.getDocument().selectNodes("//errorCode");
                if (errorCode.size() > 0 && "BME-AS-0022".equals((err = (Element)errorCode.get(0)).getTextTrim())) {
                    throw new BMEModelCloseException();
                }
                List msgs = fault.getDocument().selectNodes("//messageString");
                StringBuffer outMsg = new StringBuffer();
                for (int idx = 0; idx < msgs.size(); ++idx) {
                    outMsg.append("\n\t");
                    outMsg.append(((Element)msgs.get(idx)).getText());
                }
                throw new RuntimeException(outMsg.toString());
            }
        }
    }

    private static void processQF(String fc, String fs, Document responseDoc) {
        String code = fc.substring(4);
        Element ds = (Element)responseDoc.selectSingleNode("//*[local-name()='dataSource']");
        Document document = DocumentHelper.createDocument();
        Element fault = document.addElement("Fault");
        Element faultCode = fault.addElement("faultcode");
        faultCode.setText(fc);
        Element faultString = fault.addElement("faultstring");
        faultString.setText(fs);
        Element newDs = (Element)ds.clone();
        newDs.detach();
        fault.add(newDs);
        QFException qf = new QFException(Integer.parseInt(code));
        qf.setDOM(fault);
        throw qf;
    }

    private static class BMEModelCloseException
    extends Exception {
        BMEModelCloseException() {
        }
    }
}

