/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.command.queryMD;

import com.cognos.metadataService.command.Command;
import com.cognos.metadataService.command.CommandKey;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.CROneCookie;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class CommandQueryDataSources
extends Command {
    private CommandKey mCommandKey;

    public boolean invokeRequest(MessageContext mc) {
        this.mCommandKey = new CommandKey(mc);
        Element elmCommand = this.mCommandKey.getCommandElem();
        if (elmCommand == null) {
            return false;
        }
        Element elmModel = (Element)elmCommand.selectSingleNode("input/cmSearchPath");
        if (elmModel == null) {
            return false;
        }
        String sModelPath = elmModel.getText();
        if (sModelPath == null || sModelPath.length() == 0) {
            return false;
        }
        DocumentFactory fac = new DocumentFactory();
        Element elmResponse = fac.createElement("queryModelDataSources");
        Element elmOutput = elmResponse.addElement("output");
        this.getPersonalDataSpecs(sModelPath, elmOutput);
        BIBusEnvelope soapResponse = new BIBusEnvelope();
        soapResponse.getBody().add(elmResponse);
        mc.setProperty("response.envelope", (Object)soapResponse);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPersonalDataSpecs(String modelPath, Element elmResponse) {
        MFWRequestContext myReqContext = CommandQueryDataSources.makeMFWReqContext(this.mCommandKey.getRequest());
        MFWMetadataSource myMDSource = MFWMetadataSource.create((String)"modelFM");
        myMDSource.addConnectionItem("cmSearchPath", (Object)modelPath);
        MFWModelRes gRes = MFWModelRes.getInstance();
        MFWGateway myGW = null;
        try {
            myGW = MFWGateway.open((String)"queryDataSources", (MFWRequestContext)myReqContext, (MFWMetadataSource)myMDSource);
            MFWQuerySpec qsDSs = MFWQuerySpec.create((String)"/project/dataSource");
            MFWNodeHandle[] hDataSrcs = myGW.query(qsDSs);
            for (int idx = 0; idx < hDataSrcs.length; ++idx) {
                Element elmDataSrc = elmResponse.addElement("dataSource");
                String dsProp = myGW.getObjectPropertyValue(hDataSrcs[idx], gRes.RID_cmDataSource);
                if (dsProp != null) {
                    elmDataSrc.addElement("cmDataSource").addText(dsProp);
                }
                if ((dsProp = myGW.getObjectPropertyValue(hDataSrcs[idx], gRes.RID_interface)) != null) {
                    elmDataSrc.addElement("interface").addText(dsProp);
                }
                dsProp = myGW.getObjectPropertyValue(hDataSrcs[idx], gRes.getResourceID("sourceType"));
                elmDataSrc.addElement("sourceType").addText(dsProp != null ? dsProp : "regular");
                dsProp = myGW.getObjectPropertyValue(hDataSrcs[idx], gRes.getResourceID("sourcePath"));
                if (dsProp != null) {
                    elmDataSrc.addElement("sourcePath").addText(dsProp);
                }
                MFWNodeHandle[] hCustProps = myGW.queryObject(hDataSrcs[idx], MFWQuerySpec.create((String)"property[name='directAccess']"));
                String directAccess = null;
                if (hCustProps.length > 0) {
                    directAccess = myGW.getObjectPropertyValue(hCustProps[0], gRes.RID__Value);
                }
                if (directAccess == null) continue;
                elmDataSrc.addElement("directAccess").addText(directAccess);
            }
            MFWQuerySpec qsLWMs = MFWQuerySpec.create((String)"/project//namespace[isCube='true']");
            MFWNodeHandle[] hDLwmNSs = myGW.query(qsLWMs);
            for (int idx = 0; idx < hDLwmNSs.length; ++idx) {
                Element elmDataSrc = elmResponse.addElement("dataSource");
                String nsProp = myGW.getObjectPropertyValue(hDLwmNSs[idx], gRes.getResourceID("cubeCMDataSource"));
                if (nsProp != null) {
                    elmDataSrc.addElement("cmDataSource").addText(nsProp);
                }
                if ((nsProp = myGW.getObjectPropertyValue(hDLwmNSs[idx], gRes.getResourceID("cubeType"))) != null) {
                    elmDataSrc.addElement("interface").addText(nsProp);
                }
                elmDataSrc.addElement("sourceType").addText("regular");
            }
        }
        finally {
            if (myGW != null) {
                myGW.close();
            }
        }
    }

    public static MFWRequestContext makeMFWReqContext(BIBusEnvelope soapEnvelope) {
        String cookieString = soapEnvelope.getCookieValue("CRN");
        CROneCookie aCookie = cookieString == null ? null : new CROneCookie(cookieString);
        MFWRequestContext aReqContext = MFWRequestContext.create((String)(aCookie == null ? "en" : (String)aCookie.getPreferences().get("productLocale")), (String)(aCookie == null ? "en" : (String)aCookie.getPreferences().get("contentLocale")), (String)soapEnvelope.getPassportID());
        CommandQueryDataSources.addNoLWM2RequestContext(aReqContext);
        return aReqContext;
    }

    public static void addNoLWM2RequestContext(MFWRequestContext aReqContext) {
        try {
            StringReader myReader = new StringReader("<noLWMCluster/>");
            SAXReader myParser = new SAXReader();
            myParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            myParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            myParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document document = myParser.read((Reader)myReader);
            aReqContext.setConnectionSpec(document.getRootElement());
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

