/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.contentmanager;

import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerDeleteCommand;
import com.cognos.pogo.util.CROneCookie;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class CMDelete {
    protected Element m_bibusHeaderElem;
    protected MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();

    public CMDelete(Element bibusHeaderElem, CROneCookie cookie) {
        this.m_bibusHeaderElem = bibusHeaderElem;
    }

    public boolean deleteObject(String objectClass, String target) {
        if (target == null || target.length() == 0) {
            return true;
        }
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(target);
        return this.deleteMultipleObjs(objectClass, targets);
    }

    public boolean deleteMultipleObjs(String objectClass, List<String> targets) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException(this.getClass().getName() + "::deleteMultipleObjs requires a non-empty list of targets");
        }
        ContentManagerDeleteCommand deleteCommand = new ContentManagerDeleteCommand();
        for (String target : targets) {
            deleteCommand.addObject(objectClass);
            deleteCommand.setSearchPath(target);
        }
        deleteCommand.setForce(true);
        deleteCommand.setRecursive(true);
        try {
            this.m_bibusHeaderElem.detach();
            Element bibusHeaderElem = (Element)this.m_bibusHeaderElem.clone();
            bibusHeaderElem.detach();
            deleteCommand.setBIBusHeader(bibusHeaderElem);
            ServicePerfMarker perfMarker = new ServicePerfMarker(this.getClass().getName() + "deleteMultipleObjs, with count of searchPaths:" + targets.size(), "CALL");
            deleteCommand.execute();
            perfMarker.endPerf();
            return deleteCommand.getNumObjectsDeleted() == targets.size();
        }
        catch (CommandExecutionException e) {
            this.m_logUtil.rethrownException(this.getClass().getName() + "Error occurring when deleting CM for count of searchPaths: " + targets.size(), e);
            throw new RuntimeException(e);
        }
    }
}

