/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.contentmanager;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.description.TypeDesc;
import org.dom4j.Element;

public class CMObject {
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    CMQuery m_sourceQuery;
    Element m_itemElem;
    String m_storeId;
    String m_searchPath;
    String m_objectClass;
    String m_defaultName;

    public CMObject(CMQuery cmQueryHelper, Element itemElem) {
        this.m_sourceQuery = cmQueryHelper;
        this.m_itemElem = itemElem;
    }

    public String getStoreId() {
        if (this.m_storeId == null) {
            this.m_storeId = this.getStringPropValue(PropEnum.storeID);
        }
        return this.m_storeId;
    }

    public String getSearchPath() {
        if (this.m_searchPath == null) {
            this.m_searchPath = this.getStringPropValue(PropEnum.searchPath);
        }
        return this.m_searchPath;
    }

    public String getDefaultName() {
        if (this.m_defaultName == null) {
            this.m_defaultName = this.getStringPropValue(PropEnum.defaultName);
        }
        return this.m_defaultName;
    }

    public String getObjectClass() {
        if (this.m_objectClass == null) {
            this.m_objectClass = this.getStringPropValue(PropEnum.objectClass);
        }
        return this.m_objectClass;
    }

    public boolean isAxisType(Class<? extends BaseClass> expectedAxisClass) {
        String objectClass = this.getObjectClass();
        TypeDesc expectedTypeDesc = TypeDesc.getTypeDescForClass(expectedAxisClass);
        QName expectedXmlType = expectedTypeDesc.getXmlType();
        String expectedXmlTypeLocalPart = expectedXmlType.getLocalPart();
        return expectedXmlTypeLocalPart.equals(objectClass);
    }

    public Element getProp(PropEnum propName) {
        return this.m_itemElem.element(propName.getValue());
    }

    public String getStringPropValue(PropEnum propName) {
        Element valueElem;
        Element propElem;
        String propValue = null;
        if (this.m_itemElem != null && (propElem = this.getProp(propName)) != null && (valueElem = propElem.element(VALUE)) != null) {
            propValue = new String();
            propValue = propValue + valueElem.getText();
        }
        return propValue;
    }

    public CMObject getParent() {
        Element itemElem;
        List itemElemList;
        Element propValueElem;
        CMObject parent = null;
        Element propElem = this.getProp(PropEnum.parent);
        if (propElem != null && (propValueElem = propElem.element(VALUE)) != null && (itemElemList = propValueElem.elements(ITEM)).size() > 0 && (itemElem = (Element)itemElemList.get(0)) != null) {
            parent = new CMObject(this.m_sourceQuery, itemElem);
        }
        if (parent != null && parent.getSearchPath() != null) {
            parent = this.getSourceQuery().querySingleObj(parent.getSearchPath(), CMQuery.baseClassProps);
        }
        return parent;
    }

    public String getParentSearchPath() {
        return this.getRefObjPropValue(PropEnum.parent, PropEnum.searchPath);
    }

    public String getRefObjPropValue(PropEnum propName, PropEnum refobjProp) {
        return this.getRefObjPropValue(propName, refobjProp, true);
    }

    public String getRefObjPropValue(PropEnum propName, PropEnum refobjProp, boolean isTrusted) {
        Element itemElem;
        List itemElemList;
        Element propValueElem;
        String refobjPropValue = null;
        Element propElem = this.getProp(propName);
        if (propElem != null && (propValueElem = propElem.element(VALUE)) != null && (itemElemList = propValueElem.elements(ITEM)).size() > 0 && (itemElem = (Element)itemElemList.get(0)) != null) {
            String refobjSearchPathValue;
            Element refobjSearchPathElem;
            Element refobjPropElem = itemElem.element(refobjProp.getValue());
            if (refobjPropElem != null) {
                refobjPropValue = refobjPropElem.elementText(VALUE);
            }
            if (refobjPropElem == null && (refobjSearchPathElem = itemElem.element(PropEnum.searchPath.getValue())) != null && (refobjSearchPathValue = refobjSearchPathElem.elementText(VALUE)) != null) {
                PropEnum[] refobjQueryProps = new PropEnum[]{refobjProp};
                CMObject refobj = this.m_sourceQuery.querySingleObj(refobjSearchPathValue, refobjQueryProps, isTrusted);
                refobjPropValue = refobj != null ? refobj.getStringPropValue(refobjProp) : null;
            }
        }
        return refobjPropValue;
    }

    public Element getItemElem() {
        return this.m_itemElem;
    }

    public CMQuery getSourceQuery() {
        return this.m_sourceQuery;
    }
}

