/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.contentmanager;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.util.errors.MDSRVErrorCode;
import com.cognos.metadataService.util.errors.MDSRVErrorType;
import com.cognos.metadataService.util.errors.MDSRVSoapFaultException;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.logging.ServicePerfMarker;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.util.CROneCookie;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class CMQuery {
    static final String SEARCH_PATH_ACCOUNT = "~";
    protected MDSRVLogUtil m_logUtil = MDSRVLogUtil.getLogUtilInstance();
    protected Element m_bibusHeaderElem;
    protected String m_productLocale;
    protected String m_contentLocale;
    public static final String MODEL_LAST_SUFFIX = "/model[last()]";
    public static final PropEnum[] baseClassProps = new PropEnum[]{PropEnum.storeID, PropEnum.searchPath, PropEnum.objectClass, PropEnum.defaultName, PropEnum.owner, PropEnum.parent};

    public CMQuery(Element bibusHeaderElem, CROneCookie cookie) {
        this.m_bibusHeaderElem = bibusHeaderElem;
        this.determineLocales(cookie);
    }

    public CMObject querySingleObj(String objectPath, PropEnum[] props) {
        return this.querySingleObj(objectPath, props, true);
    }

    public CMObject querySingleObj(String objectPath, PropEnum[] props, boolean isTrusted) {
        CMClass resultObj = null;
        ContentManagerQueryCommand queryCommand = new ContentManagerQueryCommand(objectPath);
        try {
            this.m_bibusHeaderElem.detach();
            Element bibusHeaderElem = (Element)this.m_bibusHeaderElem.clone();
            bibusHeaderElem.detach();
            queryCommand.setBIBusHeader(bibusHeaderElem);
            boolean bParent = false;
            for (int propsIdx = 0; propsIdx < props.length; ++propsIdx) {
                PropEnum prop = props[propsIdx];
                queryCommand.addQueryPropertyName(prop.getValue());
                if (!prop.equals((Object)PropEnum.parent)) continue;
                bParent = true;
            }
            if (bParent) {
                queryCommand.addRefPropName(PropEnum.parent.getValue());
                queryCommand.addQueryParentProperty(PropEnum.objectClass.getValue());
                queryCommand.addQueryParentProperty(PropEnum.searchPath.getValue());
                queryCommand.addQueryParentProperty(PropEnum.storeID.getValue());
                queryCommand.addQueryParentProperty(PropEnum.defaultName.getValue());
            }
            queryCommand.setDoTrustedRequest(isTrusted);
            ServicePerfMarker perfMarker = new ServicePerfMarker(this.getClass().getName() + "querySingleObj, calling searchPath:" + objectPath, "CALL");
            queryCommand.execute();
            perfMarker.endPerf();
            Element queryResponseElem = queryCommand.getQueryResponseElement();
            if (!queryCommand.isResultEmpty()) {
                resultObj = queryCommand.getFirstResultClass();
            }
            if (queryResponseElem != null) {
                queryResponseElem.detach();
            }
        }
        catch (SoapFaultException e) {
            throw new MDSRVSoapFaultException(e, MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_CMException, new String[]{queryCommand.getRequestEnvelope().getBody().asXML()}, queryCommand.getResponseEnvelope());
        }
        catch (CommandExecutionException e) {
            this.m_logUtil.rethrownException(this.getClass().getName() + "Error occurring when querying CM for searchPath: " + objectPath, e);
            throw new RuntimeException(e);
        }
        if (resultObj == null) {
            this.m_logUtil.unexpectedSituation(this.getClass().getName() + "querying Content Manager for object '" + objectPath + "' returned a null response");
        }
        return resultObj == null ? null : new CMObject(this, resultObj.getItemElement());
    }

    public List<CMObject> queryMultipleObjs(List<String> searchPaths, PropEnum[] props) {
        StringBuilder searchPath = new StringBuilder();
        for (String pathItem : searchPaths) {
            searchPath.append(pathItem);
            searchPath.append("|");
        }
        return this.queryMultipleObjs(searchPath.substring(0, searchPath.length() - 1), props);
    }

    public List<CMObject> queryMultipleObjs(String searchPath, PropEnum[] props) {
        ArrayList<CMObject> resultObjs = new ArrayList<CMObject>();
        ContentManagerQueryCommand queryCommand = new ContentManagerQueryCommand(searchPath);
        try {
            queryCommand.setBIBusHeader(this.m_bibusHeaderElem);
            boolean bParent = false;
            for (int propsIdx = 0; propsIdx < props.length; ++propsIdx) {
                PropEnum prop = props[propsIdx];
                queryCommand.addQueryPropertyName(prop.getValue());
                if (!prop.equals((Object)PropEnum.parent)) continue;
                bParent = true;
            }
            if (bParent) {
                queryCommand.addRefPropName(PropEnum.parent.getValue());
                queryCommand.addQueryParentProperty(PropEnum.objectClass.getValue());
                queryCommand.addQueryParentProperty(PropEnum.searchPath.getValue());
                queryCommand.addQueryParentProperty(PropEnum.storeID.getValue());
                queryCommand.addQueryParentProperty(PropEnum.defaultName.getValue());
            }
            ServicePerfMarker perfMarker = new ServicePerfMarker(this.getClass().getName() + "queryMultipleObjs, calling searchPath:" + searchPath, "CALL");
            queryCommand.execute();
            perfMarker.endPerf();
            Element queryResponseElem = queryCommand.getQueryResponseElement();
            for (CMClass result : queryCommand.getResultList()) {
                if (result == null) continue;
                resultObjs.add(new CMObject(this, result.getItemElement()));
            }
            if (queryResponseElem != null) {
                queryResponseElem.detach();
            }
        }
        catch (SoapFaultException e) {
            throw new MDSRVSoapFaultException(e, MDSRVErrorType.CLIENT, MDSRVErrorCode.MSR_MSR_CMException, new String[]{queryCommand.getRequestEnvelope().getBody().asXML()}, queryCommand.getResponseEnvelope());
        }
        catch (CommandExecutionException e) {
            this.m_logUtil.rethrownException(this.getClass().getName() + "Error occurring when querying CM for searchPath: " + searchPath, e);
            throw new RuntimeException(e);
        }
        if (resultObjs == null || resultObjs.isEmpty()) {
            this.m_logUtil.unexpectedSituation(this.getClass().getName() + "querying Content Manager for object '" + searchPath + "' returned a null response");
        }
        return resultObjs;
    }

    public String getProductLocale() {
        return this.m_productLocale;
    }

    public String getContentLocale() {
        return this.m_contentLocale;
    }

    protected void determineLocales(CROneCookie cookie) {
        boolean searchLocales;
        boolean bl = searchLocales = cookie == null;
        if (!searchLocales) {
            this.m_productLocale = (String)cookie.getPreferences().get("productLocale");
            this.m_contentLocale = (String)cookie.getPreferences().get("contentLocale");
            boolean bl2 = searchLocales = this.m_productLocale == null || this.m_contentLocale == null;
        }
        if (searchLocales) {
            CMObject accountObj = this.querySingleObj(SEARCH_PATH_ACCOUNT, new PropEnum[]{PropEnum.contentLocale, PropEnum.productLocale});
            if (accountObj == null) {
                this.m_logUtil.unexpectedSituation("ContentManagerQueryHelper.init: Got null when trying to query cm for content and product locale preferences of current account");
                this.m_productLocale = "en";
                this.m_contentLocale = "en";
            }
            if (this.m_productLocale == null) {
                this.m_productLocale = accountObj.getStringPropValue(PropEnum.productLocale);
                if (this.m_productLocale == null) {
                    this.m_logUtil.unexpectedSituation("ContentManagerQueryHelper.init: Got null for product locale of current account");
                    this.m_productLocale = "en";
                }
            }
            if (this.m_contentLocale == null) {
                this.m_contentLocale = accountObj.getStringPropValue(PropEnum.contentLocale);
                if (this.m_contentLocale == null) {
                    this.m_logUtil.unexpectedSituation("ContentManagerQueryHelper.init: Got null for content locale of current account");
                    this.m_contentLocale = "en";
                }
            }
        }
    }

    public static PropEnum[] concatProps(PropEnum[] props1, PropEnum[] props2) {
        PropEnum[] resultProps = new PropEnum[props1.length + props2.length];
        System.arraycopy(props1, 0, resultProps, 0, props1.length);
        System.arraycopy(props2, 0, resultProps, props1.length, props2.length);
        return resultProps;
    }
}

