/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.contentmanager;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.metadataService.sources.contentmanager.CMObject;
import com.cognos.metadataService.sources.contentmanager.CMQuery;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class SearchPathMap {
    CMQuery m_cmQuery;
    HashMap<String, String> m_storedIdSearchPathMap = new LinkedHashMap<String, String>();
    HashMap<String, Object> m_searchPathObjectMap = new LinkedHashMap<String, Object>();

    public SearchPathMap(CMQuery cmQueryHelper) {
        this.m_cmQuery = cmQueryHelper;
    }

    public void add(String searchPath, Object obj) {
        this.m_searchPathObjectMap.put(searchPath, obj);
    }

    public void registerCMObj(CMObject cmObj, Object obj) {
        String storeId = cmObj.getStoreId();
        String searchPath = cmObj.getSearchPath();
        this.m_storedIdSearchPathMap.put(storeId, searchPath);
        this.m_searchPathObjectMap.put(searchPath, obj);
    }

    public Object find(String searchPath) {
        CMObject cmObj;
        Object foundObj = this.m_searchPathObjectMap.get(searchPath);
        if (foundObj == null && (cmObj = this.m_cmQuery.querySingleObj(searchPath, new PropEnum[]{PropEnum.searchPath, PropEnum.storeID})) != null) {
            String storeId = cmObj.getStoreId();
            String foundSearchPath = this.m_storedIdSearchPathMap.get(storeId);
            if (foundSearchPath != null) {
                foundObj = this.m_searchPathObjectMap.get(foundSearchPath);
            }
            if (foundObj != null) {
                this.m_searchPathObjectMap.put(searchPath, foundObj);
            }
        }
        return foundObj;
    }
}

