/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.metadataService.sources.mfw.IModelRoots;
import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.util.HashSet;
import java.util.Iterator;

public class ContentManagerMetadataSourceRetrieval {
    public String[] getSearchPaths(MFWGateway mfwGateway, IModelRoots modelRoots) {
        HashSet<String> cmSearchPathsSet = new HashSet<String>();
        MFWNodeHandle[] childNsNodes = mfwGateway.getObjectChildren(modelRoots.getRootNamespaceNode(), MFWModelRes.getInstance().RID_namespace);
        for (int childNodesIdx = 0; childNodesIdx < childNsNodes.length; ++childNodesIdx) {
            String searchPath = null;
            MFWMetadataSource metadataSource = mfwGateway.getAssociatedMetadataSource(childNsNodes[childNodesIdx]);
            if (metadataSource != null) {
                searchPath = (String)metadataSource.getConnectionItem("cmSearchPath");
            }
            if (searchPath == null) continue;
            cmSearchPathsSet.add(searchPath);
        }
        String[] searchPaths = new String[cmSearchPathsSet.size()];
        int resultSearchPathsIdx = 0;
        Iterator cmSearchPathsSetIter = cmSearchPathsSet.iterator();
        while (cmSearchPathsSetIter.hasNext()) {
            searchPaths[resultSearchPathsIdx] = (String)cmSearchPathsSetIter.next();
            ++resultSearchPathsIdx;
        }
        return searchPaths;
    }

    public String getCmSearchPath(MFWGateway mfwGateway, MFWNodeHandle objectNode) {
        String metadataSourcePath = null;
        MFWMetadataSource metadataSource = mfwGateway.getAssociatedMetadataSource(objectNode);
        if (metadataSource == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Mfw did not return us a metadata source found for object: ");
        } else {
            metadataSourcePath = (String)metadataSource.getConnectionItem("cmSearchPath");
        }
        if (metadataSourcePath == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Mfw did not return us a cmSearch path for object: . trying the top-level namespace");
        }
        return metadataSourcePath;
    }
}

