/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.metadataService.sources.mfw.RIDHacks;
import com.cognos.metadataService.util.misc.LocalizedStrings;
import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;

public class LocalizedSchemaValues {
    public static final String BUNDLENAME = "mfwModel";
    public static final String IDSEPARATOR = String.valueOf('_');
    public static final String MSGSECTIONPREFIX = "MSR_MFW" + IDSEPARATOR;
    private static final String ENUMPREFIX = "enum" + IDSEPARATOR;
    private static final String ENUMRESIDPREFIX = MSGSECTIONPREFIX + ENUMPREFIX;
    public static final String KEY_OBJECT_ID = "objectId";
    public static final String KEY_OBJECT_NAME = "objectName";
    public static final String KEY_OBJECT_TYPE = "objectType";
    public static final String KEY_TRANSFORMATION = "transformation";
    public static final String KEY_EXPRESSION = "expression";
    private static final String UNKNOWN = "unknown";
    private static final String AGGREGATEVALUERESIDPREFIX = "aggregate";
    HashMap<Short, String> m_objectPropertyNameMap = new HashMap();
    HashMap<String, String> m_enumValueMap = new HashMap();
    LocalizedStrings m_mfwStrings;
    LocalizedStrings m_mdsrvStrings;
    private StringBuffer m_keyBuffer = new StringBuffer();
    private String m_localizedLineageObjectIDPropertyName;
    private String m_localizedLineageObjectNamePropertyName;
    private String m_localizedLineageObjectTypePropertyName;
    private String m_localizedLineageObjectTrasformationObjectName;
    private String m_localizedLineageObjectExpressionObjectName;
    private MFWModelRes m_modelRes = MFWModelRes.getInstance();

    public LocalizedSchemaValues(String locale) {
        this.m_mdsrvStrings = new LocalizedStrings(locale);
        this.m_mfwStrings = new LocalizedStrings(locale, BUNDLENAME);
        this.buildMap();
    }

    public LocalizedStrings getMdsrvStrings() {
        return this.m_mdsrvStrings;
    }

    private void buildMap() {
        ResourceBundle bundle = this.m_mfwStrings.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String strippedKey;
            String value;
            String nextElement = keys.nextElement();
            String resourceKey = nextElement.toString();
            if (resourceKey.startsWith(ENUMRESIDPREFIX)) {
                value = bundle.getString(resourceKey).toString();
                strippedKey = resourceKey.substring(ENUMRESIDPREFIX.length());
                this.m_enumValueMap.put(strippedKey, value);
                continue;
            }
            if (!resourceKey.startsWith(MSGSECTIONPREFIX)) continue;
            value = bundle.getString(resourceKey).toString();
            strippedKey = resourceKey.substring(MSGSECTIONPREFIX.length());
            short objectOrPropertyRid = RIDHacks.getRIDForName(strippedKey);
            if (objectOrPropertyRid == -1) continue;
            Short rid = new Short(objectOrPropertyRid);
            this.m_objectPropertyNameMap.put(rid, value);
        }
        this.m_localizedLineageObjectIDPropertyName = bundle.getString(MSGSECTIONPREFIX + KEY_OBJECT_ID);
        this.m_localizedLineageObjectTypePropertyName = bundle.getString(MSGSECTIONPREFIX + KEY_OBJECT_TYPE);
        this.m_localizedLineageObjectNamePropertyName = bundle.getString(MSGSECTIONPREFIX + KEY_OBJECT_NAME);
        this.m_localizedLineageObjectTrasformationObjectName = bundle.getString(MSGSECTIONPREFIX + KEY_TRANSFORMATION);
        this.m_localizedLineageObjectExpressionObjectName = bundle.getString(MSGSECTIONPREFIX + KEY_EXPRESSION);
    }

    public String getLocalizedObjectIDPropertyName() {
        return this.m_localizedLineageObjectIDPropertyName;
    }

    public String getLocalizedObjectTypePropertyName() {
        return this.m_localizedLineageObjectTypePropertyName;
    }

    public String getLocalizedObjectNamePropertyName() {
        return this.m_localizedLineageObjectNamePropertyName;
    }

    public String getLocalizedLineageObjectTrasformationObjectName() {
        return this.m_localizedLineageObjectTrasformationObjectName;
    }

    public String getLocalizedLineageObjectExpressionObjectName() {
        return this.m_localizedLineageObjectExpressionObjectName;
    }

    public String getLocalizedValue(short objectOrPropertyRid) {
        return this.m_objectPropertyNameMap.get(new Short(objectOrPropertyRid));
    }

    public String getLocalizedEnumValue(short propertyRid, String enumValueName) {
        this.m_keyBuffer.setLength(0);
        if (!enumValueName.equals(UNKNOWN)) {
            if (propertyRid == this.m_modelRes.RID_aggregateRule || propertyRid == this.m_modelRes.RID_aggregationRule || propertyRid == this.m_modelRes.RID_semiAggregate || propertyRid == this.m_modelRes.RID_applyAggregate || propertyRid == this.m_modelRes.RID_regularAggregate || propertyRid == this.m_modelRes.RID_rollupAggregate) {
                this.m_keyBuffer.append(AGGREGATEVALUERESIDPREFIX);
            } else {
                this.m_keyBuffer.append(RIDHacks.getNameForRID(propertyRid));
            }
            this.m_keyBuffer.append(IDSEPARATOR);
        }
        this.m_keyBuffer.append(enumValueName);
        String foundValue = this.m_enumValueMap.get(this.m_keyBuffer.toString());
        if (foundValue == null) {
            foundValue = enumValueName;
        }
        return foundValue;
    }
}

