/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.metadataService.sources.mfw.IModelRoots;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MultilingualPropertyTranslater {
    MFWGateway m_mfwGateway;
    String m_contentLocale;
    private HashMap<String, Integer> m_localesIndexMap = new HashMap();
    private MFWModelRes m_modelRes;
    private static final char LOCALEID_SEPARATOR = ':';
    private static final String LOCALEID_SEPARATOR_STR = String.valueOf(':');
    private final IModelRoots m_modelRoots;

    public MultilingualPropertyTranslater(MFWGateway mfwGateway, IModelRoots modelRoots) {
        this.m_modelRoots = modelRoots;
        String contentLocale = mfwGateway.getContext().getProductLocale();
        this.m_modelRes = MFWModelRes.getInstance();
        this.m_mfwGateway = mfwGateway;
        String[] modelLocales = this.getModelLocales();
        int modelLocaleIdx = this.matchLocale(contentLocale, modelLocales);
        this.m_contentLocale = modelLocaleIdx >= 0 ? modelLocales[modelLocaleIdx] : modelLocales[0];
    }

    public MFWNodeHandle getProperty(MFWNodeHandle[] propNodes) {
        MFWNodeHandle resultNode = null;
        int localeIdx = -1;
        if (propNodes.length == 1) {
            resultNode = propNodes[0];
        } else if (propNodes.length > 1) {
            StringBuffer concatenatedLocalesBuffer = new StringBuffer();
            for (int propNodesIdx = 0; propNodesIdx < propNodes.length; ++propNodesIdx) {
                MFWNodeHandle propNode = propNodes[propNodesIdx];
                MFWNodeHandle[] localeNodes = this.m_mfwGateway.getObjectChildren(propNode, this.m_modelRes.RID_locale);
                String localeId = this.m_mfwGateway.getPropertyValue(localeNodes[0]);
                if (concatenatedLocalesBuffer.length() > 0) {
                    concatenatedLocalesBuffer.append(':');
                }
                concatenatedLocalesBuffer.append(localeId);
            }
            String concatenatedLocales = concatenatedLocalesBuffer.toString();
            Integer matchingLocaleIdx = this.m_localesIndexMap.get(concatenatedLocales);
            if (matchingLocaleIdx == null) {
                String[] localesList = concatenatedLocales.split(LOCALEID_SEPARATOR_STR);
                matchingLocaleIdx = new Integer(this.matchLocale(this.m_contentLocale, localesList));
                this.m_localesIndexMap.put(concatenatedLocales, matchingLocaleIdx);
            }
            if ((localeIdx = matchingLocaleIdx.intValue()) == -1) {
                localeIdx = 0;
            }
            resultNode = propNodes[localeIdx];
        }
        return resultNode;
    }

    private String[] getModelLocales() {
        String[] modelLocales = null;
        MFWNodeHandle rootNamespaceNode = this.m_modelRoots.getRootNamespaceNode();
        MFWNodeHandle m_rootNamespaceNode = rootNamespaceNode;
        MFWNodeHandle[] childNsNodes = this.m_mfwGateway.getObjectChildren(m_rootNamespaceNode, this.m_modelRes.RID_namespace);
        if (childNsNodes.length > 0) {
            HashSet<String> locales = new HashSet<String>();
            for (int childNsNodesIdx = 0; childNsNodesIdx < childNsNodes.length; ++childNsNodesIdx) {
                MFWNodeHandle[] nameNodes = this.m_mfwGateway.getObjectChildren(childNsNodes[childNsNodesIdx], this.m_modelRes.RID_name);
                for (int nameNodesIdx = 0; nameNodesIdx < nameNodes.length; ++nameNodesIdx) {
                    MFWNodeHandle[] localeProps = this.m_mfwGateway.getObjectChildren(nameNodes[nameNodesIdx], this.m_modelRes.RID_locale);
                    for (int localePropsIdx = 0; localePropsIdx < localeProps.length; ++localePropsIdx) {
                        String localeValue = this.m_mfwGateway.getPropertyValue(localeProps[localePropsIdx]);
                        locales.add(localeValue);
                    }
                }
            }
            modelLocales = new String[locales.size()];
            Iterator localesIter = locales.iterator();
            int localeIdx = -1;
            while (localesIter.hasNext()) {
                modelLocales[++localeIdx] = (String)localesIter.next();
            }
        } else {
            MFWNodeHandle[] localeNodes = this.m_mfwGateway.getObjectChildren(this.m_modelRoots.getRootProjectNode(), this.m_modelRes.RID_locale);
            modelLocales = new String[localeNodes.length];
            for (int localeNodesIdx = 0; localeNodesIdx < localeNodes.length; ++localeNodesIdx) {
                MFWNodeHandle localePropertyNode = localeNodes[localeNodesIdx];
                modelLocales[localeNodesIdx] = this.m_mfwGateway.getPropertyValue(localePropertyNode);
            }
        }
        return modelLocales;
    }

    private int matchLocale(String sourceLocale, String[] candidateLocales) {
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        int foundIndex = MultilingualPropertyTranslater.indexOf(candidateLocales, sourceLocale);
        if (foundIndex < 0) {
            try {
                String mappedLocale = config.mapContentLocale(sourceLocale, false);
                foundIndex = MultilingualPropertyTranslater.indexOf(candidateLocales, mappedLocale);
                for (int candidateLocalesIdx = 0; foundIndex < 0 && candidateLocalesIdx < candidateLocales.length; ++candidateLocalesIdx) {
                    String mappedCandidateLocale = config.mapContentLocale(candidateLocales[candidateLocalesIdx], false);
                    if (!mappedCandidateLocale.equals(mappedLocale)) continue;
                    foundIndex = candidateLocalesIdx;
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return foundIndex;
    }

    private static int indexOf(String[] candidateLocales, String mappedLocale) {
        int foundIndex = -1;
        for (int arrayIdx = 0; foundIndex == -1 && arrayIdx < candidateLocales.length; ++arrayIdx) {
            if (!mappedLocale.equals(candidateLocales[arrayIdx])) continue;
            foundIndex = arrayIdx;
        }
        return foundIndex;
    }
}

