/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.metadataService.util.logging.MDSRVLogUtil;
import com.cognos.metadataService.util.misc.XMLHelper;
import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;

public class NodeQuery {
    private MFWGateway m_mfwGateway;
    private static final String IDQUERYPATH_PREFIX = "//*[ID='";
    private static final String IDQUERYPATH_SUFFIX = "']";

    public NodeQuery(MFWGateway mfwGateway) {
        this.m_mfwGateway = mfwGateway;
    }

    public MFWNodeHandle findObjectNodeForId(IV5UniqueNamePiece v5UniqueNamePiece) {
        MFWNodeHandle objectNode;
        String value = v5UniqueNamePiece.referenceValue();
        String escapedId = XMLHelper.escapeXMLCharacters(value);
        StringBuffer queryStringBuf = new StringBuffer(IDQUERYPATH_PREFIX.length() + escapedId.length() + IDQUERYPATH_SUFFIX.length());
        queryStringBuf.append(IDQUERYPATH_PREFIX);
        queryStringBuf.append(escapedId);
        queryStringBuf.append(IDQUERYPATH_SUFFIX);
        String mfwQueryPath = queryStringBuf.toString();
        MFWNodeHandle[] foundNodes = null;
        try {
            MFWQuerySpec querySpec = MFWQuerySpec.create((String)mfwQueryPath);
            foundNodes = this.m_mfwGateway.query(querySpec);
        }
        catch (NullPointerException e) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("NullPointerException from MFW when trying to query with path: '" + mfwQueryPath + "'.");
        }
        MFWNodeHandle mFWNodeHandle = objectNode = foundNodes == null || foundNodes.length == 0 ? null : foundNodes[0];
        if (objectNode == null) {
            MDSRVLogUtil.getLogUtilInstance().unexpectedSituation("Could not locate object with ID: '" + value + "'.");
        }
        return objectNode;
    }
}

