/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.metadataService.sources.mfw;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axis.encoding.Base64;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ParameterItem {
    public String m_connectionSearchPath = null;
    public String m_connectionString = null;
    public String m_signonSearchPath = null;
    public String m_userName = null;
    public String m_password = null;
    public String m_cubePassword = null;
    public String m_cubePasswordEncrypted = null;
    public String m_SAPLogonTicket = null;
    public String m_namespace = null;
    public String m_dataSourceName = null;

    public ParameterItem(Element item, CAMFactory factory) {
        this.populateFrom(item, factory);
    }

    private void populateFrom(Element item, CAMFactory factory) {
        Element name = (Element)item.selectSingleNode("name");
        if (name != null) {
            Element use;
            Element subItem;
            String value = name.getText();
            if (value != null && value.toLowerCase().startsWith("credential:")) {
                this.m_dataSourceName = value.substring("credential".length() + 1);
            }
            if ((subItem = (Element)item.selectSingleNode("value/value")) != null && (use = (Element)subItem.selectSingleNode("use")) != null) {
                String credentialDOM = use.getText();
                this.extractCredentials(credentialDOM, factory);
            }
        }
    }

    private void extractCredentials(String credentialXML, CAMFactory factory) {
        Document domCredential = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            domCredential = reader.read((InputStream)new ByteArrayInputStream(credentialXML.getBytes()));
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Throwable t) {
            return;
        }
        Element domDSConnection = (Element)domCredential.selectSingleNode("//dataSourceConnection");
        Element domDSConnectionString = (Element)domCredential.selectSingleNode("//connectionString");
        Element domDSSignon = (Element)domCredential.selectSingleNode("//dataSourceSignon");
        Element domDSUsername = (Element)domCredential.selectSingleNode("//username");
        Element domDSPassword = (Element)domCredential.selectSingleNode("//password");
        Element domDSCubePassword = (Element)domCredential.selectSingleNode("//cubePassword");
        Element domDSSAPLogonTicket = (Element)domCredential.selectSingleNode("//SAPLogonTicket");
        Element domDSNamespace = (Element)domCredential.selectSingleNode("//namespace");
        Element encrypted = (Element)domCredential.selectSingleNode("//encryptedValue");
        if (domDSConnection != null) {
            this.m_connectionSearchPath = domDSConnection.getText();
        }
        if (domDSConnectionString != null) {
            this.m_connectionString = domDSConnectionString.getText();
        }
        if (domDSSignon != null) {
            this.m_signonSearchPath = domDSSignon.getText();
        }
        if (domDSUsername != null) {
            this.m_userName = domDSUsername.getText();
        }
        if (domDSPassword != null) {
            this.m_password = domDSPassword.getText();
        }
        if (domDSCubePassword != null) {
            this.m_cubePassword = domDSCubePassword.getText();
            this.m_cubePasswordEncrypted = domDSCubePassword.attributeValue("encrypted");
        }
        if (domDSSAPLogonTicket != null) {
            this.m_SAPLogonTicket = domDSSAPLogonTicket.getText();
        }
        if (domDSNamespace != null) {
            this.m_namespace = domDSNamespace.getText();
        }
        if (encrypted != null) {
            try {
                String decrypted = this.decrypt(encrypted, factory);
                this.extractCredentials(decrypted, factory);
            }
            catch (Throwable e) {
                throw new CCLRuntimeException(e, "Failed to extract credentials");
            }
        }
    }

    private String decrypt(Element encryptedCredential, CAMFactory factory) throws UnsupportedEncodingException, CAMCryptoException {
        String encrString = encryptedCredential.getText();
        byte[] decoded = Base64.decode((String)encrString);
        factory.initialize("<initializeDocument><serviceID>MDSRV</serviceID></initializeDocument>".getBytes("UTF-8"));
        EncryptingSession es = factory.createEncryptingSession();
        byte[] decryptedData = es.decryptData(decoded);
        return new String(decryptedData);
    }
}

